<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign_Organization_Roles_Event_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper for Organization Role Assignment Data. Includes Role Assignments.
 * @subpackage Structs
 */
class Assign_Organization_Roles_Event_DataType extends AbstractStructBase
{
    /**
     * The Role_Assignee_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Position that is the subject of this event, used for business process definition selection and routing. Regardless of value specified, role assignee will be the Position_Reference specified in 'Change_Job_Data' subelement
     * - minOccurs: 0
     * @var \StructType\RoleeObjectType
     */
    public $Role_Assignee_Reference;
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Date the Role Assignments should take effect. Defaults to the current date if not provided.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Effective_Date;
    /**
     * The Role_Assignment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Role_AssignmentType[]
     */
    public $Role_Assignment;
    /**
     * Constructor method for Assign_Organization_Roles_Event_DataType
     * @uses Assign_Organization_Roles_Event_DataType::setRole_Assignee_Reference()
     * @uses Assign_Organization_Roles_Event_DataType::setEffective_Date()
     * @uses Assign_Organization_Roles_Event_DataType::setRole_Assignment()
     * @param \StructType\RoleeObjectType $role_Assignee_Reference
     * @param string $effective_Date
     * @param \StructType\Role_AssignmentType[] $role_Assignment
     */
    public function __construct(\StructType\RoleeObjectType $role_Assignee_Reference = null, $effective_Date = null, array $role_Assignment = array())
    {
        $this
            ->setRole_Assignee_Reference($role_Assignee_Reference)
            ->setEffective_Date($effective_Date)
            ->setRole_Assignment($role_Assignment);
    }
    /**
     * Get Role_Assignee_Reference value
     * @return \StructType\RoleeObjectType|null
     */
    public function getRole_Assignee_Reference()
    {
        return $this->Role_Assignee_Reference;
    }
    /**
     * Set Role_Assignee_Reference value
     * @param \StructType\RoleeObjectType $role_Assignee_Reference
     * @return \StructType\Assign_Organization_Roles_Event_DataType
     */
    public function setRole_Assignee_Reference(\StructType\RoleeObjectType $role_Assignee_Reference = null)
    {
        $this->Role_Assignee_Reference = $role_Assignee_Reference;
        return $this;
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Assign_Organization_Roles_Event_DataType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Role_Assignment value
     * @return \StructType\Role_AssignmentType[]|null
     */
    public function getRole_Assignment()
    {
        return $this->Role_Assignment;
    }
    /**
     * This method is responsible for validating the values passed to the setRole_Assignment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRole_Assignment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRole_AssignmentForArrayConstraintsFromSetRole_Assignment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Organization_Roles_Event_DataTypeRole_AssignmentItem) {
            // validation for constraint: itemType
            if (!$assign_Organization_Roles_Event_DataTypeRole_AssignmentItem instanceof \StructType\Role_AssignmentType) {
                $invalidValues[] = is_object($assign_Organization_Roles_Event_DataTypeRole_AssignmentItem) ? get_class($assign_Organization_Roles_Event_DataTypeRole_AssignmentItem) : sprintf('%s(%s)', gettype($assign_Organization_Roles_Event_DataTypeRole_AssignmentItem), var_export($assign_Organization_Roles_Event_DataTypeRole_AssignmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Role_Assignment property can only contain items of type \StructType\Role_AssignmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Role_Assignment value
     * @throws \InvalidArgumentException
     * @param \StructType\Role_AssignmentType[] $role_Assignment
     * @return \StructType\Assign_Organization_Roles_Event_DataType
     */
    public function setRole_Assignment(array $role_Assignment = array())
    {
        // validation for constraint: array
        if ('' !== ($role_AssignmentArrayErrorMessage = self::validateRole_AssignmentForArrayConstraintsFromSetRole_Assignment($role_Assignment))) {
            throw new \InvalidArgumentException($role_AssignmentArrayErrorMessage, __LINE__);
        }
        $this->Role_Assignment = $role_Assignment;
        return $this;
    }
    /**
     * Add item to Role_Assignment value
     * @throws \InvalidArgumentException
     * @param \StructType\Role_AssignmentType $item
     * @return \StructType\Assign_Organization_Roles_Event_DataType
     */
    public function addToRole_Assignment(\StructType\Role_AssignmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Role_AssignmentType) {
            throw new \InvalidArgumentException(sprintf('The Role_Assignment property can only contain items of type \StructType\Role_AssignmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Role_Assignment[] = $item;
        return $this;
    }
}
