<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assess_Candidate_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: References provided by the web service caller to indicate the Candidate Assessment information to return.
 * @subpackage Structs
 */
class Assess_Candidate_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Assess_Candidate_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Candidate Assessment to be returned to the caller.
     * - choice: Assess_Candidate_Reference | Assessment_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Assess_Candidate_Reference;
    /**
     * The Assessment_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Assessment to be returned to the caller.
     * - choice: Assess_Candidate_Reference | Assessment_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\Recruiting_AssessmentObjectType[]
     */
    public $Assessment_Reference;
    /**
     * Constructor method for Assess_Candidate_Request_ReferencesType
     * @uses Assess_Candidate_Request_ReferencesType::setAssess_Candidate_Reference()
     * @uses Assess_Candidate_Request_ReferencesType::setAssessment_Reference()
     * @param \StructType\Unique_IdentifierObjectType[] $assess_Candidate_Reference
     * @param \StructType\Recruiting_AssessmentObjectType[] $assessment_Reference
     */
    public function __construct(array $assess_Candidate_Reference = array(), array $assessment_Reference = array())
    {
        $this
            ->setAssess_Candidate_Reference($assess_Candidate_Reference)
            ->setAssessment_Reference($assessment_Reference);
    }
    /**
     * Get Assess_Candidate_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getAssess_Candidate_Reference()
    {
        return isset($this->Assess_Candidate_Reference) ? $this->Assess_Candidate_Reference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAssess_Candidate_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssess_Candidate_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssess_Candidate_ReferenceForArrayConstraintsFromSetAssess_Candidate_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assess_Candidate_Request_ReferencesTypeAssess_Candidate_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assess_Candidate_Request_ReferencesTypeAssess_Candidate_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($assess_Candidate_Request_ReferencesTypeAssess_Candidate_ReferenceItem) ? get_class($assess_Candidate_Request_ReferencesTypeAssess_Candidate_ReferenceItem) : sprintf('%s(%s)', gettype($assess_Candidate_Request_ReferencesTypeAssess_Candidate_ReferenceItem), var_export($assess_Candidate_Request_ReferencesTypeAssess_Candidate_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Assess_Candidate_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAssess_Candidate_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssess_Candidate_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAssess_Candidate_ReferenceForChoiceConstraintsFromSetAssess_Candidate_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Assessment_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Assess_Candidate_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Assess_Candidate_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Assess_Candidate_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $assess_Candidate_Reference
     * @return \StructType\Assess_Candidate_Request_ReferencesType
     */
    public function setAssess_Candidate_Reference(array $assess_Candidate_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($assess_Candidate_ReferenceArrayErrorMessage = self::validateAssess_Candidate_ReferenceForArrayConstraintsFromSetAssess_Candidate_Reference($assess_Candidate_Reference))) {
            throw new \InvalidArgumentException($assess_Candidate_ReferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Assess_Candidate_Reference, Assessment_Reference)
        if ('' !== ($assess_Candidate_ReferenceChoiceErrorMessage = self::validateAssess_Candidate_ReferenceForChoiceConstraintsFromSetAssess_Candidate_Reference($assess_Candidate_Reference))) {
            throw new \InvalidArgumentException($assess_Candidate_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($assess_Candidate_Reference) || (is_array($assess_Candidate_Reference) && empty($assess_Candidate_Reference))) {
            unset($this->Assess_Candidate_Reference);
        } else {
            $this->Assess_Candidate_Reference = $assess_Candidate_Reference;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToAssess_Candidate_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToAssess_Candidate_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToAssess_Candidate_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Assessment_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Assess_Candidate_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Assess_Candidate_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Assess_Candidate_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Assess_Candidate_Request_ReferencesType
     */
    public function addToAssess_Candidate_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Assess_Candidate_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Assess_Candidate_Reference, Assessment_Reference)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToAssess_Candidate_Reference($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Assess_Candidate_Reference[] = $item;
        return $this;
    }
    /**
     * Get Assessment_Reference value
     * @return \StructType\Recruiting_AssessmentObjectType[]|null
     */
    public function getAssessment_Reference()
    {
        return isset($this->Assessment_Reference) ? $this->Assessment_Reference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAssessment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssessment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssessment_ReferenceForArrayConstraintsFromSetAssessment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assess_Candidate_Request_ReferencesTypeAssessment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assess_Candidate_Request_ReferencesTypeAssessment_ReferenceItem instanceof \StructType\Recruiting_AssessmentObjectType) {
                $invalidValues[] = is_object($assess_Candidate_Request_ReferencesTypeAssessment_ReferenceItem) ? get_class($assess_Candidate_Request_ReferencesTypeAssessment_ReferenceItem) : sprintf('%s(%s)', gettype($assess_Candidate_Request_ReferencesTypeAssessment_ReferenceItem), var_export($assess_Candidate_Request_ReferencesTypeAssessment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Assessment_Reference property can only contain items of type \StructType\Recruiting_AssessmentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAssessment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssessment_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAssessment_ReferenceForChoiceConstraintsFromSetAssessment_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Assess_Candidate_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Assessment_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Assessment_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Assessment_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_AssessmentObjectType[] $assessment_Reference
     * @return \StructType\Assess_Candidate_Request_ReferencesType
     */
    public function setAssessment_Reference(array $assessment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($assessment_ReferenceArrayErrorMessage = self::validateAssessment_ReferenceForArrayConstraintsFromSetAssessment_Reference($assessment_Reference))) {
            throw new \InvalidArgumentException($assessment_ReferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Assess_Candidate_Reference, Assessment_Reference)
        if ('' !== ($assessment_ReferenceChoiceErrorMessage = self::validateAssessment_ReferenceForChoiceConstraintsFromSetAssessment_Reference($assessment_Reference))) {
            throw new \InvalidArgumentException($assessment_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($assessment_Reference) || (is_array($assessment_Reference) && empty($assessment_Reference))) {
            unset($this->Assessment_Reference);
        } else {
            $this->Assessment_Reference = $assessment_Reference;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToAssessment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToAssessment_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToAssessment_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Assess_Candidate_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Assessment_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Assessment_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Assessment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_AssessmentObjectType $item
     * @return \StructType\Assess_Candidate_Request_ReferencesType
     */
    public function addToAssessment_Reference(\StructType\Recruiting_AssessmentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_AssessmentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Assessment_Reference property can only contain items of type \StructType\Recruiting_AssessmentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Assess_Candidate_Reference, Assessment_Reference)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToAssessment_Reference($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Assessment_Reference[] = $item;
        return $this;
    }
}
