<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Applicants_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the Applicant Data.
 * @subpackage Structs
 */
class Applicants_Response_DataType extends AbstractStructBase
{
    /**
     * The Applicant
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for the Applicant Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Applicant_WWSType[]
     */
    public $Applicant;
    /**
     * Constructor method for Applicants_Response_DataType
     * @uses Applicants_Response_DataType::setApplicant()
     * @param \StructType\Applicant_WWSType[] $applicant
     */
    public function __construct(array $applicant = array())
    {
        $this
            ->setApplicant($applicant);
    }
    /**
     * Get Applicant value
     * @return \StructType\Applicant_WWSType[]|null
     */
    public function getApplicant()
    {
        return $this->Applicant;
    }
    /**
     * This method is responsible for validating the values passed to the setApplicant method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicant method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicantForArrayConstraintsFromSetApplicant(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicants_Response_DataTypeApplicantItem) {
            // validation for constraint: itemType
            if (!$applicants_Response_DataTypeApplicantItem instanceof \StructType\Applicant_WWSType) {
                $invalidValues[] = is_object($applicants_Response_DataTypeApplicantItem) ? get_class($applicants_Response_DataTypeApplicantItem) : sprintf('%s(%s)', gettype($applicants_Response_DataTypeApplicantItem), var_export($applicants_Response_DataTypeApplicantItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Applicant property can only contain items of type \StructType\Applicant_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Applicant value
     * @throws \InvalidArgumentException
     * @param \StructType\Applicant_WWSType[] $applicant
     * @return \StructType\Applicants_Response_DataType
     */
    public function setApplicant(array $applicant = array())
    {
        // validation for constraint: array
        if ('' !== ($applicantArrayErrorMessage = self::validateApplicantForArrayConstraintsFromSetApplicant($applicant))) {
            throw new \InvalidArgumentException($applicantArrayErrorMessage, __LINE__);
        }
        $this->Applicant = $applicant;
        return $this;
    }
    /**
     * Add item to Applicant value
     * @throws \InvalidArgumentException
     * @param \StructType\Applicant_WWSType $item
     * @return \StructType\Applicants_Response_DataType
     */
    public function addToApplicant(\StructType\Applicant_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Applicant_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Applicant property can only contain items of type \StructType\Applicant_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Applicant[] = $item;
        return $this;
    }
}
