<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Applicant_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing the list of applicants for which data is requested.
 * @subpackage Structs
 */
class Applicant_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Applicant_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Applicants being requested. The values are either the Applicant IDs or the Workday IDs.
     * - maxOccurs: unbounded
     * @var \StructType\ApplicantObjectType[]
     */
    public $Applicant_Reference;
    /**
     * Constructor method for Applicant_Request_ReferencesType
     * @uses Applicant_Request_ReferencesType::setApplicant_Reference()
     * @param \StructType\ApplicantObjectType[] $applicant_Reference
     */
    public function __construct(array $applicant_Reference = array())
    {
        $this
            ->setApplicant_Reference($applicant_Reference);
    }
    /**
     * Get Applicant_Reference value
     * @return \StructType\ApplicantObjectType[]|null
     */
    public function getApplicant_Reference()
    {
        return $this->Applicant_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setApplicant_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicant_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicant_ReferenceForArrayConstraintsFromSetApplicant_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicant_Request_ReferencesTypeApplicant_ReferenceItem) {
            // validation for constraint: itemType
            if (!$applicant_Request_ReferencesTypeApplicant_ReferenceItem instanceof \StructType\ApplicantObjectType) {
                $invalidValues[] = is_object($applicant_Request_ReferencesTypeApplicant_ReferenceItem) ? get_class($applicant_Request_ReferencesTypeApplicant_ReferenceItem) : sprintf('%s(%s)', gettype($applicant_Request_ReferencesTypeApplicant_ReferenceItem), var_export($applicant_Request_ReferencesTypeApplicant_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Applicant_Reference property can only contain items of type \StructType\ApplicantObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Applicant_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ApplicantObjectType[] $applicant_Reference
     * @return \StructType\Applicant_Request_ReferencesType
     */
    public function setApplicant_Reference(array $applicant_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($applicant_ReferenceArrayErrorMessage = self::validateApplicant_ReferenceForArrayConstraintsFromSetApplicant_Reference($applicant_Reference))) {
            throw new \InvalidArgumentException($applicant_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Applicant_Reference = $applicant_Reference;
        return $this;
    }
    /**
     * Add item to Applicant_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ApplicantObjectType $item
     * @return \StructType\Applicant_Request_ReferencesType
     */
    public function addToApplicant_Reference(\StructType\ApplicantObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ApplicantObjectType) {
            throw new \InvalidArgumentException(sprintf('The Applicant_Reference property can only contain items of type \StructType\ApplicantObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Applicant_Reference[] = $item;
        return $this;
    }
}
