<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Applicant_Information_HVType StructType
 * Meta information extracted from the WSDL
 * - documentation: The main Wrapper element for the Applicant Data Web Service.
 * @subpackage Structs
 */
class Applicant_Information_HVType extends AbstractStructBase
{
    /**
     * The Applicant_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Applicant
     * - minOccurs: 0
     * @var \StructType\ApplicantObjectType
     */
    public $Applicant_Reference;
    /**
     * The Applicant_Data
     * Meta information extracted from the WSDL
     * - documentation: The Wrapper element for the Applicant Data Web Service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Pre_Hire_Data_WWSType[]
     */
    public $Applicant_Data;
    /**
     * Constructor method for Applicant_Information_HVType
     * @uses Applicant_Information_HVType::setApplicant_Reference()
     * @uses Applicant_Information_HVType::setApplicant_Data()
     * @param \StructType\ApplicantObjectType $applicant_Reference
     * @param \StructType\Pre_Hire_Data_WWSType[] $applicant_Data
     */
    public function __construct(\StructType\ApplicantObjectType $applicant_Reference = null, array $applicant_Data = array())
    {
        $this
            ->setApplicant_Reference($applicant_Reference)
            ->setApplicant_Data($applicant_Data);
    }
    /**
     * Get Applicant_Reference value
     * @return \StructType\ApplicantObjectType|null
     */
    public function getApplicant_Reference()
    {
        return $this->Applicant_Reference;
    }
    /**
     * Set Applicant_Reference value
     * @param \StructType\ApplicantObjectType $applicant_Reference
     * @return \StructType\Applicant_Information_HVType
     */
    public function setApplicant_Reference(\StructType\ApplicantObjectType $applicant_Reference = null)
    {
        $this->Applicant_Reference = $applicant_Reference;
        return $this;
    }
    /**
     * Get Applicant_Data value
     * @return \StructType\Pre_Hire_Data_WWSType[]|null
     */
    public function getApplicant_Data()
    {
        return $this->Applicant_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setApplicant_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicant_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicant_DataForArrayConstraintsFromSetApplicant_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicant_Information_HVTypeApplicant_DataItem) {
            // validation for constraint: itemType
            if (!$applicant_Information_HVTypeApplicant_DataItem instanceof \StructType\Pre_Hire_Data_WWSType) {
                $invalidValues[] = is_object($applicant_Information_HVTypeApplicant_DataItem) ? get_class($applicant_Information_HVTypeApplicant_DataItem) : sprintf('%s(%s)', gettype($applicant_Information_HVTypeApplicant_DataItem), var_export($applicant_Information_HVTypeApplicant_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Applicant_Data property can only contain items of type \StructType\Pre_Hire_Data_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Applicant_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Pre_Hire_Data_WWSType[] $applicant_Data
     * @return \StructType\Applicant_Information_HVType
     */
    public function setApplicant_Data(array $applicant_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($applicant_DataArrayErrorMessage = self::validateApplicant_DataForArrayConstraintsFromSetApplicant_Data($applicant_Data))) {
            throw new \InvalidArgumentException($applicant_DataArrayErrorMessage, __LINE__);
        }
        $this->Applicant_Data = $applicant_Data;
        return $this;
    }
    /**
     * Add item to Applicant_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Pre_Hire_Data_WWSType $item
     * @return \StructType\Applicant_Information_HVType
     */
    public function addToApplicant_Data(\StructType\Pre_Hire_Data_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pre_Hire_Data_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Applicant_Data property can only contain items of type \StructType\Pre_Hire_Data_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Applicant_Data[] = $item;
        return $this;
    }
}
