<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Get_Server_Timestamp
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation retrieves Workday's current system datetime.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Server_Timestamp_GetType $body
     * @return \StructType\Server_TimestampType|bool
     */
    public function Get_Server_Timestamp(\StructType\Server_Timestamp_GetType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Server_Timestamp($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Applicants
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns information for pre-hires specified in the request. If the request does not specify a pre-hire, this operation returns information for all pre-hires. Note: pre-hire was previously called applicant. However, the web service
     * operation and its elements are not yet renamed, so that existing integrations continue to work.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Applicants_RequestType $body
     * @return \StructType\Get_Applicants_ResponseType|bool
     */
    public function Get_Applicants(\StructType\Get_Applicants_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Applicants($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Positions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns information for position management positions. If a position is filled, identifies the worker filling the position.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Positions_RequestType $body
     * @return \StructType\Get_Positions_ResponseType|bool
     */
    public function Get_Positions(\StructType\Get_Positions_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Positions($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Organizations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns organizations for these organization types: Company, Cost Center, Custom, Matrix, Pay Group, Region, Retiree, Supervisory, Company Hierarchy, Cost Center Hierarchy, Location Hierarchy, Region Hierarchy.The request criteria
     * enables you to specify organization types or organizations. If no request criteria is specified, all active organizations are returned. Inactive organizations are also returned if Include_Inactive is set to True.The Transaction Log service doesn't
     * capture changes to organization data such as organization name and code. To enable your integration to detect these types of changes, disable the Transaction Log service by leaving the Transaction_Log_Criteria subelement within
     * Organization_Request_Criteria empty. If you don't disable the Transaction Log Service, only organizations that match the configuration in both the Organization_Request_Criteria and Transaction_Log_Criteria are returned.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Organizations_RequestType $body
     * @return \StructType\Get_Organizations_ResponseType|bool
     */
    public function Get_Organizations(\StructType\Get_Organizations_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Organizations($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Job_Requisitions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns information for job requisitions and provides a reference to the related position.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Job_Requisitions_RequestType $body
     * @return \StructType\Get_Job_Requisitions_ResponseType|bool
     */
    public function Get_Job_Requisitions(\StructType\Get_Job_Requisitions_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Job_Requisitions($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Candidates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns information for candidates specified in the request.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Candidates_RequestType $body
     * @return \StructType\Get_Candidates_ResponseType|bool
     */
    public function Get_Candidates(\StructType\Get_Candidates_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Candidates($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Candidate_Attachments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation returns attachments for a Candidate and/or a Candidate's Job Application.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Candidate_Attachments_RequestType $body
     * @return \StructType\Get_Candidate_Attachments_ResponseType|bool
     */
    public function Get_Candidate_Attachments(\StructType\Get_Candidate_Attachments_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Candidate_Attachments($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Job_Posting_Sites
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Provides an Integration Partner the ability to GET a posting site details in the Posting Site Setup table through a webservice.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Job_Posting_Sites_RequestType $body
     * @return \StructType\Get_Job_Posting_Sites_ResponseType|bool
     */
    public function Get_Job_Posting_Sites(\StructType\Get_Job_Posting_Sites_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Job_Posting_Sites($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Candidate_Photos
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation returns the image for a Candidate.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Candidate_Photos_RequestType $body
     * @return \StructType\Get_Candidate_Photos_ResponseType|bool
     */
    public function Get_Candidate_Photos(\StructType\Get_Candidate_Photos_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Candidate_Photos($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Background_Check_Packages
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns information for Background Check Packages specified in the request.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Background_Check_Packages_RequestType $body
     * @return \StructType\Get_Background_Check_Packages_ResponseType|bool
     */
    public function Get_Background_Check_Packages(\StructType\Get_Background_Check_Packages_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Background_Check_Packages($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Background_Check
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieve background check results for a Background Check Event.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Background_Check_RequestType $body
     * @return \StructType\Get_Background_Check_ResponseType|bool
     */
    public function Get_Background_Check(\StructType\Get_Background_Check_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Background_Check($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Job_Postings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns information for Job Postings specified in the requests.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Job_Postings_RequestType $body
     * @return \StructType\Get_Job_Postings_ResponseType|bool
     */
    public function Get_Job_Postings(\StructType\Get_Job_Postings_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Job_Postings($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Questionnaires
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns individual or multiple questionnaires.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Questionnaires_RequestType $body
     * @return \StructType\Get_Questionnaires_ResponseType|bool
     */
    public function Get_Questionnaires(\StructType\Get_Questionnaires_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Questionnaires($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Assess_Candidate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieve information about Candidate Assessments.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Assess_Candidate_RequestType $body
     * @return \StructType\Get_Assess_Candidate_ResponseType|bool
     */
    public function Get_Assess_Candidate(\StructType\Get_Assess_Candidate_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Assess_Candidate($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Evergreen_Requisitions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns information for evergreen requisitions and provides a reference to the related position.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Evergreen_Requisitions_RequestType $body
     * @return \StructType\Get_Evergreen_Requisitions_ResponseType|bool
     */
    public function Get_Evergreen_Requisitions(\StructType\Get_Evergreen_Requisitions_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Evergreen_Requisitions($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Recruiting_Agency_Users
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Get Recruiting Agency Users.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Recruiting_Agency_Users_RequestType $body
     * @return \StructType\Get_Recruiting_Agency_Users_ResponseType|bool
     */
    public function Get_Recruiting_Agency_Users(\StructType\Get_Recruiting_Agency_Users_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Recruiting_Agency_Users($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Job_Application_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Get Additional data for Job ApplicationYes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Job_Application_Additional_Data_RequestType $body
     * @return \StructType\Get_Job_Application_Additional_Data_ResponseType|bool
     */
    public function Get_Job_Application_Additional_Data(\StructType\Get_Job_Application_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Job_Application_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Recruiting_Agencies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Get Recruiting AgenciesYes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Recruiting_Agencies_RequestType $body
     * @return \StructType\Get_Recruiting_Agencies_ResponseType|bool
     */
    public function Get_Recruiting_Agencies(\StructType\Get_Recruiting_Agencies_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Recruiting_Agencies($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Recruiting_Agency_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves additional data associated with the supplied Recruiting Agency.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Recruiting_Agency_Additional_Data_RequestType $body
     * @return \StructType\Get_Recruiting_Agency_Additional_Data_ResponseType|bool
     */
    public function Get_Recruiting_Agency_Additional_Data(\StructType\Get_Recruiting_Agency_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Recruiting_Agency_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Job_Requisition_Interview_Settings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web services for Manage Interview Team task.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Job_Requisition_Interview_Settings_RequestType $body
     * @return \StructType\Get_Job_Requisition_Interview_Settings_ResponseType|bool
     */
    public function Get_Job_Requisition_Interview_Settings(\StructType\Get_Job_Requisition_Interview_Settings_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Job_Requisition_Interview_Settings($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Interviews
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves Interview Data for the Schedule Interview task.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Interviews_RequestType $body
     * @return \StructType\Get_Interviews_ResponseType|bool
     */
    public function Get_Interviews(\StructType\Get_Interviews_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Interviews($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Interview_Feedbacks
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves Interview Feedback Data for the Manage Interview Feedback task.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Interview_Feedbacks_RequestType $body
     * @return \StructType\Get_Interview_Feedbacks_ResponseType|bool
     */
    public function Get_Interview_Feedbacks(\StructType\Get_Interview_Feedbacks_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Interview_Feedbacks($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Veteran_Statuses
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Veteran Statuses by Reference ID, or returns all Veteran Statuses if no Reference ID is provided.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Veteran_Statuses_RequestType $body
     * @return \StructType\Get_Veteran_Statuses_ResponseType|bool
     */
    public function Get_Veteran_Statuses(\StructType\Get_Veteran_Statuses_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Veteran_Statuses($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Recruiting_Self-Schedule_Calendar_Types
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to retrieve Recruiting Self-Schedule Calendar Types.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Recruiting_Self_Schedule_Calendar_Types_RequestType $body
     * @return \StructType\Get_Recruiting_Self_Schedule_Calendar_Types_ResponseType|bool
     */
    public function Get_Recruiting_Self_Schedule_Calendar_Types(\StructType\Get_Recruiting_Self_Schedule_Calendar_Types_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->__call('Get_Recruiting_Self-Schedule_Calendar_Types', array(
                $body,
            )));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Assign_Recruiting_Self-Schedule_Calendars
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to retrieve Recruiting Self-Schedule Calendar Assignments.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Assign_Recruiting_Self_Schedule_Calendars_RequestType $body
     * @return \StructType\Get_Assign_Recruiting_Self_Schedule_Calendars_ResponseType|bool
     */
    public function Get_Assign_Recruiting_Self_Schedule_Calendars(\StructType\Get_Assign_Recruiting_Self_Schedule_Calendars_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->__call('Get_Assign_Recruiting_Self-Schedule_Calendars', array(
                $body,
            )));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Recruiting_Self-Schedule_Calendars
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to retrieve Recruiting Self-Schedule Calendars.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Recruiting_Self_Schedule_Calendars_RequestType $body
     * @return \StructType\Get_Recruiting_Self_Schedule_Calendars_ResponseType|bool
     */
    public function Get_Recruiting_Self_Schedule_Calendars(\StructType\Get_Recruiting_Self_Schedule_Calendars_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->__call('Get_Recruiting_Self-Schedule_Calendars', array(
                $body,
            )));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Recruiting_Assessment_Categories
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Recruiting Assessment Categories data.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Recruiting_Assessment_Categories_RequestType $body
     * @return \StructType\Get_Recruiting_Assessment_Categories_ResponseType|bool
     */
    public function Get_Recruiting_Assessment_Categories(\StructType\Get_Recruiting_Assessment_Categories_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Recruiting_Assessment_Categories($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Recruiting_Assessment_Category_Security_Segments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to retrieve Recruiting Assessment Category Security Segments.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Recruiting_Assessment_Category_Security_Segments_RequestType $body
     * @return \StructType\Get_Recruiting_Assessment_Category_Security_Segments_ResponseType|bool
     */
    public function Get_Recruiting_Assessment_Category_Security_Segments(\StructType\Get_Recruiting_Assessment_Category_Security_Segments_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Recruiting_Assessment_Category_Security_Segments($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Maintain_Candidate_List_Assignment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves the Job Requisition Rules with Candidate List Grid ConfigurationsNot Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Maintain_Candidate_List_Assignment_RequestType $body
     * @return \StructType\Get_Maintain_Candidate_List_Assignment_ResponseType|bool
     */
    public function Get_Maintain_Candidate_List_Assignment(\StructType\Get_Maintain_Candidate_List_Assignment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Maintain_Candidate_List_Assignment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Site_Brands
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Get Site Brands information.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Site_Brands_RequestType $body
     * @return \StructType\Get_Site_Brands_ResponseType|bool
     */
    public function Get_Site_Brands(\StructType\Get_Site_Brands_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Site_Brands($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Job_Application_Template_Translation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves translation values for a job application templateNot Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Job_Application_Template_Translation_RequestType $body
     * @return \StructType\Get_Job_Application_Template_Translation_ResponseType|bool
     */
    public function Get_Job_Application_Template_Translation(\StructType\Get_Job_Application_Template_Translation_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Job_Application_Template_Translation($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Masked_Recruiting_Configurations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: The information returned from Masked Recruiting Configurations specified in the web service request.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Masked_Recruiting_Configurations_RequestType $body
     * @return \StructType\Get_Masked_Recruiting_Configurations_ResponseType|bool
     */
    public function Get_Masked_Recruiting_Configurations(\StructType\Get_Masked_Recruiting_Configurations_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Masked_Recruiting_Configurations($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Masked_Job_Requisition_Defaults
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to retrieve Masked Job Requisition Defaults.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Masked_Job_Requisition_Defaults_RequestType $body
     * @return \StructType\Get_Masked_Job_Requisition_Defaults_ResponseType|bool
     */
    public function Get_Masked_Job_Requisition_Defaults(\StructType\Get_Masked_Job_Requisition_Defaults_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Masked_Job_Requisition_Defaults($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Referees
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to get all Referees for a Reference Check Event.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Referees_RequestType $body
     * @return \StructType\Get_Referees_ResponseType|bool
     */
    public function Get_Referees(\StructType\Get_Referees_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Referees($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_External_Reference
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to get all External References for a Reference Check Event.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_External_Reference_RequestType $body
     * @return \StructType\Get_External_Reference_ResponseType|bool
     */
    public function Get_External_Reference(\StructType\Get_External_Reference_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_External_Reference($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Web_Conference_Interview_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to retrieve interview data for the web conference.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Web_Conference_Interview_Data_RequestType $body
     * @return \StructType\Get_Web_Conference_Interview_Data_ResponseType|bool
     */
    public function Get_Web_Conference_Interview_Data(\StructType\Get_Web_Conference_Interview_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Web_Conference_Interview_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Get_Applicants_ResponseType|\StructType\Get_Assess_Candidate_ResponseType|\StructType\Get_Assign_Recruiting_Self_Schedule_Calendars_ResponseType|\StructType\Get_Background_Check_Packages_ResponseType|\StructType\Get_Background_Check_ResponseType|\StructType\Get_Candidates_ResponseType|\StructType\Get_Candidate_Attachments_ResponseType|\StructType\Get_Candidate_Photos_ResponseType|\StructType\Get_Evergreen_Requisitions_ResponseType|\StructType\Get_External_Reference_ResponseType|\StructType\Get_Interviews_ResponseType|\StructType\Get_Interview_Feedbacks_ResponseType|\StructType\Get_Job_Application_Additional_Data_ResponseType|\StructType\Get_Job_Application_Template_Translation_ResponseType|\StructType\Get_Job_Postings_ResponseType|\StructType\Get_Job_Posting_Sites_ResponseType|\StructType\Get_Job_Requisitions_ResponseType|\StructType\Get_Job_Requisition_Interview_Settings_ResponseType|\StructType\Get_Maintain_Candidate_List_Assignment_ResponseType|\StructType\Get_Masked_Job_Requisition_Defaults_ResponseType|\StructType\Get_Masked_Recruiting_Configurations_ResponseType|\StructType\Get_Organizations_ResponseType|\StructType\Get_Positions_ResponseType|\StructType\Get_Questionnaires_ResponseType|\StructType\Get_Recruiting_Agencies_ResponseType|\StructType\Get_Recruiting_Agency_Additional_Data_ResponseType|\StructType\Get_Recruiting_Agency_Users_ResponseType|\StructType\Get_Recruiting_Assessment_Categories_ResponseType|\StructType\Get_Recruiting_Assessment_Category_Security_Segments_ResponseType|\StructType\Get_Recruiting_Self_Schedule_Calendars_ResponseType|\StructType\Get_Recruiting_Self_Schedule_Calendar_Types_ResponseType|\StructType\Get_Referees_ResponseType|\StructType\Get_Site_Brands_ResponseType|\StructType\Get_Veteran_Statuses_ResponseType|\StructType\Get_Web_Conference_Interview_Data_ResponseType|\StructType\Server_TimestampType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
