<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worker_For_Filled_PositionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Worker Filling Position.
 * @subpackage Structs
 */
class Worker_For_Filled_PositionType extends AbstractStructBase
{
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the ID of the worker. The ID consists of a type attribute, which should be set to "Employee_ID" or "Contingent_Worker_ID", and a value attribute, such as "04345". If Skip Non Existing Instances value is set to true.
     * When a reference id value that does not meet the entry date criteria is passed, the non existent reference id will be ignored.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Position_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier to reference a Position.
     * - minOccurs: 0
     * @var \StructType\PositionObjectType
     */
    public $Position_Reference;
    /**
     * Constructor method for Worker_For_Filled_PositionType
     * @uses Worker_For_Filled_PositionType::setWorker_Reference()
     * @uses Worker_For_Filled_PositionType::setPosition_Reference()
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param \StructType\PositionObjectType $position_Reference
     */
    public function __construct(\StructType\WorkerObjectType $worker_Reference = null, \StructType\PositionObjectType $position_Reference = null)
    {
        $this
            ->setWorker_Reference($worker_Reference)
            ->setPosition_Reference($position_Reference);
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Worker_For_Filled_PositionType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Position_Reference value
     * @return \StructType\PositionObjectType|null
     */
    public function getPosition_Reference()
    {
        return $this->Position_Reference;
    }
    /**
     * Set Position_Reference value
     * @param \StructType\PositionObjectType $position_Reference
     * @return \StructType\Worker_For_Filled_PositionType
     */
    public function setPosition_Reference(\StructType\PositionObjectType $position_Reference = null)
    {
        $this->Position_Reference = $position_Reference;
        return $this;
    }
}
