<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Work_Experience_Profile_for_Job_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the work experience profile's information for a position.
 * @subpackage Structs
 */
class Work_Experience_Profile_for_Job_DataType extends AbstractStructBase
{
    /**
     * The Work_Experience_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the work experience.
     * - minOccurs: 0
     * @var \StructType\Work_Experience_QualificationObjectType
     */
    public $Work_Experience_Reference;
    /**
     * The Work_Experience_Rating_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the work experience rating.
     * - minOccurs: 0
     * @var \StructType\Work_Experience_RatingObjectType
     */
    public $Work_Experience_Rating_Reference;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the profile is required for this position.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required;
    /**
     * The Qualification_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The source (job profile or position) reference from which the qualification came from.
     * - minOccurs: 0
     * @var \StructType\Talent_Qualification_EnabledObjectType
     */
    public $Qualification_Source_Reference;
    /**
     * Constructor method for Work_Experience_Profile_for_Job_DataType
     * @uses Work_Experience_Profile_for_Job_DataType::setWork_Experience_Reference()
     * @uses Work_Experience_Profile_for_Job_DataType::setWork_Experience_Rating_Reference()
     * @uses Work_Experience_Profile_for_Job_DataType::setRequired()
     * @uses Work_Experience_Profile_for_Job_DataType::setQualification_Source_Reference()
     * @param \StructType\Work_Experience_QualificationObjectType $work_Experience_Reference
     * @param \StructType\Work_Experience_RatingObjectType $work_Experience_Rating_Reference
     * @param bool $required
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     */
    public function __construct(\StructType\Work_Experience_QualificationObjectType $work_Experience_Reference = null, \StructType\Work_Experience_RatingObjectType $work_Experience_Rating_Reference = null, $required = null, \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this
            ->setWork_Experience_Reference($work_Experience_Reference)
            ->setWork_Experience_Rating_Reference($work_Experience_Rating_Reference)
            ->setRequired($required)
            ->setQualification_Source_Reference($qualification_Source_Reference);
    }
    /**
     * Get Work_Experience_Reference value
     * @return \StructType\Work_Experience_QualificationObjectType|null
     */
    public function getWork_Experience_Reference()
    {
        return $this->Work_Experience_Reference;
    }
    /**
     * Set Work_Experience_Reference value
     * @param \StructType\Work_Experience_QualificationObjectType $work_Experience_Reference
     * @return \StructType\Work_Experience_Profile_for_Job_DataType
     */
    public function setWork_Experience_Reference(\StructType\Work_Experience_QualificationObjectType $work_Experience_Reference = null)
    {
        $this->Work_Experience_Reference = $work_Experience_Reference;
        return $this;
    }
    /**
     * Get Work_Experience_Rating_Reference value
     * @return \StructType\Work_Experience_RatingObjectType|null
     */
    public function getWork_Experience_Rating_Reference()
    {
        return $this->Work_Experience_Rating_Reference;
    }
    /**
     * Set Work_Experience_Rating_Reference value
     * @param \StructType\Work_Experience_RatingObjectType $work_Experience_Rating_Reference
     * @return \StructType\Work_Experience_Profile_for_Job_DataType
     */
    public function setWork_Experience_Rating_Reference(\StructType\Work_Experience_RatingObjectType $work_Experience_Rating_Reference = null)
    {
        $this->Work_Experience_Rating_Reference = $work_Experience_Rating_Reference;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \StructType\Work_Experience_Profile_for_Job_DataType
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get Qualification_Source_Reference value
     * @return \StructType\Talent_Qualification_EnabledObjectType|null
     */
    public function getQualification_Source_Reference()
    {
        return $this->Qualification_Source_Reference;
    }
    /**
     * Set Qualification_Source_Reference value
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     * @return \StructType\Work_Experience_Profile_for_Job_DataType
     */
    public function setQualification_Source_Reference(\StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this->Qualification_Source_Reference = $qualification_Source_Reference;
        return $this;
    }
}
