<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Veteran_Status_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Veteran Status data.
 * @subpackage Structs
 */
class Veteran_Status_Response_DataType extends AbstractStructBase
{
    /**
     * The Veteran_Status
     * Meta information extracted from the WSDL
     * - documentation: Contains ID, Order, Veteran Status Name, Description, Inactive, and Global Setup Data Mapping.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Veteran_StatusType[]
     */
    public $Veteran_Status;
    /**
     * Constructor method for Veteran_Status_Response_DataType
     * @uses Veteran_Status_Response_DataType::setVeteran_Status()
     * @param \StructType\Veteran_StatusType[] $veteran_Status
     */
    public function __construct(array $veteran_Status = array())
    {
        $this
            ->setVeteran_Status($veteran_Status);
    }
    /**
     * Get Veteran_Status value
     * @return \StructType\Veteran_StatusType[]|null
     */
    public function getVeteran_Status()
    {
        return $this->Veteran_Status;
    }
    /**
     * This method is responsible for validating the values passed to the setVeteran_Status method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVeteran_Status method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVeteran_StatusForArrayConstraintsFromSetVeteran_Status(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $veteran_Status_Response_DataTypeVeteran_StatusItem) {
            // validation for constraint: itemType
            if (!$veteran_Status_Response_DataTypeVeteran_StatusItem instanceof \StructType\Veteran_StatusType) {
                $invalidValues[] = is_object($veteran_Status_Response_DataTypeVeteran_StatusItem) ? get_class($veteran_Status_Response_DataTypeVeteran_StatusItem) : sprintf('%s(%s)', gettype($veteran_Status_Response_DataTypeVeteran_StatusItem), var_export($veteran_Status_Response_DataTypeVeteran_StatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Veteran_Status property can only contain items of type \StructType\Veteran_StatusType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Veteran_Status value
     * @throws \InvalidArgumentException
     * @param \StructType\Veteran_StatusType[] $veteran_Status
     * @return \StructType\Veteran_Status_Response_DataType
     */
    public function setVeteran_Status(array $veteran_Status = array())
    {
        // validation for constraint: array
        if ('' !== ($veteran_StatusArrayErrorMessage = self::validateVeteran_StatusForArrayConstraintsFromSetVeteran_Status($veteran_Status))) {
            throw new \InvalidArgumentException($veteran_StatusArrayErrorMessage, __LINE__);
        }
        $this->Veteran_Status = $veteran_Status;
        return $this;
    }
    /**
     * Add item to Veteran_Status value
     * @throws \InvalidArgumentException
     * @param \StructType\Veteran_StatusType $item
     * @return \StructType\Veteran_Status_Response_DataType
     */
    public function addToVeteran_Status(\StructType\Veteran_StatusType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Veteran_StatusType) {
            throw new \InvalidArgumentException(sprintf('The Veteran_Status property can only contain items of type \StructType\Veteran_StatusType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Veteran_Status[] = $item;
        return $this;
    }
}
