<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Veteran_Status_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains ID, Order, Veteran Status Name, Description, Inactive, and Global Setup Data Mapping.
 * @subpackage Structs
 */
class Veteran_Status_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: No duplicate Veteran Status IDs. | Unique identifier for the Veteran Status.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: The order of the job requisition interview team session. | Order | The order for the Recruiting Self-Schedule Calendar Type. | The Row Order | An alphanumeric value indicating the order of this row.
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Veteran_Status_Name
     * Meta information extracted from the WSDL
     * - documentation: No duplicate Veteran Status Names. | Veteran Status Name must be provided. | Veteran Status name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Veteran_Status_Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Veteran Status description.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether Veteran Status is active/inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Global_Setup_Data_Mapping_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must provide global setup data mapping. | Global setup data mapping.
     * - minOccurs: 0
     * @var \StructType\Global_Setup_Data_MappingObjectType
     */
    public $Global_Setup_Data_Mapping_Reference;
    /**
     * Constructor method for Veteran_Status_DataType
     * @uses Veteran_Status_DataType::setID()
     * @uses Veteran_Status_DataType::setOrder()
     * @uses Veteran_Status_DataType::setVeteran_Status_Name()
     * @uses Veteran_Status_DataType::setDescription()
     * @uses Veteran_Status_DataType::setInactive()
     * @uses Veteran_Status_DataType::setGlobal_Setup_Data_Mapping_Reference()
     * @param string $iD
     * @param string $order
     * @param string $veteran_Status_Name
     * @param string $description
     * @param bool $inactive
     * @param \StructType\Global_Setup_Data_MappingObjectType $global_Setup_Data_Mapping_Reference
     */
    public function __construct($iD = null, $order = null, $veteran_Status_Name = null, $description = null, $inactive = null, \StructType\Global_Setup_Data_MappingObjectType $global_Setup_Data_Mapping_Reference = null)
    {
        $this
            ->setID($iD)
            ->setOrder($order)
            ->setVeteran_Status_Name($veteran_Status_Name)
            ->setDescription($description)
            ->setInactive($inactive)
            ->setGlobal_Setup_Data_Mapping_Reference($global_Setup_Data_Mapping_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Veteran_Status_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Veteran_Status_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($order) && mb_strlen($order) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Veteran_Status_Name value
     * @return string|null
     */
    public function getVeteran_Status_Name()
    {
        return $this->Veteran_Status_Name;
    }
    /**
     * Set Veteran_Status_Name value
     * @param string $veteran_Status_Name
     * @return \StructType\Veteran_Status_DataType
     */
    public function setVeteran_Status_Name($veteran_Status_Name = null)
    {
        // validation for constraint: string
        if (!is_null($veteran_Status_Name) && !is_string($veteran_Status_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($veteran_Status_Name, true), gettype($veteran_Status_Name)), __LINE__);
        }
        $this->Veteran_Status_Name = $veteran_Status_Name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Veteran_Status_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Veteran_Status_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Global_Setup_Data_Mapping_Reference value
     * @return \StructType\Global_Setup_Data_MappingObjectType|null
     */
    public function getGlobal_Setup_Data_Mapping_Reference()
    {
        return $this->Global_Setup_Data_Mapping_Reference;
    }
    /**
     * Set Global_Setup_Data_Mapping_Reference value
     * @param \StructType\Global_Setup_Data_MappingObjectType $global_Setup_Data_Mapping_Reference
     * @return \StructType\Veteran_Status_DataType
     */
    public function setGlobal_Setup_Data_Mapping_Reference(\StructType\Global_Setup_Data_MappingObjectType $global_Setup_Data_Mapping_Reference = null)
    {
        $this->Global_Setup_Data_Mapping_Reference = $global_Setup_Data_Mapping_Reference;
        return $this;
    }
}
