<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Update_Job_Posting_Business_Process_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Run an Update Job Posting Event.
 * @subpackage Structs
 */
class Update_Job_Posting_Business_Process_DataType extends AbstractStructBase
{
    /**
     * The Job_Posting_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Posting to be updated.
     * - choice: Job_Posting_Reference | Job_Posting_Reference_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_PostingObjectType
     */
    public $Job_Posting_Reference;
    /**
     * The Job_Posting_Reference_Data
     * Meta information extracted from the WSDL
     * - choice: Job_Posting_Reference | Job_Posting_Reference_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_Posting_Reference_DataType
     */
    public $Job_Posting_Reference_Data;
    /**
     * The Job_Posting_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Update_Job_Posting_DataType[]
     */
    public $Job_Posting_Data;
    /**
     * Constructor method for Update_Job_Posting_Business_Process_DataType
     * @uses Update_Job_Posting_Business_Process_DataType::setJob_Posting_Reference()
     * @uses Update_Job_Posting_Business_Process_DataType::setJob_Posting_Reference_Data()
     * @uses Update_Job_Posting_Business_Process_DataType::setJob_Posting_Data()
     * @param \StructType\Job_PostingObjectType $job_Posting_Reference
     * @param \StructType\Job_Posting_Reference_DataType $job_Posting_Reference_Data
     * @param \StructType\Update_Job_Posting_DataType[] $job_Posting_Data
     */
    public function __construct(\StructType\Job_PostingObjectType $job_Posting_Reference = null, \StructType\Job_Posting_Reference_DataType $job_Posting_Reference_Data = null, array $job_Posting_Data = array())
    {
        $this
            ->setJob_Posting_Reference($job_Posting_Reference)
            ->setJob_Posting_Reference_Data($job_Posting_Reference_Data)
            ->setJob_Posting_Data($job_Posting_Data);
    }
    /**
     * Get Job_Posting_Reference value
     * @return \StructType\Job_PostingObjectType|null
     */
    public function getJob_Posting_Reference()
    {
        return isset($this->Job_Posting_Reference) ? $this->Job_Posting_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Posting_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Posting_ReferenceForChoiceConstraintsFromSetJob_Posting_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Posting_Reference_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Posting_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Posting_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Posting_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_PostingObjectType $job_Posting_Reference
     * @return \StructType\Update_Job_Posting_Business_Process_DataType
     */
    public function setJob_Posting_Reference(\StructType\Job_PostingObjectType $job_Posting_Reference = null)
    {
        // validation for constraint: choice(Job_Posting_Reference, Job_Posting_Reference_Data)
        if ('' !== ($job_Posting_ReferenceChoiceErrorMessage = self::validateJob_Posting_ReferenceForChoiceConstraintsFromSetJob_Posting_Reference($job_Posting_Reference))) {
            throw new \InvalidArgumentException($job_Posting_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Posting_Reference) || (is_array($job_Posting_Reference) && empty($job_Posting_Reference))) {
            unset($this->Job_Posting_Reference);
        } else {
            $this->Job_Posting_Reference = $job_Posting_Reference;
        }
        return $this;
    }
    /**
     * Get Job_Posting_Reference_Data value
     * @return \StructType\Job_Posting_Reference_DataType|null
     */
    public function getJob_Posting_Reference_Data()
    {
        return isset($this->Job_Posting_Reference_Data) ? $this->Job_Posting_Reference_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Posting_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Reference_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Posting_Reference_DataForChoiceConstraintsFromSetJob_Posting_Reference_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Posting_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Posting_Reference_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Posting_Reference_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Posting_Reference_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_Reference_DataType $job_Posting_Reference_Data
     * @return \StructType\Update_Job_Posting_Business_Process_DataType
     */
    public function setJob_Posting_Reference_Data(\StructType\Job_Posting_Reference_DataType $job_Posting_Reference_Data = null)
    {
        // validation for constraint: choice(Job_Posting_Reference, Job_Posting_Reference_Data)
        if ('' !== ($job_Posting_Reference_DataChoiceErrorMessage = self::validateJob_Posting_Reference_DataForChoiceConstraintsFromSetJob_Posting_Reference_Data($job_Posting_Reference_Data))) {
            throw new \InvalidArgumentException($job_Posting_Reference_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Posting_Reference_Data) || (is_array($job_Posting_Reference_Data) && empty($job_Posting_Reference_Data))) {
            unset($this->Job_Posting_Reference_Data);
        } else {
            $this->Job_Posting_Reference_Data = $job_Posting_Reference_Data;
        }
        return $this;
    }
    /**
     * Get Job_Posting_Data value
     * @return \StructType\Update_Job_Posting_DataType[]|null
     */
    public function getJob_Posting_Data()
    {
        return $this->Job_Posting_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Posting_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Posting_DataForArrayConstraintsFromSetJob_Posting_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $update_Job_Posting_Business_Process_DataTypeJob_Posting_DataItem) {
            // validation for constraint: itemType
            if (!$update_Job_Posting_Business_Process_DataTypeJob_Posting_DataItem instanceof \StructType\Update_Job_Posting_DataType) {
                $invalidValues[] = is_object($update_Job_Posting_Business_Process_DataTypeJob_Posting_DataItem) ? get_class($update_Job_Posting_Business_Process_DataTypeJob_Posting_DataItem) : sprintf('%s(%s)', gettype($update_Job_Posting_Business_Process_DataTypeJob_Posting_DataItem), var_export($update_Job_Posting_Business_Process_DataTypeJob_Posting_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Posting_Data property can only contain items of type \StructType\Update_Job_Posting_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Posting_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Update_Job_Posting_DataType[] $job_Posting_Data
     * @return \StructType\Update_Job_Posting_Business_Process_DataType
     */
    public function setJob_Posting_Data(array $job_Posting_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Posting_DataArrayErrorMessage = self::validateJob_Posting_DataForArrayConstraintsFromSetJob_Posting_Data($job_Posting_Data))) {
            throw new \InvalidArgumentException($job_Posting_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Posting_Data = $job_Posting_Data;
        return $this;
    }
    /**
     * Add item to Job_Posting_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Update_Job_Posting_DataType $item
     * @return \StructType\Update_Job_Posting_Business_Process_DataType
     */
    public function addToJob_Posting_Data(\StructType\Update_Job_Posting_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Update_Job_Posting_DataType) {
            throw new \InvalidArgumentException(sprintf('The Job_Posting_Data property can only contain items of type \StructType\Update_Job_Posting_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Posting_Data[] = $item;
        return $this;
    }
}
