<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Unpost_Job_Business_Process_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data for unposting a job.
 * @subpackage Structs
 */
class Unpost_Job_Business_Process_DataType extends AbstractStructBase
{
    /**
     * The Job_Posting_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Posting to unpost.
     * - choice: Job_Posting_Reference | Job_Posting_Site_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_PostingObjectType
     */
    public $Job_Posting_Reference;
    /**
     * The Job_Posting_Site_Data
     * Meta information extracted from the WSDL
     * - documentation: Data used to identify the Job Posting when no Job Posting Reference is supplied.
     * - choice: Job_Posting_Reference | Job_Posting_Site_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_Posting_Reference_DataType
     */
    public $Job_Posting_Site_Data;
    /**
     * Constructor method for Unpost_Job_Business_Process_DataType
     * @uses Unpost_Job_Business_Process_DataType::setJob_Posting_Reference()
     * @uses Unpost_Job_Business_Process_DataType::setJob_Posting_Site_Data()
     * @param \StructType\Job_PostingObjectType $job_Posting_Reference
     * @param \StructType\Job_Posting_Reference_DataType $job_Posting_Site_Data
     */
    public function __construct(\StructType\Job_PostingObjectType $job_Posting_Reference = null, \StructType\Job_Posting_Reference_DataType $job_Posting_Site_Data = null)
    {
        $this
            ->setJob_Posting_Reference($job_Posting_Reference)
            ->setJob_Posting_Site_Data($job_Posting_Site_Data);
    }
    /**
     * Get Job_Posting_Reference value
     * @return \StructType\Job_PostingObjectType|null
     */
    public function getJob_Posting_Reference()
    {
        return isset($this->Job_Posting_Reference) ? $this->Job_Posting_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Posting_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Posting_ReferenceForChoiceConstraintsFromSetJob_Posting_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Posting_Site_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Posting_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Posting_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Posting_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_PostingObjectType $job_Posting_Reference
     * @return \StructType\Unpost_Job_Business_Process_DataType
     */
    public function setJob_Posting_Reference(\StructType\Job_PostingObjectType $job_Posting_Reference = null)
    {
        // validation for constraint: choice(Job_Posting_Reference, Job_Posting_Site_Data)
        if ('' !== ($job_Posting_ReferenceChoiceErrorMessage = self::validateJob_Posting_ReferenceForChoiceConstraintsFromSetJob_Posting_Reference($job_Posting_Reference))) {
            throw new \InvalidArgumentException($job_Posting_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Posting_Reference) || (is_array($job_Posting_Reference) && empty($job_Posting_Reference))) {
            unset($this->Job_Posting_Reference);
        } else {
            $this->Job_Posting_Reference = $job_Posting_Reference;
        }
        return $this;
    }
    /**
     * Get Job_Posting_Site_Data value
     * @return \StructType\Job_Posting_Reference_DataType|null
     */
    public function getJob_Posting_Site_Data()
    {
        return isset($this->Job_Posting_Site_Data) ? $this->Job_Posting_Site_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Posting_Site_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Site_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Posting_Site_DataForChoiceConstraintsFromSetJob_Posting_Site_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Posting_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Posting_Site_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Posting_Site_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Posting_Site_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_Reference_DataType $job_Posting_Site_Data
     * @return \StructType\Unpost_Job_Business_Process_DataType
     */
    public function setJob_Posting_Site_Data(\StructType\Job_Posting_Reference_DataType $job_Posting_Site_Data = null)
    {
        // validation for constraint: choice(Job_Posting_Reference, Job_Posting_Site_Data)
        if ('' !== ($job_Posting_Site_DataChoiceErrorMessage = self::validateJob_Posting_Site_DataForChoiceConstraintsFromSetJob_Posting_Site_Data($job_Posting_Site_Data))) {
            throw new \InvalidArgumentException($job_Posting_Site_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Posting_Site_Data) || (is_array($job_Posting_Site_Data) && empty($job_Posting_Site_Data))) {
            unset($this->Job_Posting_Site_Data);
        } else {
            $this->Job_Posting_Site_Data = $job_Posting_Site_Data;
        }
        return $this;
    }
}
