<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Test_Reference_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Only active Background Check Statuses may be selected. | Data for Background Check Package Test results.
 * @subpackage Structs
 */
class Test_Reference_DataType extends AbstractStructBase
{
    /**
     * The Background_Check_Package_Test_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Background Check Package Test. The Test must be part of the Background Check Package for this Event.
     * @var \StructType\Background_Check_Package_TestObjectType
     */
    public $Background_Check_Package_Test_Reference;
    /**
     * The Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Status of the Background Check Package Test.
     * @var \StructType\Background_Check_StatusObjectType
     */
    public $Status_Reference;
    /**
     * The Test_Name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $Test_Name;
    /**
     * The Test_Description
     * Meta information extracted from the WSDL
     * - documentation: The description of the Background Check Package Test. The description cannot be updated using this operation.
     * @var string
     */
    public $Test_Description;
    /**
     * Constructor method for Test_Reference_DataType
     * @uses Test_Reference_DataType::setBackground_Check_Package_Test_Reference()
     * @uses Test_Reference_DataType::setStatus_Reference()
     * @uses Test_Reference_DataType::setTest_Name()
     * @uses Test_Reference_DataType::setTest_Description()
     * @param \StructType\Background_Check_Package_TestObjectType $background_Check_Package_Test_Reference
     * @param \StructType\Background_Check_StatusObjectType $status_Reference
     * @param string $test_Name
     * @param string $test_Description
     */
    public function __construct(\StructType\Background_Check_Package_TestObjectType $background_Check_Package_Test_Reference = null, \StructType\Background_Check_StatusObjectType $status_Reference = null, $test_Name = null, $test_Description = null)
    {
        $this
            ->setBackground_Check_Package_Test_Reference($background_Check_Package_Test_Reference)
            ->setStatus_Reference($status_Reference)
            ->setTest_Name($test_Name)
            ->setTest_Description($test_Description);
    }
    /**
     * Get Background_Check_Package_Test_Reference value
     * @return \StructType\Background_Check_Package_TestObjectType|null
     */
    public function getBackground_Check_Package_Test_Reference()
    {
        return $this->Background_Check_Package_Test_Reference;
    }
    /**
     * Set Background_Check_Package_Test_Reference value
     * @param \StructType\Background_Check_Package_TestObjectType $background_Check_Package_Test_Reference
     * @return \StructType\Test_Reference_DataType
     */
    public function setBackground_Check_Package_Test_Reference(\StructType\Background_Check_Package_TestObjectType $background_Check_Package_Test_Reference = null)
    {
        $this->Background_Check_Package_Test_Reference = $background_Check_Package_Test_Reference;
        return $this;
    }
    /**
     * Get Status_Reference value
     * @return \StructType\Background_Check_StatusObjectType|null
     */
    public function getStatus_Reference()
    {
        return $this->Status_Reference;
    }
    /**
     * Set Status_Reference value
     * @param \StructType\Background_Check_StatusObjectType $status_Reference
     * @return \StructType\Test_Reference_DataType
     */
    public function setStatus_Reference(\StructType\Background_Check_StatusObjectType $status_Reference = null)
    {
        $this->Status_Reference = $status_Reference;
        return $this;
    }
    /**
     * Get Test_Name value
     * @return string|null
     */
    public function getTest_Name()
    {
        return $this->Test_Name;
    }
    /**
     * Set Test_Name value
     * @param string $test_Name
     * @return \StructType\Test_Reference_DataType
     */
    public function setTest_Name($test_Name = null)
    {
        // validation for constraint: string
        if (!is_null($test_Name) && !is_string($test_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($test_Name, true), gettype($test_Name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($test_Name) && mb_strlen($test_Name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($test_Name)), __LINE__);
        }
        $this->Test_Name = $test_Name;
        return $this;
    }
    /**
     * Get Test_Description value
     * @return string|null
     */
    public function getTest_Description()
    {
        return $this->Test_Description;
    }
    /**
     * Set Test_Description value
     * @param string $test_Description
     * @return \StructType\Test_Reference_DataType
     */
    public function setTest_Description($test_Description = null)
    {
        // validation for constraint: string
        if (!is_null($test_Description) && !is_string($test_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($test_Description, true), gettype($test_Description)), __LINE__);
        }
        $this->Test_Description = $test_Description;
        return $this;
    }
}
