<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Recruiting_Agency_Candidate_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains all the request data to submit a candidate via recruiting agency candidate process.
 * @subpackage Structs
 */
class Submit_Recruiting_Agency_Candidate_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Candidate_Submission_Data
     * @var \StructType\Recruiting_Agency_Candidate_Submission_DataType
     */
    public $Candidate_Submission_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Recruiting_Agency_Candidate_RequestType
     * @uses Submit_Recruiting_Agency_Candidate_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Recruiting_Agency_Candidate_RequestType::setCandidate_Submission_Data()
     * @uses Submit_Recruiting_Agency_Candidate_RequestType::setVersion()
     * @param \StructType\Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Recruiting_Agency_Candidate_Submission_DataType $candidate_Submission_Data
     * @param string $version
     */
    public function __construct(\StructType\Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Recruiting_Agency_Candidate_Submission_DataType $candidate_Submission_Data = null, $version = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setCandidate_Submission_Data($candidate_Submission_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Recruiting_Agency_Candidate_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Candidate_Submission_Data value
     * @return \StructType\Recruiting_Agency_Candidate_Submission_DataType|null
     */
    public function getCandidate_Submission_Data()
    {
        return $this->Candidate_Submission_Data;
    }
    /**
     * Set Candidate_Submission_Data value
     * @param \StructType\Recruiting_Agency_Candidate_Submission_DataType $candidate_Submission_Data
     * @return \StructType\Submit_Recruiting_Agency_Candidate_RequestType
     */
    public function setCandidate_Submission_Data(\StructType\Recruiting_Agency_Candidate_Submission_DataType $candidate_Submission_Data = null)
    {
        $this->Candidate_Submission_Data = $candidate_Submission_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Recruiting_Agency_Candidate_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
