<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Skill_Profile_for_Job_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the Skill profile's information for a position.
 * @subpackage Structs
 */
class Skill_Profile_for_Job_DataType extends AbstractStructBase
{
    /**
     * The Skill_Reference
     * Meta information extracted from the WSDL
     * - documentation: The identifier of a skill.
     * - minOccurs: 0
     * @var \StructType\SkillObjectType
     */
    public $Skill_Reference;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Enter the name of Skill.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the profile is required for this position.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required;
    /**
     * The Qualification_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The source (job profile or position) reference from which the qualification came from.
     * - minOccurs: 0
     * @var \StructType\Talent_Qualification_EnabledObjectType
     */
    public $Qualification_Source_Reference;
    /**
     * Constructor method for Skill_Profile_for_Job_DataType
     * @uses Skill_Profile_for_Job_DataType::setSkill_Reference()
     * @uses Skill_Profile_for_Job_DataType::setName()
     * @uses Skill_Profile_for_Job_DataType::setRequired()
     * @uses Skill_Profile_for_Job_DataType::setQualification_Source_Reference()
     * @param \StructType\SkillObjectType $skill_Reference
     * @param string $name
     * @param bool $required
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     */
    public function __construct(\StructType\SkillObjectType $skill_Reference = null, $name = null, $required = null, \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this
            ->setSkill_Reference($skill_Reference)
            ->setName($name)
            ->setRequired($required)
            ->setQualification_Source_Reference($qualification_Source_Reference);
    }
    /**
     * Get Skill_Reference value
     * @return \StructType\SkillObjectType|null
     */
    public function getSkill_Reference()
    {
        return $this->Skill_Reference;
    }
    /**
     * Set Skill_Reference value
     * @param \StructType\SkillObjectType $skill_Reference
     * @return \StructType\Skill_Profile_for_Job_DataType
     */
    public function setSkill_Reference(\StructType\SkillObjectType $skill_Reference = null)
    {
        $this->Skill_Reference = $skill_Reference;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Skill_Profile_for_Job_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \StructType\Skill_Profile_for_Job_DataType
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get Qualification_Source_Reference value
     * @return \StructType\Talent_Qualification_EnabledObjectType|null
     */
    public function getQualification_Source_Reference()
    {
        return $this->Qualification_Source_Reference;
    }
    /**
     * Set Qualification_Source_Reference value
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     * @return \StructType\Skill_Profile_for_Job_DataType
     */
    public function setQualification_Source_Reference(\StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this->Qualification_Source_Reference = $qualification_Source_Reference;
        return $this;
    }
}
