<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Referral_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains referral details data for a candidate.
 * @subpackage Structs
 */
class Referral_Details_DataType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a job requisition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType[]
     */
    public $Job_Requisition_Reference;
    /**
     * The Job_Areas_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a job area.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_FamilyObjectType[]
     */
    public $Job_Areas_Reference;
    /**
     * The Referral_Relationship_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a referral level.
     * - minOccurs: 0
     * @var \StructType\Referral_RelationshipObjectType
     */
    public $Referral_Relationship_Reference;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Referral_Consent_Given
     * Meta information extracted from the WSDL
     * - documentation: Referral Consent Given
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Referral_Consent_Given;
    /**
     * Constructor method for Referral_Details_DataType
     * @uses Referral_Details_DataType::setJob_Requisition_Reference()
     * @uses Referral_Details_DataType::setJob_Areas_Reference()
     * @uses Referral_Details_DataType::setReferral_Relationship_Reference()
     * @uses Referral_Details_DataType::setComment()
     * @uses Referral_Details_DataType::setReferral_Consent_Given()
     * @param \StructType\Job_Requisition_EnabledObjectType[] $job_Requisition_Reference
     * @param \StructType\Job_FamilyObjectType[] $job_Areas_Reference
     * @param \StructType\Referral_RelationshipObjectType $referral_Relationship_Reference
     * @param string $comment
     * @param bool $referral_Consent_Given
     */
    public function __construct(array $job_Requisition_Reference = array(), array $job_Areas_Reference = array(), \StructType\Referral_RelationshipObjectType $referral_Relationship_Reference = null, $comment = null, $referral_Consent_Given = null)
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setJob_Areas_Reference($job_Areas_Reference)
            ->setReferral_Relationship_Reference($referral_Relationship_Reference)
            ->setComment($comment)
            ->setReferral_Consent_Given($referral_Consent_Given);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType[]|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_ReferenceForArrayConstraintsFromSetJob_Requisition_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $referral_Details_DataTypeJob_Requisition_ReferenceItem) {
            // validation for constraint: itemType
            if (!$referral_Details_DataTypeJob_Requisition_ReferenceItem instanceof \StructType\Job_Requisition_EnabledObjectType) {
                $invalidValues[] = is_object($referral_Details_DataTypeJob_Requisition_ReferenceItem) ? get_class($referral_Details_DataTypeJob_Requisition_ReferenceItem) : sprintf('%s(%s)', gettype($referral_Details_DataTypeJob_Requisition_ReferenceItem), var_export($referral_Details_DataTypeJob_Requisition_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Reference property can only contain items of type \StructType\Job_Requisition_EnabledObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_EnabledObjectType[] $job_Requisition_Reference
     * @return \StructType\Referral_Details_DataType
     */
    public function setJob_Requisition_Reference(array $job_Requisition_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_ReferenceArrayErrorMessage = self::validateJob_Requisition_ReferenceForArrayConstraintsFromSetJob_Requisition_Reference($job_Requisition_Reference))) {
            throw new \InvalidArgumentException($job_Requisition_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_EnabledObjectType $item
     * @return \StructType\Referral_Details_DataType
     */
    public function addToJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Requisition_EnabledObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Reference property can only contain items of type \StructType\Job_Requisition_EnabledObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Reference[] = $item;
        return $this;
    }
    /**
     * Get Job_Areas_Reference value
     * @return \StructType\Job_FamilyObjectType[]|null
     */
    public function getJob_Areas_Reference()
    {
        return $this->Job_Areas_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Areas_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Areas_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Areas_ReferenceForArrayConstraintsFromSetJob_Areas_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $referral_Details_DataTypeJob_Areas_ReferenceItem) {
            // validation for constraint: itemType
            if (!$referral_Details_DataTypeJob_Areas_ReferenceItem instanceof \StructType\Job_FamilyObjectType) {
                $invalidValues[] = is_object($referral_Details_DataTypeJob_Areas_ReferenceItem) ? get_class($referral_Details_DataTypeJob_Areas_ReferenceItem) : sprintf('%s(%s)', gettype($referral_Details_DataTypeJob_Areas_ReferenceItem), var_export($referral_Details_DataTypeJob_Areas_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Areas_Reference property can only contain items of type \StructType\Job_FamilyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Areas_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_FamilyObjectType[] $job_Areas_Reference
     * @return \StructType\Referral_Details_DataType
     */
    public function setJob_Areas_Reference(array $job_Areas_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Areas_ReferenceArrayErrorMessage = self::validateJob_Areas_ReferenceForArrayConstraintsFromSetJob_Areas_Reference($job_Areas_Reference))) {
            throw new \InvalidArgumentException($job_Areas_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Areas_Reference = $job_Areas_Reference;
        return $this;
    }
    /**
     * Add item to Job_Areas_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_FamilyObjectType $item
     * @return \StructType\Referral_Details_DataType
     */
    public function addToJob_Areas_Reference(\StructType\Job_FamilyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_FamilyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Areas_Reference property can only contain items of type \StructType\Job_FamilyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Areas_Reference[] = $item;
        return $this;
    }
    /**
     * Get Referral_Relationship_Reference value
     * @return \StructType\Referral_RelationshipObjectType|null
     */
    public function getReferral_Relationship_Reference()
    {
        return $this->Referral_Relationship_Reference;
    }
    /**
     * Set Referral_Relationship_Reference value
     * @param \StructType\Referral_RelationshipObjectType $referral_Relationship_Reference
     * @return \StructType\Referral_Details_DataType
     */
    public function setReferral_Relationship_Reference(\StructType\Referral_RelationshipObjectType $referral_Relationship_Reference = null)
    {
        $this->Referral_Relationship_Reference = $referral_Relationship_Reference;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Referral_Details_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Referral_Consent_Given value
     * @return bool|null
     */
    public function getReferral_Consent_Given()
    {
        return $this->Referral_Consent_Given;
    }
    /**
     * Set Referral_Consent_Given value
     * @param bool $referral_Consent_Given
     * @return \StructType\Referral_Details_DataType
     */
    public function setReferral_Consent_Given($referral_Consent_Given = null)
    {
        // validation for constraint: boolean
        if (!is_null($referral_Consent_Given) && !is_bool($referral_Consent_Given)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($referral_Consent_Given, true), gettype($referral_Consent_Given)), __LINE__);
        }
        $this->Referral_Consent_Given = $referral_Consent_Given;
        return $this;
    }
}
