<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Referral_Candidate_Submission_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains referral data for Refer a Candidate process.
 * @subpackage Structs
 */
class Referral_Candidate_Submission_DataType extends AbstractStructBase
{
    /**
     * The Referred_By_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a referring worker.
     * @var \StructType\WorkerObjectType
     */
    public $Referred_By_Worker_Reference;
    /**
     * The Name_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Candidate_Name_DataType
     */
    public $Name_Data;
    /**
     * The Contact_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Candidate_Contact_DataType
     */
    public $Contact_Data;
    /**
     * The Referral_Details_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Referral_Details_DataType
     */
    public $Referral_Details_Data;
    /**
     * The Social_Media_Account_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Social_Media_Account_DataType[]
     */
    public $Social_Media_Account_Data;
    /**
     * The Resume_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Refer_a_Candidate_Attachment_DataType[]
     */
    public $Resume_Attachment_Data;
    /**
     * Constructor method for Referral_Candidate_Submission_DataType
     * @uses Referral_Candidate_Submission_DataType::setReferred_By_Worker_Reference()
     * @uses Referral_Candidate_Submission_DataType::setName_Data()
     * @uses Referral_Candidate_Submission_DataType::setContact_Data()
     * @uses Referral_Candidate_Submission_DataType::setReferral_Details_Data()
     * @uses Referral_Candidate_Submission_DataType::setSocial_Media_Account_Data()
     * @uses Referral_Candidate_Submission_DataType::setResume_Attachment_Data()
     * @param \StructType\WorkerObjectType $referred_By_Worker_Reference
     * @param \StructType\Candidate_Name_DataType $name_Data
     * @param \StructType\Candidate_Contact_DataType $contact_Data
     * @param \StructType\Referral_Details_DataType $referral_Details_Data
     * @param \StructType\Candidate_Social_Media_Account_DataType[] $social_Media_Account_Data
     * @param \StructType\Refer_a_Candidate_Attachment_DataType[] $resume_Attachment_Data
     */
    public function __construct(\StructType\WorkerObjectType $referred_By_Worker_Reference = null, \StructType\Candidate_Name_DataType $name_Data = null, \StructType\Candidate_Contact_DataType $contact_Data = null, \StructType\Referral_Details_DataType $referral_Details_Data = null, array $social_Media_Account_Data = array(), array $resume_Attachment_Data = array())
    {
        $this
            ->setReferred_By_Worker_Reference($referred_By_Worker_Reference)
            ->setName_Data($name_Data)
            ->setContact_Data($contact_Data)
            ->setReferral_Details_Data($referral_Details_Data)
            ->setSocial_Media_Account_Data($social_Media_Account_Data)
            ->setResume_Attachment_Data($resume_Attachment_Data);
    }
    /**
     * Get Referred_By_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getReferred_By_Worker_Reference()
    {
        return $this->Referred_By_Worker_Reference;
    }
    /**
     * Set Referred_By_Worker_Reference value
     * @param \StructType\WorkerObjectType $referred_By_Worker_Reference
     * @return \StructType\Referral_Candidate_Submission_DataType
     */
    public function setReferred_By_Worker_Reference(\StructType\WorkerObjectType $referred_By_Worker_Reference = null)
    {
        $this->Referred_By_Worker_Reference = $referred_By_Worker_Reference;
        return $this;
    }
    /**
     * Get Name_Data value
     * @return \StructType\Candidate_Name_DataType|null
     */
    public function getName_Data()
    {
        return $this->Name_Data;
    }
    /**
     * Set Name_Data value
     * @param \StructType\Candidate_Name_DataType $name_Data
     * @return \StructType\Referral_Candidate_Submission_DataType
     */
    public function setName_Data(\StructType\Candidate_Name_DataType $name_Data = null)
    {
        $this->Name_Data = $name_Data;
        return $this;
    }
    /**
     * Get Contact_Data value
     * @return \StructType\Candidate_Contact_DataType|null
     */
    public function getContact_Data()
    {
        return $this->Contact_Data;
    }
    /**
     * Set Contact_Data value
     * @param \StructType\Candidate_Contact_DataType $contact_Data
     * @return \StructType\Referral_Candidate_Submission_DataType
     */
    public function setContact_Data(\StructType\Candidate_Contact_DataType $contact_Data = null)
    {
        $this->Contact_Data = $contact_Data;
        return $this;
    }
    /**
     * Get Referral_Details_Data value
     * @return \StructType\Referral_Details_DataType|null
     */
    public function getReferral_Details_Data()
    {
        return $this->Referral_Details_Data;
    }
    /**
     * Set Referral_Details_Data value
     * @param \StructType\Referral_Details_DataType $referral_Details_Data
     * @return \StructType\Referral_Candidate_Submission_DataType
     */
    public function setReferral_Details_Data(\StructType\Referral_Details_DataType $referral_Details_Data = null)
    {
        $this->Referral_Details_Data = $referral_Details_Data;
        return $this;
    }
    /**
     * Get Social_Media_Account_Data value
     * @return \StructType\Candidate_Social_Media_Account_DataType[]|null
     */
    public function getSocial_Media_Account_Data()
    {
        return $this->Social_Media_Account_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSocial_Media_Account_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSocial_Media_Account_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSocial_Media_Account_DataForArrayConstraintsFromSetSocial_Media_Account_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $referral_Candidate_Submission_DataTypeSocial_Media_Account_DataItem) {
            // validation for constraint: itemType
            if (!$referral_Candidate_Submission_DataTypeSocial_Media_Account_DataItem instanceof \StructType\Candidate_Social_Media_Account_DataType) {
                $invalidValues[] = is_object($referral_Candidate_Submission_DataTypeSocial_Media_Account_DataItem) ? get_class($referral_Candidate_Submission_DataTypeSocial_Media_Account_DataItem) : sprintf('%s(%s)', gettype($referral_Candidate_Submission_DataTypeSocial_Media_Account_DataItem), var_export($referral_Candidate_Submission_DataTypeSocial_Media_Account_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Social_Media_Account_Data property can only contain items of type \StructType\Candidate_Social_Media_Account_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Social_Media_Account_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Social_Media_Account_DataType[] $social_Media_Account_Data
     * @return \StructType\Referral_Candidate_Submission_DataType
     */
    public function setSocial_Media_Account_Data(array $social_Media_Account_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($social_Media_Account_DataArrayErrorMessage = self::validateSocial_Media_Account_DataForArrayConstraintsFromSetSocial_Media_Account_Data($social_Media_Account_Data))) {
            throw new \InvalidArgumentException($social_Media_Account_DataArrayErrorMessage, __LINE__);
        }
        $this->Social_Media_Account_Data = $social_Media_Account_Data;
        return $this;
    }
    /**
     * Add item to Social_Media_Account_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Social_Media_Account_DataType $item
     * @return \StructType\Referral_Candidate_Submission_DataType
     */
    public function addToSocial_Media_Account_Data(\StructType\Candidate_Social_Media_Account_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Social_Media_Account_DataType) {
            throw new \InvalidArgumentException(sprintf('The Social_Media_Account_Data property can only contain items of type \StructType\Candidate_Social_Media_Account_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Social_Media_Account_Data[] = $item;
        return $this;
    }
    /**
     * Get Resume_Attachment_Data value
     * @return \StructType\Refer_a_Candidate_Attachment_DataType[]|null
     */
    public function getResume_Attachment_Data()
    {
        return $this->Resume_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResume_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResume_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResume_Attachment_DataForArrayConstraintsFromSetResume_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $referral_Candidate_Submission_DataTypeResume_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$referral_Candidate_Submission_DataTypeResume_Attachment_DataItem instanceof \StructType\Refer_a_Candidate_Attachment_DataType) {
                $invalidValues[] = is_object($referral_Candidate_Submission_DataTypeResume_Attachment_DataItem) ? get_class($referral_Candidate_Submission_DataTypeResume_Attachment_DataItem) : sprintf('%s(%s)', gettype($referral_Candidate_Submission_DataTypeResume_Attachment_DataItem), var_export($referral_Candidate_Submission_DataTypeResume_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resume_Attachment_Data property can only contain items of type \StructType\Refer_a_Candidate_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resume_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Refer_a_Candidate_Attachment_DataType[] $resume_Attachment_Data
     * @return \StructType\Referral_Candidate_Submission_DataType
     */
    public function setResume_Attachment_Data(array $resume_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resume_Attachment_DataArrayErrorMessage = self::validateResume_Attachment_DataForArrayConstraintsFromSetResume_Attachment_Data($resume_Attachment_Data))) {
            throw new \InvalidArgumentException($resume_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Resume_Attachment_Data = $resume_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Resume_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Refer_a_Candidate_Attachment_DataType $item
     * @return \StructType\Referral_Candidate_Submission_DataType
     */
    public function addToResume_Attachment_Data(\StructType\Refer_a_Candidate_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Refer_a_Candidate_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resume_Attachment_Data property can only contain items of type \StructType\Refer_a_Candidate_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resume_Attachment_Data[] = $item;
        return $this;
    }
}
