<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reference_Participant_Detail_Event_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The referee and their questionnaire answers.
 * @subpackage Structs
 */
class Reference_Participant_Detail_Event_DataType extends AbstractStructBase
{
    /**
     * The Referee_Reference
     * Meta information extracted from the WSDL
     * - documentation: The referee for this reference check.
     * - minOccurs: 0
     * @var \StructType\RefereeObjectType
     */
    public $Referee_Reference;
    /**
     * The Questionnaire_Response_Data
     * @var \StructType\Questionnaires_Response_DataType
     */
    public $Questionnaire_Response_Data;
    /**
     * Constructor method for Reference_Participant_Detail_Event_DataType
     * @uses Reference_Participant_Detail_Event_DataType::setReferee_Reference()
     * @uses Reference_Participant_Detail_Event_DataType::setQuestionnaire_Response_Data()
     * @param \StructType\RefereeObjectType $referee_Reference
     * @param \StructType\Questionnaires_Response_DataType $questionnaire_Response_Data
     */
    public function __construct(\StructType\RefereeObjectType $referee_Reference = null, \StructType\Questionnaires_Response_DataType $questionnaire_Response_Data = null)
    {
        $this
            ->setReferee_Reference($referee_Reference)
            ->setQuestionnaire_Response_Data($questionnaire_Response_Data);
    }
    /**
     * Get Referee_Reference value
     * @return \StructType\RefereeObjectType|null
     */
    public function getReferee_Reference()
    {
        return $this->Referee_Reference;
    }
    /**
     * Set Referee_Reference value
     * @param \StructType\RefereeObjectType $referee_Reference
     * @return \StructType\Reference_Participant_Detail_Event_DataType
     */
    public function setReferee_Reference(\StructType\RefereeObjectType $referee_Reference = null)
    {
        $this->Referee_Reference = $referee_Reference;
        return $this;
    }
    /**
     * Get Questionnaire_Response_Data value
     * @return \StructType\Questionnaires_Response_DataType|null
     */
    public function getQuestionnaire_Response_Data()
    {
        return $this->Questionnaire_Response_Data;
    }
    /**
     * Set Questionnaire_Response_Data value
     * @param \StructType\Questionnaires_Response_DataType $questionnaire_Response_Data
     * @return \StructType\Reference_Participant_Detail_Event_DataType
     */
    public function setQuestionnaire_Response_Data(\StructType\Questionnaires_Response_DataType $questionnaire_Response_Data = null)
    {
        $this->Questionnaire_Response_Data = $questionnaire_Response_Data;
        return $this;
    }
}
