<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Referee_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The fields to add or update referees for a reference check.
 * @subpackage Structs
 */
class Referee_DataType extends AbstractStructBase
{
    /**
     * The Reference_Check_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference check you want to update or add a referee for.
     * - choice: Reference_Check_Event_Reference | Job_Application_Reference | Candidate_Reference_Criteria
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Reference_Check_Event_Reference;
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: The job application you want to update or add a referee for.
     * - choice: Reference_Check_Event_Reference | Job_Application_Reference | Candidate_Reference_Criteria
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Candidate_Reference_Criteria
     * Meta information extracted from the WSDL
     * - documentation: The candidate for the reference check event.
     * - choice: Reference_Check_Event_Reference | Job_Application_Reference | Candidate_Reference_Criteria
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Candidate_Reference_CriteriaType
     */
    public $Candidate_Reference_Criteria;
    /**
     * The Referee_Reference_Data
     * Meta information extracted from the WSDL
     * - documentation: The fields to add or update a referee for a reference check.
     * - maxOccurs: unbounded
     * @var \StructType\Referee_Reference_DataType[]
     */
    public $Referee_Reference_Data;
    /**
     * Constructor method for Referee_DataType
     * @uses Referee_DataType::setReference_Check_Event_Reference()
     * @uses Referee_DataType::setJob_Application_Reference()
     * @uses Referee_DataType::setCandidate_Reference_Criteria()
     * @uses Referee_DataType::setReferee_Reference_Data()
     * @param \StructType\Unique_IdentifierObjectType $reference_Check_Event_Reference
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\Candidate_Reference_CriteriaType $candidate_Reference_Criteria
     * @param \StructType\Referee_Reference_DataType[] $referee_Reference_Data
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $reference_Check_Event_Reference = null, \StructType\Job_ApplicationObjectType $job_Application_Reference = null, \StructType\Candidate_Reference_CriteriaType $candidate_Reference_Criteria = null, array $referee_Reference_Data = array())
    {
        $this
            ->setReference_Check_Event_Reference($reference_Check_Event_Reference)
            ->setJob_Application_Reference($job_Application_Reference)
            ->setCandidate_Reference_Criteria($candidate_Reference_Criteria)
            ->setReferee_Reference_Data($referee_Reference_Data);
    }
    /**
     * Get Reference_Check_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getReference_Check_Event_Reference()
    {
        return isset($this->Reference_Check_Event_Reference) ? $this->Reference_Check_Event_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setReference_Check_Event_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReference_Check_Event_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReference_Check_Event_ReferenceForChoiceConstraintsFromSetReference_Check_Event_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Application_Reference',
            'Candidate_Reference_Criteria',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Reference_Check_Event_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Reference_Check_Event_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Reference_Check_Event_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $reference_Check_Event_Reference
     * @return \StructType\Referee_DataType
     */
    public function setReference_Check_Event_Reference(\StructType\Unique_IdentifierObjectType $reference_Check_Event_Reference = null)
    {
        // validation for constraint: choice(Reference_Check_Event_Reference, Job_Application_Reference, Candidate_Reference_Criteria)
        if ('' !== ($reference_Check_Event_ReferenceChoiceErrorMessage = self::validateReference_Check_Event_ReferenceForChoiceConstraintsFromSetReference_Check_Event_Reference($reference_Check_Event_Reference))) {
            throw new \InvalidArgumentException($reference_Check_Event_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($reference_Check_Event_Reference) || (is_array($reference_Check_Event_Reference) && empty($reference_Check_Event_Reference))) {
            unset($this->Reference_Check_Event_Reference);
        } else {
            $this->Reference_Check_Event_Reference = $reference_Check_Event_Reference;
        }
        return $this;
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return isset($this->Job_Application_Reference) ? $this->Job_Application_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Application_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Reference_Check_Event_Reference',
            'Candidate_Reference_Criteria',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Application_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Application_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Application_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Referee_DataType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        // validation for constraint: choice(Reference_Check_Event_Reference, Job_Application_Reference, Candidate_Reference_Criteria)
        if ('' !== ($job_Application_ReferenceChoiceErrorMessage = self::validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($job_Application_Reference))) {
            throw new \InvalidArgumentException($job_Application_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Application_Reference) || (is_array($job_Application_Reference) && empty($job_Application_Reference))) {
            unset($this->Job_Application_Reference);
        } else {
            $this->Job_Application_Reference = $job_Application_Reference;
        }
        return $this;
    }
    /**
     * Get Candidate_Reference_Criteria value
     * @return \StructType\Candidate_Reference_CriteriaType|null
     */
    public function getCandidate_Reference_Criteria()
    {
        return isset($this->Candidate_Reference_Criteria) ? $this->Candidate_Reference_Criteria : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCandidate_Reference_Criteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Reference_Criteria method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCandidate_Reference_CriteriaForChoiceConstraintsFromSetCandidate_Reference_Criteria($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Reference_Check_Event_Reference',
            'Job_Application_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Candidate_Reference_Criteria can\'t be set as the property %s is already set. Only one property must be set among these properties: Candidate_Reference_Criteria, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Candidate_Reference_Criteria value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Reference_CriteriaType $candidate_Reference_Criteria
     * @return \StructType\Referee_DataType
     */
    public function setCandidate_Reference_Criteria(\StructType\Candidate_Reference_CriteriaType $candidate_Reference_Criteria = null)
    {
        // validation for constraint: choice(Reference_Check_Event_Reference, Job_Application_Reference, Candidate_Reference_Criteria)
        if ('' !== ($candidate_Reference_CriteriaChoiceErrorMessage = self::validateCandidate_Reference_CriteriaForChoiceConstraintsFromSetCandidate_Reference_Criteria($candidate_Reference_Criteria))) {
            throw new \InvalidArgumentException($candidate_Reference_CriteriaChoiceErrorMessage, __LINE__);
        }
        if (is_null($candidate_Reference_Criteria) || (is_array($candidate_Reference_Criteria) && empty($candidate_Reference_Criteria))) {
            unset($this->Candidate_Reference_Criteria);
        } else {
            $this->Candidate_Reference_Criteria = $candidate_Reference_Criteria;
        }
        return $this;
    }
    /**
     * Get Referee_Reference_Data value
     * @return \StructType\Referee_Reference_DataType[]|null
     */
    public function getReferee_Reference_Data()
    {
        return $this->Referee_Reference_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReferee_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferee_Reference_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferee_Reference_DataForArrayConstraintsFromSetReferee_Reference_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $referee_DataTypeReferee_Reference_DataItem) {
            // validation for constraint: itemType
            if (!$referee_DataTypeReferee_Reference_DataItem instanceof \StructType\Referee_Reference_DataType) {
                $invalidValues[] = is_object($referee_DataTypeReferee_Reference_DataItem) ? get_class($referee_DataTypeReferee_Reference_DataItem) : sprintf('%s(%s)', gettype($referee_DataTypeReferee_Reference_DataItem), var_export($referee_DataTypeReferee_Reference_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Referee_Reference_Data property can only contain items of type \StructType\Referee_Reference_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Referee_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Referee_Reference_DataType[] $referee_Reference_Data
     * @return \StructType\Referee_DataType
     */
    public function setReferee_Reference_Data(array $referee_Reference_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($referee_Reference_DataArrayErrorMessage = self::validateReferee_Reference_DataForArrayConstraintsFromSetReferee_Reference_Data($referee_Reference_Data))) {
            throw new \InvalidArgumentException($referee_Reference_DataArrayErrorMessage, __LINE__);
        }
        $this->Referee_Reference_Data = $referee_Reference_Data;
        return $this;
    }
    /**
     * Add item to Referee_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Referee_Reference_DataType $item
     * @return \StructType\Referee_DataType
     */
    public function addToReferee_Reference_Data(\StructType\Referee_Reference_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Referee_Reference_DataType) {
            throw new \InvalidArgumentException(sprintf('The Referee_Reference_Data property can only contain items of type \StructType\Referee_Reference_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Referee_Reference_Data[] = $item;
        return $this;
    }
}
