<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Self-Service_Schedule_Excluded_Days_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Section containing data for the Recruiting Calendar Excluded Days setting.
 * @subpackage Structs
 */
class Recruiting_Self_Service_Schedule_Excluded_Days_DataType extends AbstractStructBase
{
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start date of the Excluded Days setting.
     * - maxOccurs: 1
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End date of the Excluded Days setting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Month_Reference
     * Meta information extracted from the WSDL
     * - documentation: The months when the Excluded Day setting are active.
     * - maxOccurs: unbounded
     * @var \StructType\MonthObjectType[]
     */
    public $Month_Reference;
    /**
     * The Days_of_the_Month_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Days of the month that are excluded.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Day_of_the_MonthObjectType[]
     */
    public $Days_of_the_Month_Reference;
    /**
     * The Day_of_the_Week_in_Month_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Days of the week that are excluded.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Day_of_the_Week_in_Month_Reference;
    /**
     * Constructor method for Recruiting_Self-Service_Schedule_Excluded_Days_DataType
     * @uses Recruiting_Self_Service_Schedule_Excluded_Days_DataType::setStart_Date()
     * @uses Recruiting_Self_Service_Schedule_Excluded_Days_DataType::setEnd_Date()
     * @uses Recruiting_Self_Service_Schedule_Excluded_Days_DataType::setMonth_Reference()
     * @uses Recruiting_Self_Service_Schedule_Excluded_Days_DataType::setDays_of_the_Month_Reference()
     * @uses Recruiting_Self_Service_Schedule_Excluded_Days_DataType::setDay_of_the_Week_in_Month_Reference()
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\MonthObjectType[] $month_Reference
     * @param \StructType\Day_of_the_MonthObjectType[] $days_of_the_Month_Reference
     * @param \StructType\Unique_IdentifierObjectType $day_of_the_Week_in_Month_Reference
     */
    public function __construct($start_Date = null, $end_Date = null, array $month_Reference = array(), array $days_of_the_Month_Reference = array(), \StructType\Unique_IdentifierObjectType $day_of_the_Week_in_Month_Reference = null)
    {
        $this
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setMonth_Reference($month_Reference)
            ->setDays_of_the_Month_Reference($days_of_the_Month_Reference)
            ->setDay_of_the_Week_in_Month_Reference($day_of_the_Week_in_Month_Reference);
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Month_Reference value
     * @return \StructType\MonthObjectType[]|null
     */
    public function getMonth_Reference()
    {
        return $this->Month_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setMonth_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMonth_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMonth_ReferenceForArrayConstraintsFromSetMonth_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Self_Service_Schedule_Excluded_Days_DataTypeMonth_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recruiting_Self_Service_Schedule_Excluded_Days_DataTypeMonth_ReferenceItem instanceof \StructType\MonthObjectType) {
                $invalidValues[] = is_object($recruiting_Self_Service_Schedule_Excluded_Days_DataTypeMonth_ReferenceItem) ? get_class($recruiting_Self_Service_Schedule_Excluded_Days_DataTypeMonth_ReferenceItem) : sprintf('%s(%s)', gettype($recruiting_Self_Service_Schedule_Excluded_Days_DataTypeMonth_ReferenceItem), var_export($recruiting_Self_Service_Schedule_Excluded_Days_DataTypeMonth_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Month_Reference property can only contain items of type \StructType\MonthObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Month_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\MonthObjectType[] $month_Reference
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType
     */
    public function setMonth_Reference(array $month_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($month_ReferenceArrayErrorMessage = self::validateMonth_ReferenceForArrayConstraintsFromSetMonth_Reference($month_Reference))) {
            throw new \InvalidArgumentException($month_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Month_Reference = $month_Reference;
        return $this;
    }
    /**
     * Add item to Month_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\MonthObjectType $item
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType
     */
    public function addToMonth_Reference(\StructType\MonthObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MonthObjectType) {
            throw new \InvalidArgumentException(sprintf('The Month_Reference property can only contain items of type \StructType\MonthObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Month_Reference[] = $item;
        return $this;
    }
    /**
     * Get Days_of_the_Month_Reference value
     * @return \StructType\Day_of_the_MonthObjectType[]|null
     */
    public function getDays_of_the_Month_Reference()
    {
        return $this->Days_of_the_Month_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDays_of_the_Month_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDays_of_the_Month_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDays_of_the_Month_ReferenceForArrayConstraintsFromSetDays_of_the_Month_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Self_Service_Schedule_Excluded_Days_DataTypeDays_of_the_Month_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recruiting_Self_Service_Schedule_Excluded_Days_DataTypeDays_of_the_Month_ReferenceItem instanceof \StructType\Day_of_the_MonthObjectType) {
                $invalidValues[] = is_object($recruiting_Self_Service_Schedule_Excluded_Days_DataTypeDays_of_the_Month_ReferenceItem) ? get_class($recruiting_Self_Service_Schedule_Excluded_Days_DataTypeDays_of_the_Month_ReferenceItem) : sprintf('%s(%s)', gettype($recruiting_Self_Service_Schedule_Excluded_Days_DataTypeDays_of_the_Month_ReferenceItem), var_export($recruiting_Self_Service_Schedule_Excluded_Days_DataTypeDays_of_the_Month_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Days_of_the_Month_Reference property can only contain items of type \StructType\Day_of_the_MonthObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Days_of_the_Month_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Day_of_the_MonthObjectType[] $days_of_the_Month_Reference
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType
     */
    public function setDays_of_the_Month_Reference(array $days_of_the_Month_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($days_of_the_Month_ReferenceArrayErrorMessage = self::validateDays_of_the_Month_ReferenceForArrayConstraintsFromSetDays_of_the_Month_Reference($days_of_the_Month_Reference))) {
            throw new \InvalidArgumentException($days_of_the_Month_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Days_of_the_Month_Reference = $days_of_the_Month_Reference;
        return $this;
    }
    /**
     * Add item to Days_of_the_Month_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Day_of_the_MonthObjectType $item
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType
     */
    public function addToDays_of_the_Month_Reference(\StructType\Day_of_the_MonthObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Day_of_the_MonthObjectType) {
            throw new \InvalidArgumentException(sprintf('The Days_of_the_Month_Reference property can only contain items of type \StructType\Day_of_the_MonthObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Days_of_the_Month_Reference[] = $item;
        return $this;
    }
    /**
     * Get Day_of_the_Week_in_Month_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getDay_of_the_Week_in_Month_Reference()
    {
        return $this->Day_of_the_Week_in_Month_Reference;
    }
    /**
     * Set Day_of_the_Week_in_Month_Reference value
     * @param \StructType\Unique_IdentifierObjectType $day_of_the_Week_in_Month_Reference
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_Days_DataType
     */
    public function setDay_of_the_Week_in_Month_Reference(\StructType\Unique_IdentifierObjectType $day_of_the_Week_in_Month_Reference = null)
    {
        $this->Day_of_the_Week_in_Month_Reference = $day_of_the_Week_in_Month_Reference;
        return $this;
    }
}
