<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Self-Service_Schedule_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Section containing data for the Recruiting Calendar Schedule.
 * @subpackage Structs
 */
class Recruiting_Self_Service_Schedule_DataType extends AbstractStructBase
{
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: The first day for times on the schedule.
     * - maxOccurs: 1
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: The last day for times on the schedule.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Weekly_Recurrence
     * Meta information extracted from the WSDL
     * - documentation: This field indicates how often the times on schedule apply.For example, if the recurrence is 1, the times on the schedule apply every week starting from the start date. If the recurrence is 2, the times on the schedule apply every
     * two weeks starting from the start date.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 10
     * @var float
     */
    public $Weekly_Recurrence;
    /**
     * The Max_Number_of_Participants
     * Meta information extracted from the WSDL
     * - documentation: The max number of candidates who can select an available time on this schedule.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 3
     * @var float
     */
    public $Max_Number_of_Participants;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The location of the schedule.
     * @var \StructType\LocationObjectType
     */
    public $Location_Reference;
    /**
     * The Time_Zone_Reference
     * Meta information extracted from the WSDL
     * - documentation: The timezone of the schedule.
     * @var \StructType\Time_ZoneObjectType
     */
    public $Time_Zone_Reference;
    /**
     * The Candidate_Confirmation_Message
     * Meta information extracted from the WSDL
     * - documentation: The confirmation message candidates see after they select a time on this schedule.
     * - base: xsd:string
     * - maxOccurs: 1
     * @var string
     */
    public $Candidate_Confirmation_Message;
    /**
     * The Assign_Role_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType[]
     */
    public $Assign_Role_Data;
    /**
     * The Time_Blocks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType[]
     */
    public $Time_Blocks;
    /**
     * Constructor method for Recruiting_Self-Service_Schedule_DataType
     * @uses Recruiting_Self_Service_Schedule_DataType::setStart_Date()
     * @uses Recruiting_Self_Service_Schedule_DataType::setEnd_Date()
     * @uses Recruiting_Self_Service_Schedule_DataType::setWeekly_Recurrence()
     * @uses Recruiting_Self_Service_Schedule_DataType::setMax_Number_of_Participants()
     * @uses Recruiting_Self_Service_Schedule_DataType::setLocation_Reference()
     * @uses Recruiting_Self_Service_Schedule_DataType::setTime_Zone_Reference()
     * @uses Recruiting_Self_Service_Schedule_DataType::setCandidate_Confirmation_Message()
     * @uses Recruiting_Self_Service_Schedule_DataType::setAssign_Role_Data()
     * @uses Recruiting_Self_Service_Schedule_DataType::setTime_Blocks()
     * @param string $start_Date
     * @param string $end_Date
     * @param float $weekly_Recurrence
     * @param float $max_Number_of_Participants
     * @param \StructType\LocationObjectType $location_Reference
     * @param \StructType\Time_ZoneObjectType $time_Zone_Reference
     * @param string $candidate_Confirmation_Message
     * @param \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType[] $assign_Role_Data
     * @param \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType[] $time_Blocks
     */
    public function __construct($start_Date = null, $end_Date = null, $weekly_Recurrence = null, $max_Number_of_Participants = null, \StructType\LocationObjectType $location_Reference = null, \StructType\Time_ZoneObjectType $time_Zone_Reference = null, $candidate_Confirmation_Message = null, array $assign_Role_Data = array(), array $time_Blocks = array())
    {
        $this
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setWeekly_Recurrence($weekly_Recurrence)
            ->setMax_Number_of_Participants($max_Number_of_Participants)
            ->setLocation_Reference($location_Reference)
            ->setTime_Zone_Reference($time_Zone_Reference)
            ->setCandidate_Confirmation_Message($candidate_Confirmation_Message)
            ->setAssign_Role_Data($assign_Role_Data)
            ->setTime_Blocks($time_Blocks);
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Weekly_Recurrence value
     * @return float|null
     */
    public function getWeekly_Recurrence()
    {
        return $this->Weekly_Recurrence;
    }
    /**
     * Set Weekly_Recurrence value
     * @param float $weekly_Recurrence
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public function setWeekly_Recurrence($weekly_Recurrence = null)
    {
        // validation for constraint: float
        if (!is_null($weekly_Recurrence) && !(is_float($weekly_Recurrence) || is_numeric($weekly_Recurrence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weekly_Recurrence, true), gettype($weekly_Recurrence)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($weekly_Recurrence) && mb_strlen(mb_substr($weekly_Recurrence, false !== mb_strpos($weekly_Recurrence, '.') ? mb_strpos($weekly_Recurrence, '.') + 1 : mb_strlen($weekly_Recurrence))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($weekly_Recurrence, true), mb_strlen(mb_substr($weekly_Recurrence, mb_strpos($weekly_Recurrence, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($weekly_Recurrence) && $weekly_Recurrence < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($weekly_Recurrence, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($weekly_Recurrence) && mb_strlen(preg_replace('/(\D)/', '', $weekly_Recurrence)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($weekly_Recurrence, true), mb_strlen(preg_replace('/(\D)/', '', $weekly_Recurrence))), __LINE__);
        }
        $this->Weekly_Recurrence = $weekly_Recurrence;
        return $this;
    }
    /**
     * Get Max_Number_of_Participants value
     * @return float|null
     */
    public function getMax_Number_of_Participants()
    {
        return $this->Max_Number_of_Participants;
    }
    /**
     * Set Max_Number_of_Participants value
     * @param float $max_Number_of_Participants
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public function setMax_Number_of_Participants($max_Number_of_Participants = null)
    {
        // validation for constraint: float
        if (!is_null($max_Number_of_Participants) && !(is_float($max_Number_of_Participants) || is_numeric($max_Number_of_Participants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($max_Number_of_Participants, true), gettype($max_Number_of_Participants)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($max_Number_of_Participants) && mb_strlen(mb_substr($max_Number_of_Participants, false !== mb_strpos($max_Number_of_Participants, '.') ? mb_strpos($max_Number_of_Participants, '.') + 1 : mb_strlen($max_Number_of_Participants))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($max_Number_of_Participants, true), mb_strlen(mb_substr($max_Number_of_Participants, mb_strpos($max_Number_of_Participants, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($max_Number_of_Participants) && $max_Number_of_Participants < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($max_Number_of_Participants, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($max_Number_of_Participants) && mb_strlen(preg_replace('/(\D)/', '', $max_Number_of_Participants)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($max_Number_of_Participants, true), mb_strlen(preg_replace('/(\D)/', '', $max_Number_of_Participants))), __LINE__);
        }
        $this->Max_Number_of_Participants = $max_Number_of_Participants;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * Set Location_Reference value
     * @param \StructType\LocationObjectType $location_Reference
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public function setLocation_Reference(\StructType\LocationObjectType $location_Reference = null)
    {
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Get Time_Zone_Reference value
     * @return \StructType\Time_ZoneObjectType|null
     */
    public function getTime_Zone_Reference()
    {
        return $this->Time_Zone_Reference;
    }
    /**
     * Set Time_Zone_Reference value
     * @param \StructType\Time_ZoneObjectType $time_Zone_Reference
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public function setTime_Zone_Reference(\StructType\Time_ZoneObjectType $time_Zone_Reference = null)
    {
        $this->Time_Zone_Reference = $time_Zone_Reference;
        return $this;
    }
    /**
     * Get Candidate_Confirmation_Message value
     * @return string|null
     */
    public function getCandidate_Confirmation_Message()
    {
        return $this->Candidate_Confirmation_Message;
    }
    /**
     * Set Candidate_Confirmation_Message value
     * @param string $candidate_Confirmation_Message
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public function setCandidate_Confirmation_Message($candidate_Confirmation_Message = null)
    {
        // validation for constraint: string
        if (!is_null($candidate_Confirmation_Message) && !is_string($candidate_Confirmation_Message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($candidate_Confirmation_Message, true), gettype($candidate_Confirmation_Message)), __LINE__);
        }
        $this->Candidate_Confirmation_Message = $candidate_Confirmation_Message;
        return $this;
    }
    /**
     * Get Assign_Role_Data value
     * @return \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType[]|null
     */
    public function getAssign_Role_Data()
    {
        return $this->Assign_Role_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAssign_Role_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssign_Role_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssign_Role_DataForArrayConstraintsFromSetAssign_Role_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Self_Service_Schedule_DataTypeAssign_Role_DataItem) {
            // validation for constraint: itemType
            if (!$recruiting_Self_Service_Schedule_DataTypeAssign_Role_DataItem instanceof \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType) {
                $invalidValues[] = is_object($recruiting_Self_Service_Schedule_DataTypeAssign_Role_DataItem) ? get_class($recruiting_Self_Service_Schedule_DataTypeAssign_Role_DataItem) : sprintf('%s(%s)', gettype($recruiting_Self_Service_Schedule_DataTypeAssign_Role_DataItem), var_export($recruiting_Self_Service_Schedule_DataTypeAssign_Role_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Assign_Role_Data property can only contain items of type \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Assign_Role_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType[] $assign_Role_Data
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public function setAssign_Role_Data(array $assign_Role_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($assign_Role_DataArrayErrorMessage = self::validateAssign_Role_DataForArrayConstraintsFromSetAssign_Role_Data($assign_Role_Data))) {
            throw new \InvalidArgumentException($assign_Role_DataArrayErrorMessage, __LINE__);
        }
        $this->Assign_Role_Data = $assign_Role_Data;
        return $this;
    }
    /**
     * Add item to Assign_Role_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType $item
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public function addToAssign_Role_Data(\StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType) {
            throw new \InvalidArgumentException(sprintf('The Assign_Role_Data property can only contain items of type \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Assign_Role_Data[] = $item;
        return $this;
    }
    /**
     * Get Time_Blocks value
     * @return \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType[]|null
     */
    public function getTime_Blocks()
    {
        return $this->Time_Blocks;
    }
    /**
     * This method is responsible for validating the values passed to the setTime_Blocks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTime_Blocks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTime_BlocksForArrayConstraintsFromSetTime_Blocks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Self_Service_Schedule_DataTypeTime_BlocksItem) {
            // validation for constraint: itemType
            if (!$recruiting_Self_Service_Schedule_DataTypeTime_BlocksItem instanceof \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType) {
                $invalidValues[] = is_object($recruiting_Self_Service_Schedule_DataTypeTime_BlocksItem) ? get_class($recruiting_Self_Service_Schedule_DataTypeTime_BlocksItem) : sprintf('%s(%s)', gettype($recruiting_Self_Service_Schedule_DataTypeTime_BlocksItem), var_export($recruiting_Self_Service_Schedule_DataTypeTime_BlocksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Time_Blocks property can only contain items of type \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Time_Blocks value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType[] $time_Blocks
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public function setTime_Blocks(array $time_Blocks = array())
    {
        // validation for constraint: array
        if ('' !== ($time_BlocksArrayErrorMessage = self::validateTime_BlocksForArrayConstraintsFromSetTime_Blocks($time_Blocks))) {
            throw new \InvalidArgumentException($time_BlocksArrayErrorMessage, __LINE__);
        }
        $this->Time_Blocks = $time_Blocks;
        return $this;
    }
    /**
     * Add item to Time_Blocks value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType $item
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public function addToTime_Blocks(\StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType) {
            throw new \InvalidArgumentException(sprintf('The Time_Blocks property can only contain items of type \StructType\Recruiting_Self_Service_Schedule_Time_Block_ContainerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Time_Blocks[] = $item;
        return $this;
    }
}
