<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Self-Service_Schedule_Assign_Role_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Section containing data for the Recruiting Calendar Schedule Role Assignments.
 * @subpackage Structs
 */
class Recruiting_Self_Service_Schedule_Assign_Role_DataType extends AbstractStructBase
{
    /**
     * The Organization_Role_Reference
     * Meta information extracted from the WSDL
     * - documentation: The role being assigned.
     * @var \StructType\Assignable_RoleObjectType
     */
    public $Organization_Role_Reference;
    /**
     * The Role_Assignee_Reference
     * Meta information extracted from the WSDL
     * - documentation: The role assignees being assigned to the role.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoleeObjectType[]
     */
    public $Role_Assignee_Reference;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating that the role assignment should be deleted.
     * @var bool
     */
    public $Delete;
    /**
     * The Update
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating that the role assignees in this request will replace the current role assingees in the assignment.
     * @var bool
     */
    public $Update;
    /**
     * Constructor method for Recruiting_Self-Service_Schedule_Assign_Role_DataType
     * @uses Recruiting_Self_Service_Schedule_Assign_Role_DataType::setOrganization_Role_Reference()
     * @uses Recruiting_Self_Service_Schedule_Assign_Role_DataType::setRole_Assignee_Reference()
     * @uses Recruiting_Self_Service_Schedule_Assign_Role_DataType::setDelete()
     * @uses Recruiting_Self_Service_Schedule_Assign_Role_DataType::setUpdate()
     * @param \StructType\Assignable_RoleObjectType $organization_Role_Reference
     * @param \StructType\RoleeObjectType[] $role_Assignee_Reference
     * @param bool $delete
     * @param bool $update
     */
    public function __construct(\StructType\Assignable_RoleObjectType $organization_Role_Reference = null, array $role_Assignee_Reference = array(), $delete = null, $update = null)
    {
        $this
            ->setOrganization_Role_Reference($organization_Role_Reference)
            ->setRole_Assignee_Reference($role_Assignee_Reference)
            ->setDelete($delete)
            ->setUpdate($update);
    }
    /**
     * Get Organization_Role_Reference value
     * @return \StructType\Assignable_RoleObjectType|null
     */
    public function getOrganization_Role_Reference()
    {
        return $this->Organization_Role_Reference;
    }
    /**
     * Set Organization_Role_Reference value
     * @param \StructType\Assignable_RoleObjectType $organization_Role_Reference
     * @return \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType
     */
    public function setOrganization_Role_Reference(\StructType\Assignable_RoleObjectType $organization_Role_Reference = null)
    {
        $this->Organization_Role_Reference = $organization_Role_Reference;
        return $this;
    }
    /**
     * Get Role_Assignee_Reference value
     * @return \StructType\RoleeObjectType[]|null
     */
    public function getRole_Assignee_Reference()
    {
        return $this->Role_Assignee_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRole_Assignee_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRole_Assignee_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRole_Assignee_ReferenceForArrayConstraintsFromSetRole_Assignee_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Self_Service_Schedule_Assign_Role_DataTypeRole_Assignee_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recruiting_Self_Service_Schedule_Assign_Role_DataTypeRole_Assignee_ReferenceItem instanceof \StructType\RoleeObjectType) {
                $invalidValues[] = is_object($recruiting_Self_Service_Schedule_Assign_Role_DataTypeRole_Assignee_ReferenceItem) ? get_class($recruiting_Self_Service_Schedule_Assign_Role_DataTypeRole_Assignee_ReferenceItem) : sprintf('%s(%s)', gettype($recruiting_Self_Service_Schedule_Assign_Role_DataTypeRole_Assignee_ReferenceItem), var_export($recruiting_Self_Service_Schedule_Assign_Role_DataTypeRole_Assignee_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Role_Assignee_Reference property can only contain items of type \StructType\RoleeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Role_Assignee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RoleeObjectType[] $role_Assignee_Reference
     * @return \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType
     */
    public function setRole_Assignee_Reference(array $role_Assignee_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($role_Assignee_ReferenceArrayErrorMessage = self::validateRole_Assignee_ReferenceForArrayConstraintsFromSetRole_Assignee_Reference($role_Assignee_Reference))) {
            throw new \InvalidArgumentException($role_Assignee_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Role_Assignee_Reference = $role_Assignee_Reference;
        return $this;
    }
    /**
     * Add item to Role_Assignee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RoleeObjectType $item
     * @return \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType
     */
    public function addToRole_Assignee_Reference(\StructType\RoleeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoleeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Role_Assignee_Reference property can only contain items of type \StructType\RoleeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Role_Assignee_Reference[] = $item;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get Update value
     * @return bool|null
     */
    public function getUpdate()
    {
        return $this->Update;
    }
    /**
     * Set Update value
     * @param bool $update
     * @return \StructType\Recruiting_Self_Service_Schedule_Assign_Role_DataType
     */
    public function setUpdate($update = null)
    {
        // validation for constraint: boolean
        if (!is_null($update) && !is_bool($update)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($update, true), gettype($update)), __LINE__);
        }
        $this->Update = $update;
        return $this;
    }
}
