<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Self-Service_ScheduleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Section to add, update or delete Schedules for Recruiting Calendars.
 * @subpackage Structs
 */
class Recruiting_Self_Service_ScheduleType extends AbstractStructBase
{
    /**
     * The Schedule_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier used to reference a Recruiting Calendar Schedule.
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Service_ScheduleObjectType
     */
    public $Schedule_Reference;
    /**
     * The Schedule_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Service_Schedule_DataType
     */
    public $Schedule_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the request is only for adding a schedule.
     * @var bool
     */
    public $Add_Only;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the request is only for deleting a schedule.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Recruiting_Self-Service_ScheduleType
     * @uses Recruiting_Self_Service_ScheduleType::setSchedule_Reference()
     * @uses Recruiting_Self_Service_ScheduleType::setSchedule_Data()
     * @uses Recruiting_Self_Service_ScheduleType::setAdd_Only()
     * @uses Recruiting_Self_Service_ScheduleType::setDelete()
     * @param \StructType\Recruiting_Self_Service_ScheduleObjectType $schedule_Reference
     * @param \StructType\Recruiting_Self_Service_Schedule_DataType $schedule_Data
     * @param bool $add_Only
     * @param bool $delete
     */
    public function __construct(\StructType\Recruiting_Self_Service_ScheduleObjectType $schedule_Reference = null, \StructType\Recruiting_Self_Service_Schedule_DataType $schedule_Data = null, $add_Only = null, $delete = null)
    {
        $this
            ->setSchedule_Reference($schedule_Reference)
            ->setSchedule_Data($schedule_Data)
            ->setAdd_Only($add_Only)
            ->setDelete($delete);
    }
    /**
     * Get Schedule_Reference value
     * @return \StructType\Recruiting_Self_Service_ScheduleObjectType|null
     */
    public function getSchedule_Reference()
    {
        return $this->Schedule_Reference;
    }
    /**
     * Set Schedule_Reference value
     * @param \StructType\Recruiting_Self_Service_ScheduleObjectType $schedule_Reference
     * @return \StructType\Recruiting_Self_Service_ScheduleType
     */
    public function setSchedule_Reference(\StructType\Recruiting_Self_Service_ScheduleObjectType $schedule_Reference = null)
    {
        $this->Schedule_Reference = $schedule_Reference;
        return $this;
    }
    /**
     * Get Schedule_Data value
     * @return \StructType\Recruiting_Self_Service_Schedule_DataType|null
     */
    public function getSchedule_Data()
    {
        return $this->Schedule_Data;
    }
    /**
     * Set Schedule_Data value
     * @param \StructType\Recruiting_Self_Service_Schedule_DataType $schedule_Data
     * @return \StructType\Recruiting_Self_Service_ScheduleType
     */
    public function setSchedule_Data(\StructType\Recruiting_Self_Service_Schedule_DataType $schedule_Data = null)
    {
        $this->Schedule_Data = $schedule_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Recruiting_Self_Service_ScheduleType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Recruiting_Self_Service_ScheduleType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
