<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Self-Schedule_Calendar_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing data for the Recruiting Self-Schedule Calendar.
 * @subpackage Structs
 */
class Recruiting_Self_Schedule_Calendar_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier used to reference a Recruiting Self-Schedule Calendar.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The unique name for the Recruiting Self-Schedule Calendar.
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Recruiting_Self_Schedule_Calendar_External_Name
     * Meta information extracted from the WSDL
     * - documentation: Enter a name used by the External Calendar Name report field and displays in the My Scheduled Events section on Candidate Home.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Recruiting_Self_Schedule_Calendar_External_Name;
    /**
     * The Calendar_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Recruiting Self-Schedule Calendar type used by the Recruiting Self-Schedule Calendar.
     * @var \StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType
     */
    public $Calendar_Type_Reference;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: The duration for Employer Notice Period. Example: Number of Days, Weeks, or Months. | The number of minutes in a time slot within a time block. If you leave Time Slot Duration (minutes) 0, then there is only 1 time slot within the
     * time block and the Time Slot Duration (minutes) equals the minutes of the time block. Example: If the time block is 2 hours and Time Slot Duration (minutes) is 60, then the time block is divided into 2 time slots. If the time block is 2 hours and the
     * Time Slot Duration (minutes) is 0, then there is 1 time slot and the Time Slot Duration (minutes) still shows zero but is really 120 minutes.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $Duration;
    /**
     * The Earliest_Visibility
     * Meta information extracted from the WSDL
     * - documentation: Used to determine the time slots displayed to a candidate when they are making an appointment for a calendar event using the Candidate Self Schedule task.Workday adds this number of days to the current date to find the earliest date
     * for available time slots.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 3
     * @var float
     */
    public $Earliest_Visibility;
    /**
     * The Latest_Visibility
     * Meta information extracted from the WSDL
     * - documentation: Used to determine the time slots displayed to a candidate when they are making an appointment for a calendar event using the Candidate Self Schedule task.Workday adds this number of days to the current date to find the latest date
     * for available time slots.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 3
     * @var float
     */
    public $Latest_Visibility;
    /**
     * The Minimum_Number_of_Dates_to_Display
     * Meta information extracted from the WSDL
     * - documentation: The minimum number of dates with available time slots displayed to candidates. Dates beyond the latest visibility date will be shown if there aren't enough available dates within the visibility range to meet the minimum requirement.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 3
     * @var float
     */
    public $Minimum_Number_of_Dates_to_Display;
    /**
     * The Reschedule_Lock_Hours
     * Meta information extracted from the WSDL
     * - documentation: The number of hours prior to the event that a candidate can reschedule.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $Reschedule_Lock_Hours;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: A boolean flag indicating that the Recruiting Self-Schedule Calendar is inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Schedules
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Service_ScheduleType[]
     */
    public $Schedules;
    /**
     * The Excluded_Days
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType[]
     */
    public $Excluded_Days;
    /**
     * Constructor method for Recruiting_Self-Schedule_Calendar_DataType
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setID()
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setName()
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setRecruiting_Self_Schedule_Calendar_External_Name()
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setCalendar_Type_Reference()
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setDuration()
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setEarliest_Visibility()
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setLatest_Visibility()
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setMinimum_Number_of_Dates_to_Display()
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setReschedule_Lock_Hours()
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setInactive()
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setSchedules()
     * @uses Recruiting_Self_Schedule_Calendar_DataType::setExcluded_Days()
     * @param string $iD
     * @param string $name
     * @param string $recruiting_Self_Schedule_Calendar_External_Name
     * @param \StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType $calendar_Type_Reference
     * @param float $duration
     * @param float $earliest_Visibility
     * @param float $latest_Visibility
     * @param float $minimum_Number_of_Dates_to_Display
     * @param float $reschedule_Lock_Hours
     * @param bool $inactive
     * @param \StructType\Recruiting_Self_Service_ScheduleType[] $schedules
     * @param \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType[] $excluded_Days
     */
    public function __construct($iD = null, $name = null, $recruiting_Self_Schedule_Calendar_External_Name = null, \StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType $calendar_Type_Reference = null, $duration = null, $earliest_Visibility = null, $latest_Visibility = null, $minimum_Number_of_Dates_to_Display = null, $reschedule_Lock_Hours = null, $inactive = null, array $schedules = array(), array $excluded_Days = array())
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setRecruiting_Self_Schedule_Calendar_External_Name($recruiting_Self_Schedule_Calendar_External_Name)
            ->setCalendar_Type_Reference($calendar_Type_Reference)
            ->setDuration($duration)
            ->setEarliest_Visibility($earliest_Visibility)
            ->setLatest_Visibility($latest_Visibility)
            ->setMinimum_Number_of_Dates_to_Display($minimum_Number_of_Dates_to_Display)
            ->setReschedule_Lock_Hours($reschedule_Lock_Hours)
            ->setInactive($inactive)
            ->setSchedules($schedules)
            ->setExcluded_Days($excluded_Days);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Recruiting_Self_Schedule_Calendar_External_Name value
     * @return string|null
     */
    public function getRecruiting_Self_Schedule_Calendar_External_Name()
    {
        return $this->{'Recruiting_Self-Schedule_Calendar_External_Name'};
    }
    /**
     * Set Recruiting_Self_Schedule_Calendar_External_Name value
     * @param string $recruiting_Self_Schedule_Calendar_External_Name
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setRecruiting_Self_Schedule_Calendar_External_Name($recruiting_Self_Schedule_Calendar_External_Name = null)
    {
        // validation for constraint: string
        if (!is_null($recruiting_Self_Schedule_Calendar_External_Name) && !is_string($recruiting_Self_Schedule_Calendar_External_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recruiting_Self_Schedule_Calendar_External_Name, true), gettype($recruiting_Self_Schedule_Calendar_External_Name)), __LINE__);
        }
        $this->Recruiting_Self_Schedule_Calendar_External_Name = $this->{'Recruiting_Self-Schedule_Calendar_External_Name'} = $recruiting_Self_Schedule_Calendar_External_Name;
        return $this;
    }
    /**
     * Get Calendar_Type_Reference value
     * @return \StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType|null
     */
    public function getCalendar_Type_Reference()
    {
        return $this->Calendar_Type_Reference;
    }
    /**
     * Set Calendar_Type_Reference value
     * @param \StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType $calendar_Type_Reference
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setCalendar_Type_Reference(\StructType\Recruiting_Self_Schedule_Calendar_TypeObjectType $calendar_Type_Reference = null)
    {
        $this->Calendar_Type_Reference = $calendar_Type_Reference;
        return $this;
    }
    /**
     * Get Duration value
     * @return float|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param float $duration
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: float
        if (!is_null($duration) && !(is_float($duration) || is_numeric($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($duration) && mb_strlen(mb_substr($duration, false !== mb_strpos($duration, '.') ? mb_strpos($duration, '.') + 1 : mb_strlen($duration))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($duration, true), mb_strlen(mb_substr($duration, mb_strpos($duration, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($duration) && $duration < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($duration, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($duration) && mb_strlen(preg_replace('/(\D)/', '', $duration)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($duration, true), mb_strlen(preg_replace('/(\D)/', '', $duration))), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Earliest_Visibility value
     * @return float|null
     */
    public function getEarliest_Visibility()
    {
        return $this->Earliest_Visibility;
    }
    /**
     * Set Earliest_Visibility value
     * @param float $earliest_Visibility
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setEarliest_Visibility($earliest_Visibility = null)
    {
        // validation for constraint: float
        if (!is_null($earliest_Visibility) && !(is_float($earliest_Visibility) || is_numeric($earliest_Visibility))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($earliest_Visibility, true), gettype($earliest_Visibility)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($earliest_Visibility) && mb_strlen(mb_substr($earliest_Visibility, false !== mb_strpos($earliest_Visibility, '.') ? mb_strpos($earliest_Visibility, '.') + 1 : mb_strlen($earliest_Visibility))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($earliest_Visibility, true), mb_strlen(mb_substr($earliest_Visibility, mb_strpos($earliest_Visibility, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($earliest_Visibility) && $earliest_Visibility < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($earliest_Visibility, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($earliest_Visibility) && mb_strlen(preg_replace('/(\D)/', '', $earliest_Visibility)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($earliest_Visibility, true), mb_strlen(preg_replace('/(\D)/', '', $earliest_Visibility))), __LINE__);
        }
        $this->Earliest_Visibility = $earliest_Visibility;
        return $this;
    }
    /**
     * Get Latest_Visibility value
     * @return float|null
     */
    public function getLatest_Visibility()
    {
        return $this->Latest_Visibility;
    }
    /**
     * Set Latest_Visibility value
     * @param float $latest_Visibility
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setLatest_Visibility($latest_Visibility = null)
    {
        // validation for constraint: float
        if (!is_null($latest_Visibility) && !(is_float($latest_Visibility) || is_numeric($latest_Visibility))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latest_Visibility, true), gettype($latest_Visibility)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($latest_Visibility) && mb_strlen(mb_substr($latest_Visibility, false !== mb_strpos($latest_Visibility, '.') ? mb_strpos($latest_Visibility, '.') + 1 : mb_strlen($latest_Visibility))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($latest_Visibility, true), mb_strlen(mb_substr($latest_Visibility, mb_strpos($latest_Visibility, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($latest_Visibility) && $latest_Visibility < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($latest_Visibility, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($latest_Visibility) && mb_strlen(preg_replace('/(\D)/', '', $latest_Visibility)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($latest_Visibility, true), mb_strlen(preg_replace('/(\D)/', '', $latest_Visibility))), __LINE__);
        }
        $this->Latest_Visibility = $latest_Visibility;
        return $this;
    }
    /**
     * Get Minimum_Number_of_Dates_to_Display value
     * @return float|null
     */
    public function getMinimum_Number_of_Dates_to_Display()
    {
        return $this->Minimum_Number_of_Dates_to_Display;
    }
    /**
     * Set Minimum_Number_of_Dates_to_Display value
     * @param float $minimum_Number_of_Dates_to_Display
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setMinimum_Number_of_Dates_to_Display($minimum_Number_of_Dates_to_Display = null)
    {
        // validation for constraint: float
        if (!is_null($minimum_Number_of_Dates_to_Display) && !(is_float($minimum_Number_of_Dates_to_Display) || is_numeric($minimum_Number_of_Dates_to_Display))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum_Number_of_Dates_to_Display, true), gettype($minimum_Number_of_Dates_to_Display)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($minimum_Number_of_Dates_to_Display) && mb_strlen(mb_substr($minimum_Number_of_Dates_to_Display, false !== mb_strpos($minimum_Number_of_Dates_to_Display, '.') ? mb_strpos($minimum_Number_of_Dates_to_Display, '.') + 1 : mb_strlen($minimum_Number_of_Dates_to_Display))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($minimum_Number_of_Dates_to_Display, true), mb_strlen(mb_substr($minimum_Number_of_Dates_to_Display, mb_strpos($minimum_Number_of_Dates_to_Display, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($minimum_Number_of_Dates_to_Display) && $minimum_Number_of_Dates_to_Display < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($minimum_Number_of_Dates_to_Display, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($minimum_Number_of_Dates_to_Display) && mb_strlen(preg_replace('/(\D)/', '', $minimum_Number_of_Dates_to_Display)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($minimum_Number_of_Dates_to_Display, true), mb_strlen(preg_replace('/(\D)/', '', $minimum_Number_of_Dates_to_Display))), __LINE__);
        }
        $this->Minimum_Number_of_Dates_to_Display = $minimum_Number_of_Dates_to_Display;
        return $this;
    }
    /**
     * Get Reschedule_Lock_Hours value
     * @return float|null
     */
    public function getReschedule_Lock_Hours()
    {
        return $this->Reschedule_Lock_Hours;
    }
    /**
     * Set Reschedule_Lock_Hours value
     * @param float $reschedule_Lock_Hours
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setReschedule_Lock_Hours($reschedule_Lock_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($reschedule_Lock_Hours) && !(is_float($reschedule_Lock_Hours) || is_numeric($reschedule_Lock_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reschedule_Lock_Hours, true), gettype($reschedule_Lock_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($reschedule_Lock_Hours) && mb_strlen(mb_substr($reschedule_Lock_Hours, false !== mb_strpos($reschedule_Lock_Hours, '.') ? mb_strpos($reschedule_Lock_Hours, '.') + 1 : mb_strlen($reschedule_Lock_Hours))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($reschedule_Lock_Hours, true), mb_strlen(mb_substr($reschedule_Lock_Hours, mb_strpos($reschedule_Lock_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($reschedule_Lock_Hours) && $reschedule_Lock_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($reschedule_Lock_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($reschedule_Lock_Hours) && mb_strlen(preg_replace('/(\D)/', '', $reschedule_Lock_Hours)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($reschedule_Lock_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $reschedule_Lock_Hours))), __LINE__);
        }
        $this->Reschedule_Lock_Hours = $reschedule_Lock_Hours;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Schedules value
     * @return \StructType\Recruiting_Self_Service_ScheduleType[]|null
     */
    public function getSchedules()
    {
        return $this->Schedules;
    }
    /**
     * This method is responsible for validating the values passed to the setSchedules method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchedules method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchedulesForArrayConstraintsFromSetSchedules(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Self_Schedule_Calendar_DataTypeSchedulesItem) {
            // validation for constraint: itemType
            if (!$recruiting_Self_Schedule_Calendar_DataTypeSchedulesItem instanceof \StructType\Recruiting_Self_Service_ScheduleType) {
                $invalidValues[] = is_object($recruiting_Self_Schedule_Calendar_DataTypeSchedulesItem) ? get_class($recruiting_Self_Schedule_Calendar_DataTypeSchedulesItem) : sprintf('%s(%s)', gettype($recruiting_Self_Schedule_Calendar_DataTypeSchedulesItem), var_export($recruiting_Self_Schedule_Calendar_DataTypeSchedulesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schedules property can only contain items of type \StructType\Recruiting_Self_Service_ScheduleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schedules value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Self_Service_ScheduleType[] $schedules
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setSchedules(array $schedules = array())
    {
        // validation for constraint: array
        if ('' !== ($schedulesArrayErrorMessage = self::validateSchedulesForArrayConstraintsFromSetSchedules($schedules))) {
            throw new \InvalidArgumentException($schedulesArrayErrorMessage, __LINE__);
        }
        $this->Schedules = $schedules;
        return $this;
    }
    /**
     * Add item to Schedules value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Self_Service_ScheduleType $item
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function addToSchedules(\StructType\Recruiting_Self_Service_ScheduleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Self_Service_ScheduleType) {
            throw new \InvalidArgumentException(sprintf('The Schedules property can only contain items of type \StructType\Recruiting_Self_Service_ScheduleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schedules[] = $item;
        return $this;
    }
    /**
     * Get Excluded_Days value
     * @return \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType[]|null
     */
    public function getExcluded_Days()
    {
        return $this->Excluded_Days;
    }
    /**
     * This method is responsible for validating the values passed to the setExcluded_Days method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExcluded_Days method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExcluded_DaysForArrayConstraintsFromSetExcluded_Days(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Self_Schedule_Calendar_DataTypeExcluded_DaysItem) {
            // validation for constraint: itemType
            if (!$recruiting_Self_Schedule_Calendar_DataTypeExcluded_DaysItem instanceof \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType) {
                $invalidValues[] = is_object($recruiting_Self_Schedule_Calendar_DataTypeExcluded_DaysItem) ? get_class($recruiting_Self_Schedule_Calendar_DataTypeExcluded_DaysItem) : sprintf('%s(%s)', gettype($recruiting_Self_Schedule_Calendar_DataTypeExcluded_DaysItem), var_export($recruiting_Self_Schedule_Calendar_DataTypeExcluded_DaysItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Excluded_Days property can only contain items of type \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Excluded_Days value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType[] $excluded_Days
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function setExcluded_Days(array $excluded_Days = array())
    {
        // validation for constraint: array
        if ('' !== ($excluded_DaysArrayErrorMessage = self::validateExcluded_DaysForArrayConstraintsFromSetExcluded_Days($excluded_Days))) {
            throw new \InvalidArgumentException($excluded_DaysArrayErrorMessage, __LINE__);
        }
        $this->Excluded_Days = $excluded_Days;
        return $this;
    }
    /**
     * Add item to Excluded_Days value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType $item
     * @return \StructType\Recruiting_Self_Schedule_Calendar_DataType
     */
    public function addToExcluded_Days(\StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType) {
            throw new \InvalidArgumentException(sprintf('The Excluded_Days property can only contain items of type \StructType\Recruiting_Self_Service_Schedule_Excluded_DaysType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Excluded_Days[] = $item;
        return $this;
    }
}
