<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Agency_User_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Recruiting Agency User Data
 * @subpackage Structs
 */
class Recruiting_Agency_User_DataType extends AbstractStructBase
{
    /**
     * The Recruiting_Agency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Recruiting Agency to which the Recruiting Agency User belongs.
     * - maxOccurs: unbounded
     * @var \StructType\Recruiting_Agency_SiteObjectType[]
     */
    public $Recruiting_Agency_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Recruiting Agency User Inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Name_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element for all of the Name data for a person.
     * - minOccurs: 0
     * @var \StructType\Legal_Name_DataType
     */
    public $Name_Data;
    /**
     * The Contact_Information_Data
     * Meta information extracted from the WSDL
     * - documentation: Contact Information Data
     * - minOccurs: 0
     * @var \StructType\Contact_Information_DataType
     */
    public $Contact_Information_Data;
    /**
     * The LinkedIn_URL
     * Meta information extracted from the WSDL
     * - documentation: LinkedIn URL Data
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkedIn_URL;
    /**
     * The Twitter_User_Name
     * Meta information extracted from the WSDL
     * - documentation: Twitter User Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Twitter_User_Name;
    /**
     * The Facebook_URL
     * Meta information extracted from the WSDL
     * - documentation: Facebook URL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Facebook_URL;
    /**
     * The Google__URL
     * Meta information extracted from the WSDL
     * - documentation: Google+ URL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Google__URL;
    /**
     * The Recruiting_Agency_User_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Attachment WWS Data element
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_User_Attachment_DataType[]
     */
    public $Recruiting_Agency_User_Attachment_Data;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Recruiting Agency User ID
     * @var string
     */
    public $ID;
    /**
     * Constructor method for Recruiting_Agency_User_DataType
     * @uses Recruiting_Agency_User_DataType::setRecruiting_Agency_Reference()
     * @uses Recruiting_Agency_User_DataType::setInactive()
     * @uses Recruiting_Agency_User_DataType::setName_Data()
     * @uses Recruiting_Agency_User_DataType::setContact_Information_Data()
     * @uses Recruiting_Agency_User_DataType::setLinkedIn_URL()
     * @uses Recruiting_Agency_User_DataType::setTwitter_User_Name()
     * @uses Recruiting_Agency_User_DataType::setFacebook_URL()
     * @uses Recruiting_Agency_User_DataType::setGoogle__URL()
     * @uses Recruiting_Agency_User_DataType::setRecruiting_Agency_User_Attachment_Data()
     * @uses Recruiting_Agency_User_DataType::setID()
     * @param \StructType\Recruiting_Agency_SiteObjectType[] $recruiting_Agency_Reference
     * @param bool $inactive
     * @param \StructType\Legal_Name_DataType $name_Data
     * @param \StructType\Contact_Information_DataType $contact_Information_Data
     * @param string $linkedIn_URL
     * @param string $twitter_User_Name
     * @param string $facebook_URL
     * @param string $google__URL
     * @param \StructType\Recruiting_Agency_User_Attachment_DataType[] $recruiting_Agency_User_Attachment_Data
     * @param string $iD
     */
    public function __construct(array $recruiting_Agency_Reference = array(), $inactive = null, \StructType\Legal_Name_DataType $name_Data = null, \StructType\Contact_Information_DataType $contact_Information_Data = null, $linkedIn_URL = null, $twitter_User_Name = null, $facebook_URL = null, $google__URL = null, array $recruiting_Agency_User_Attachment_Data = array(), $iD = null)
    {
        $this
            ->setRecruiting_Agency_Reference($recruiting_Agency_Reference)
            ->setInactive($inactive)
            ->setName_Data($name_Data)
            ->setContact_Information_Data($contact_Information_Data)
            ->setLinkedIn_URL($linkedIn_URL)
            ->setTwitter_User_Name($twitter_User_Name)
            ->setFacebook_URL($facebook_URL)
            ->setGoogle__URL($google__URL)
            ->setRecruiting_Agency_User_Attachment_Data($recruiting_Agency_User_Attachment_Data)
            ->setID($iD);
    }
    /**
     * Get Recruiting_Agency_Reference value
     * @return \StructType\Recruiting_Agency_SiteObjectType[]|null
     */
    public function getRecruiting_Agency_Reference()
    {
        return $this->Recruiting_Agency_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRecruiting_Agency_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecruiting_Agency_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecruiting_Agency_ReferenceForArrayConstraintsFromSetRecruiting_Agency_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Agency_User_DataTypeRecruiting_Agency_ReferenceItem) {
            // validation for constraint: itemType
            if (!$recruiting_Agency_User_DataTypeRecruiting_Agency_ReferenceItem instanceof \StructType\Recruiting_Agency_SiteObjectType) {
                $invalidValues[] = is_object($recruiting_Agency_User_DataTypeRecruiting_Agency_ReferenceItem) ? get_class($recruiting_Agency_User_DataTypeRecruiting_Agency_ReferenceItem) : sprintf('%s(%s)', gettype($recruiting_Agency_User_DataTypeRecruiting_Agency_ReferenceItem), var_export($recruiting_Agency_User_DataTypeRecruiting_Agency_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recruiting_Agency_Reference property can only contain items of type \StructType\Recruiting_Agency_SiteObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recruiting_Agency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_SiteObjectType[] $recruiting_Agency_Reference
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function setRecruiting_Agency_Reference(array $recruiting_Agency_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($recruiting_Agency_ReferenceArrayErrorMessage = self::validateRecruiting_Agency_ReferenceForArrayConstraintsFromSetRecruiting_Agency_Reference($recruiting_Agency_Reference))) {
            throw new \InvalidArgumentException($recruiting_Agency_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Recruiting_Agency_Reference = $recruiting_Agency_Reference;
        return $this;
    }
    /**
     * Add item to Recruiting_Agency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_SiteObjectType $item
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function addToRecruiting_Agency_Reference(\StructType\Recruiting_Agency_SiteObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Agency_SiteObjectType) {
            throw new \InvalidArgumentException(sprintf('The Recruiting_Agency_Reference property can only contain items of type \StructType\Recruiting_Agency_SiteObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recruiting_Agency_Reference[] = $item;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Name_Data value
     * @return \StructType\Legal_Name_DataType|null
     */
    public function getName_Data()
    {
        return $this->Name_Data;
    }
    /**
     * Set Name_Data value
     * @param \StructType\Legal_Name_DataType $name_Data
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function setName_Data(\StructType\Legal_Name_DataType $name_Data = null)
    {
        $this->Name_Data = $name_Data;
        return $this;
    }
    /**
     * Get Contact_Information_Data value
     * @return \StructType\Contact_Information_DataType|null
     */
    public function getContact_Information_Data()
    {
        return $this->Contact_Information_Data;
    }
    /**
     * Set Contact_Information_Data value
     * @param \StructType\Contact_Information_DataType $contact_Information_Data
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function setContact_Information_Data(\StructType\Contact_Information_DataType $contact_Information_Data = null)
    {
        $this->Contact_Information_Data = $contact_Information_Data;
        return $this;
    }
    /**
     * Get LinkedIn_URL value
     * @return string|null
     */
    public function getLinkedIn_URL()
    {
        return $this->LinkedIn_URL;
    }
    /**
     * Set LinkedIn_URL value
     * @param string $linkedIn_URL
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function setLinkedIn_URL($linkedIn_URL = null)
    {
        // validation for constraint: string
        if (!is_null($linkedIn_URL) && !is_string($linkedIn_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedIn_URL, true), gettype($linkedIn_URL)), __LINE__);
        }
        $this->LinkedIn_URL = $linkedIn_URL;
        return $this;
    }
    /**
     * Get Twitter_User_Name value
     * @return string|null
     */
    public function getTwitter_User_Name()
    {
        return $this->Twitter_User_Name;
    }
    /**
     * Set Twitter_User_Name value
     * @param string $twitter_User_Name
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function setTwitter_User_Name($twitter_User_Name = null)
    {
        // validation for constraint: string
        if (!is_null($twitter_User_Name) && !is_string($twitter_User_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($twitter_User_Name, true), gettype($twitter_User_Name)), __LINE__);
        }
        $this->Twitter_User_Name = $twitter_User_Name;
        return $this;
    }
    /**
     * Get Facebook_URL value
     * @return string|null
     */
    public function getFacebook_URL()
    {
        return $this->Facebook_URL;
    }
    /**
     * Set Facebook_URL value
     * @param string $facebook_URL
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function setFacebook_URL($facebook_URL = null)
    {
        // validation for constraint: string
        if (!is_null($facebook_URL) && !is_string($facebook_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facebook_URL, true), gettype($facebook_URL)), __LINE__);
        }
        $this->Facebook_URL = $facebook_URL;
        return $this;
    }
    /**
     * Get Google__URL value
     * @return string|null
     */
    public function getGoogle__URL()
    {
        return $this->Google__URL;
    }
    /**
     * Set Google__URL value
     * @param string $google__URL
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function setGoogle__URL($google__URL = null)
    {
        // validation for constraint: string
        if (!is_null($google__URL) && !is_string($google__URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($google__URL, true), gettype($google__URL)), __LINE__);
        }
        $this->Google__URL = $google__URL;
        return $this;
    }
    /**
     * Get Recruiting_Agency_User_Attachment_Data value
     * @return \StructType\Recruiting_Agency_User_Attachment_DataType[]|null
     */
    public function getRecruiting_Agency_User_Attachment_Data()
    {
        return $this->Recruiting_Agency_User_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRecruiting_Agency_User_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecruiting_Agency_User_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecruiting_Agency_User_Attachment_DataForArrayConstraintsFromSetRecruiting_Agency_User_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_Agency_User_DataTypeRecruiting_Agency_User_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$recruiting_Agency_User_DataTypeRecruiting_Agency_User_Attachment_DataItem instanceof \StructType\Recruiting_Agency_User_Attachment_DataType) {
                $invalidValues[] = is_object($recruiting_Agency_User_DataTypeRecruiting_Agency_User_Attachment_DataItem) ? get_class($recruiting_Agency_User_DataTypeRecruiting_Agency_User_Attachment_DataItem) : sprintf('%s(%s)', gettype($recruiting_Agency_User_DataTypeRecruiting_Agency_User_Attachment_DataItem), var_export($recruiting_Agency_User_DataTypeRecruiting_Agency_User_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recruiting_Agency_User_Attachment_Data property can only contain items of type \StructType\Recruiting_Agency_User_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recruiting_Agency_User_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_User_Attachment_DataType[] $recruiting_Agency_User_Attachment_Data
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function setRecruiting_Agency_User_Attachment_Data(array $recruiting_Agency_User_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($recruiting_Agency_User_Attachment_DataArrayErrorMessage = self::validateRecruiting_Agency_User_Attachment_DataForArrayConstraintsFromSetRecruiting_Agency_User_Attachment_Data($recruiting_Agency_User_Attachment_Data))) {
            throw new \InvalidArgumentException($recruiting_Agency_User_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Recruiting_Agency_User_Attachment_Data = $recruiting_Agency_User_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Recruiting_Agency_User_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_User_Attachment_DataType $item
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function addToRecruiting_Agency_User_Attachment_Data(\StructType\Recruiting_Agency_User_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Agency_User_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Recruiting_Agency_User_Attachment_Data property can only contain items of type \StructType\Recruiting_Agency_User_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recruiting_Agency_User_Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Recruiting_Agency_User_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
}
