<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_Agency_Payout_Terms_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Recruiting Agency Payout Terms Data
 * @subpackage Structs
 */
class Recruiting_Agency_Payout_Terms_DataType extends AbstractStructBase
{
    /**
     * The Recruiting_Agency_Fee_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Determines how to calculate the payout for the recruiting agency. A fee type, such as percentage or flat fee, must be selected.
     * @var \StructType\Recruiting_Agency_Fee_TypeObjectType
     */
    public $Recruiting_Agency_Fee_Type_Reference;
    /**
     * The Fee_Value
     * Meta information extracted from the WSDL
     * - documentation: Used in calculating the payout for the recruiting agency. A fee value is required. If a percentage fee type is selected, then the value must be between 1 and 100.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 22
     * @var float
     */
    public $Fee_Value;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Determines the currency of the payout for the recruiting agency.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * Constructor method for Recruiting_Agency_Payout_Terms_DataType
     * @uses Recruiting_Agency_Payout_Terms_DataType::setRecruiting_Agency_Fee_Type_Reference()
     * @uses Recruiting_Agency_Payout_Terms_DataType::setFee_Value()
     * @uses Recruiting_Agency_Payout_Terms_DataType::setCurrency_Reference()
     * @param \StructType\Recruiting_Agency_Fee_TypeObjectType $recruiting_Agency_Fee_Type_Reference
     * @param float $fee_Value
     * @param \StructType\CurrencyObjectType $currency_Reference
     */
    public function __construct(\StructType\Recruiting_Agency_Fee_TypeObjectType $recruiting_Agency_Fee_Type_Reference = null, $fee_Value = null, \StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this
            ->setRecruiting_Agency_Fee_Type_Reference($recruiting_Agency_Fee_Type_Reference)
            ->setFee_Value($fee_Value)
            ->setCurrency_Reference($currency_Reference);
    }
    /**
     * Get Recruiting_Agency_Fee_Type_Reference value
     * @return \StructType\Recruiting_Agency_Fee_TypeObjectType|null
     */
    public function getRecruiting_Agency_Fee_Type_Reference()
    {
        return $this->Recruiting_Agency_Fee_Type_Reference;
    }
    /**
     * Set Recruiting_Agency_Fee_Type_Reference value
     * @param \StructType\Recruiting_Agency_Fee_TypeObjectType $recruiting_Agency_Fee_Type_Reference
     * @return \StructType\Recruiting_Agency_Payout_Terms_DataType
     */
    public function setRecruiting_Agency_Fee_Type_Reference(\StructType\Recruiting_Agency_Fee_TypeObjectType $recruiting_Agency_Fee_Type_Reference = null)
    {
        $this->Recruiting_Agency_Fee_Type_Reference = $recruiting_Agency_Fee_Type_Reference;
        return $this;
    }
    /**
     * Get Fee_Value value
     * @return float|null
     */
    public function getFee_Value()
    {
        return $this->Fee_Value;
    }
    /**
     * Set Fee_Value value
     * @param float $fee_Value
     * @return \StructType\Recruiting_Agency_Payout_Terms_DataType
     */
    public function setFee_Value($fee_Value = null)
    {
        // validation for constraint: float
        if (!is_null($fee_Value) && !(is_float($fee_Value) || is_numeric($fee_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fee_Value, true), gettype($fee_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($fee_Value) && mb_strlen(mb_substr($fee_Value, false !== mb_strpos($fee_Value, '.') ? mb_strpos($fee_Value, '.') + 1 : mb_strlen($fee_Value))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($fee_Value, true), mb_strlen(mb_substr($fee_Value, mb_strpos($fee_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fee_Value) && $fee_Value < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fee_Value, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($fee_Value) && mb_strlen(preg_replace('/(\D)/', '', $fee_Value)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($fee_Value, true), mb_strlen(preg_replace('/(\D)/', '', $fee_Value))), __LINE__);
        }
        $this->Fee_Value = $fee_Value;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Recruiting_Agency_Payout_Terms_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
}
