<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recruiting_AgencyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains details about a Recruiting Agency Site
 * @subpackage Structs
 */
class Recruiting_AgencyType extends AbstractStructBase
{
    /**
     * The Recruiting_Agency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Represents a unique instance of Recruiting Agency Site
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_SiteObjectType
     */
    public $Recruiting_Agency_Reference;
    /**
     * The Recruiting_Agency_Data
     * Meta information extracted from the WSDL
     * - documentation: Recruiting Agency data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_DataType[]
     */
    public $Recruiting_Agency_Data;
    /**
     * Constructor method for Recruiting_AgencyType
     * @uses Recruiting_AgencyType::setRecruiting_Agency_Reference()
     * @uses Recruiting_AgencyType::setRecruiting_Agency_Data()
     * @param \StructType\Recruiting_Agency_SiteObjectType $recruiting_Agency_Reference
     * @param \StructType\Recruiting_Agency_DataType[] $recruiting_Agency_Data
     */
    public function __construct(\StructType\Recruiting_Agency_SiteObjectType $recruiting_Agency_Reference = null, array $recruiting_Agency_Data = array())
    {
        $this
            ->setRecruiting_Agency_Reference($recruiting_Agency_Reference)
            ->setRecruiting_Agency_Data($recruiting_Agency_Data);
    }
    /**
     * Get Recruiting_Agency_Reference value
     * @return \StructType\Recruiting_Agency_SiteObjectType|null
     */
    public function getRecruiting_Agency_Reference()
    {
        return $this->Recruiting_Agency_Reference;
    }
    /**
     * Set Recruiting_Agency_Reference value
     * @param \StructType\Recruiting_Agency_SiteObjectType $recruiting_Agency_Reference
     * @return \StructType\Recruiting_AgencyType
     */
    public function setRecruiting_Agency_Reference(\StructType\Recruiting_Agency_SiteObjectType $recruiting_Agency_Reference = null)
    {
        $this->Recruiting_Agency_Reference = $recruiting_Agency_Reference;
        return $this;
    }
    /**
     * Get Recruiting_Agency_Data value
     * @return \StructType\Recruiting_Agency_DataType[]|null
     */
    public function getRecruiting_Agency_Data()
    {
        return $this->Recruiting_Agency_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRecruiting_Agency_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecruiting_Agency_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecruiting_Agency_DataForArrayConstraintsFromSetRecruiting_Agency_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recruiting_AgencyTypeRecruiting_Agency_DataItem) {
            // validation for constraint: itemType
            if (!$recruiting_AgencyTypeRecruiting_Agency_DataItem instanceof \StructType\Recruiting_Agency_DataType) {
                $invalidValues[] = is_object($recruiting_AgencyTypeRecruiting_Agency_DataItem) ? get_class($recruiting_AgencyTypeRecruiting_Agency_DataItem) : sprintf('%s(%s)', gettype($recruiting_AgencyTypeRecruiting_Agency_DataItem), var_export($recruiting_AgencyTypeRecruiting_Agency_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recruiting_Agency_Data property can only contain items of type \StructType\Recruiting_Agency_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recruiting_Agency_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_DataType[] $recruiting_Agency_Data
     * @return \StructType\Recruiting_AgencyType
     */
    public function setRecruiting_Agency_Data(array $recruiting_Agency_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($recruiting_Agency_DataArrayErrorMessage = self::validateRecruiting_Agency_DataForArrayConstraintsFromSetRecruiting_Agency_Data($recruiting_Agency_Data))) {
            throw new \InvalidArgumentException($recruiting_Agency_DataArrayErrorMessage, __LINE__);
        }
        $this->Recruiting_Agency_Data = $recruiting_Agency_Data;
        return $this;
    }
    /**
     * Add item to Recruiting_Agency_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_DataType $item
     * @return \StructType\Recruiting_AgencyType
     */
    public function addToRecruiting_Agency_Data(\StructType\Recruiting_Agency_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recruiting_Agency_DataType) {
            throw new \InvalidArgumentException(sprintf('The Recruiting_Agency_Data property can only contain items of type \StructType\Recruiting_Agency_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recruiting_Agency_Data[] = $item;
        return $this;
    }
}
