<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Questionnaire_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The response for a questionnaire request.
 * @subpackage Structs
 */
class Questionnaire_Response_DataType extends AbstractStructBase
{
    /**
     * The Questionnaire
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\QuestionnaireType[]
     */
    public $Questionnaire;
    /**
     * Constructor method for Questionnaire_Response_DataType
     * @uses Questionnaire_Response_DataType::setQuestionnaire()
     * @param \StructType\QuestionnaireType[] $questionnaire
     */
    public function __construct(array $questionnaire = array())
    {
        $this
            ->setQuestionnaire($questionnaire);
    }
    /**
     * Get Questionnaire value
     * @return \StructType\QuestionnaireType[]|null
     */
    public function getQuestionnaire()
    {
        return $this->Questionnaire;
    }
    /**
     * This method is responsible for validating the values passed to the setQuestionnaire method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuestionnaire method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuestionnaireForArrayConstraintsFromSetQuestionnaire(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $questionnaire_Response_DataTypeQuestionnaireItem) {
            // validation for constraint: itemType
            if (!$questionnaire_Response_DataTypeQuestionnaireItem instanceof \StructType\QuestionnaireType) {
                $invalidValues[] = is_object($questionnaire_Response_DataTypeQuestionnaireItem) ? get_class($questionnaire_Response_DataTypeQuestionnaireItem) : sprintf('%s(%s)', gettype($questionnaire_Response_DataTypeQuestionnaireItem), var_export($questionnaire_Response_DataTypeQuestionnaireItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Questionnaire property can only contain items of type \StructType\QuestionnaireType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Questionnaire value
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionnaireType[] $questionnaire
     * @return \StructType\Questionnaire_Response_DataType
     */
    public function setQuestionnaire(array $questionnaire = array())
    {
        // validation for constraint: array
        if ('' !== ($questionnaireArrayErrorMessage = self::validateQuestionnaireForArrayConstraintsFromSetQuestionnaire($questionnaire))) {
            throw new \InvalidArgumentException($questionnaireArrayErrorMessage, __LINE__);
        }
        $this->Questionnaire = $questionnaire;
        return $this;
    }
    /**
     * Add item to Questionnaire value
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionnaireType $item
     * @return \StructType\Questionnaire_Response_DataType
     */
    public function addToQuestionnaire(\StructType\QuestionnaireType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QuestionnaireType) {
            throw new \InvalidArgumentException(sprintf('The Questionnaire property can only contain items of type \StructType\QuestionnaireType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Questionnaire[] = $item;
        return $this;
    }
}
