<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Questionnaire_Answer_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the questions and answers on the questionnaire response.
 * @subpackage Structs
 */
class Questionnaire_Answer_DataType extends AbstractStructBase
{
    /**
     * The Question_Order
     * Meta information extracted from the WSDL
     * - documentation: The order the question appears on the questionnaire.
     * - maxOccurs: 1
     * @var string
     */
    public $Question_Order;
    /**
     * The Multiple_Choice_Answer_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains a multiple choice answer for the question.
     * - choice: Multiple_Choice_Answer_Data | Answer_Date | Answer_Numeric | Answer_Text | Attachment_Answer_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Multiple_Choice_Answer_DataType[]
     */
    public $Multiple_Choice_Answer_Data;
    /**
     * The Answer_Date
     * Meta information extracted from the WSDL
     * - documentation: Date answer for the question.
     * - choice: Multiple_Choice_Answer_Data | Answer_Date | Answer_Numeric | Answer_Text | Attachment_Answer_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Answer_Date;
    /**
     * The Answer_Numeric
     * Meta information extracted from the WSDL
     * - documentation: Numeric answer for the question.
     * - base: xsd:decimal
     * - choice: Multiple_Choice_Answer_Data | Answer_Date | Answer_Numeric | Answer_Text | Attachment_Answer_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Answer_Numeric;
    /**
     * The Answer_Text
     * Meta information extracted from the WSDL
     * - documentation: Text answer for the question.
     * - choice: Multiple_Choice_Answer_Data | Answer_Date | Answer_Numeric | Answer_Text | Attachment_Answer_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Answer_Text;
    /**
     * The Attachment_Answer_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains an attachment answer for the question.
     * - choice: Multiple_Choice_Answer_Data | Answer_Date | Answer_Numeric | Answer_Text | Attachment_Answer_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Questionnaire_Attachment_Answer_DataType[]
     */
    public $Attachment_Answer_Data;
    /**
     * Constructor method for Questionnaire_Answer_DataType
     * @uses Questionnaire_Answer_DataType::setQuestion_Order()
     * @uses Questionnaire_Answer_DataType::setMultiple_Choice_Answer_Data()
     * @uses Questionnaire_Answer_DataType::setAnswer_Date()
     * @uses Questionnaire_Answer_DataType::setAnswer_Numeric()
     * @uses Questionnaire_Answer_DataType::setAnswer_Text()
     * @uses Questionnaire_Answer_DataType::setAttachment_Answer_Data()
     * @param string $question_Order
     * @param \StructType\Multiple_Choice_Answer_DataType[] $multiple_Choice_Answer_Data
     * @param string $answer_Date
     * @param float $answer_Numeric
     * @param string $answer_Text
     * @param \StructType\Questionnaire_Attachment_Answer_DataType[] $attachment_Answer_Data
     */
    public function __construct($question_Order = null, array $multiple_Choice_Answer_Data = array(), $answer_Date = null, $answer_Numeric = null, $answer_Text = null, array $attachment_Answer_Data = array())
    {
        $this
            ->setQuestion_Order($question_Order)
            ->setMultiple_Choice_Answer_Data($multiple_Choice_Answer_Data)
            ->setAnswer_Date($answer_Date)
            ->setAnswer_Numeric($answer_Numeric)
            ->setAnswer_Text($answer_Text)
            ->setAttachment_Answer_Data($attachment_Answer_Data);
    }
    /**
     * Get Question_Order value
     * @return string|null
     */
    public function getQuestion_Order()
    {
        return $this->Question_Order;
    }
    /**
     * Set Question_Order value
     * @param string $question_Order
     * @return \StructType\Questionnaire_Answer_DataType
     */
    public function setQuestion_Order($question_Order = null)
    {
        // validation for constraint: string
        if (!is_null($question_Order) && !is_string($question_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($question_Order, true), gettype($question_Order)), __LINE__);
        }
        $this->Question_Order = $question_Order;
        return $this;
    }
    /**
     * Get Multiple_Choice_Answer_Data value
     * @return \StructType\Multiple_Choice_Answer_DataType[]|null
     */
    public function getMultiple_Choice_Answer_Data()
    {
        return isset($this->Multiple_Choice_Answer_Data) ? $this->Multiple_Choice_Answer_Data : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiple_Choice_Answer_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiple_Choice_Answer_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiple_Choice_Answer_DataForArrayConstraintsFromSetMultiple_Choice_Answer_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $questionnaire_Answer_DataTypeMultiple_Choice_Answer_DataItem) {
            // validation for constraint: itemType
            if (!$questionnaire_Answer_DataTypeMultiple_Choice_Answer_DataItem instanceof \StructType\Multiple_Choice_Answer_DataType) {
                $invalidValues[] = is_object($questionnaire_Answer_DataTypeMultiple_Choice_Answer_DataItem) ? get_class($questionnaire_Answer_DataTypeMultiple_Choice_Answer_DataItem) : sprintf('%s(%s)', gettype($questionnaire_Answer_DataTypeMultiple_Choice_Answer_DataItem), var_export($questionnaire_Answer_DataTypeMultiple_Choice_Answer_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Multiple_Choice_Answer_Data property can only contain items of type \StructType\Multiple_Choice_Answer_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMultiple_Choice_Answer_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiple_Choice_Answer_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMultiple_Choice_Answer_DataForChoiceConstraintsFromSetMultiple_Choice_Answer_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Answer_Date',
            'Answer_Numeric',
            'Answer_Text',
            'Attachment_Answer_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Multiple_Choice_Answer_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Multiple_Choice_Answer_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Multiple_Choice_Answer_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Multiple_Choice_Answer_DataType[] $multiple_Choice_Answer_Data
     * @return \StructType\Questionnaire_Answer_DataType
     */
    public function setMultiple_Choice_Answer_Data(array $multiple_Choice_Answer_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($multiple_Choice_Answer_DataArrayErrorMessage = self::validateMultiple_Choice_Answer_DataForArrayConstraintsFromSetMultiple_Choice_Answer_Data($multiple_Choice_Answer_Data))) {
            throw new \InvalidArgumentException($multiple_Choice_Answer_DataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Multiple_Choice_Answer_Data, Answer_Date, Answer_Numeric, Answer_Text, Attachment_Answer_Data)
        if ('' !== ($multiple_Choice_Answer_DataChoiceErrorMessage = self::validateMultiple_Choice_Answer_DataForChoiceConstraintsFromSetMultiple_Choice_Answer_Data($multiple_Choice_Answer_Data))) {
            throw new \InvalidArgumentException($multiple_Choice_Answer_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($multiple_Choice_Answer_Data) || (is_array($multiple_Choice_Answer_Data) && empty($multiple_Choice_Answer_Data))) {
            unset($this->Multiple_Choice_Answer_Data);
        } else {
            $this->Multiple_Choice_Answer_Data = $multiple_Choice_Answer_Data;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToMultiple_Choice_Answer_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToMultiple_Choice_Answer_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToMultiple_Choice_Answer_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Answer_Date',
            'Answer_Numeric',
            'Answer_Text',
            'Attachment_Answer_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Multiple_Choice_Answer_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Multiple_Choice_Answer_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Multiple_Choice_Answer_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Multiple_Choice_Answer_DataType $item
     * @return \StructType\Questionnaire_Answer_DataType
     */
    public function addToMultiple_Choice_Answer_Data(\StructType\Multiple_Choice_Answer_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Multiple_Choice_Answer_DataType) {
            throw new \InvalidArgumentException(sprintf('The Multiple_Choice_Answer_Data property can only contain items of type \StructType\Multiple_Choice_Answer_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Multiple_Choice_Answer_Data, Answer_Date, Answer_Numeric, Answer_Text, Attachment_Answer_Data)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToMultiple_Choice_Answer_Data($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Multiple_Choice_Answer_Data[] = $item;
        return $this;
    }
    /**
     * Get Answer_Date value
     * @return string|null
     */
    public function getAnswer_Date()
    {
        return isset($this->Answer_Date) ? $this->Answer_Date : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAnswer_Date method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnswer_Date method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAnswer_DateForChoiceConstraintsFromSetAnswer_Date($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Multiple_Choice_Answer_Data',
            'Answer_Numeric',
            'Answer_Text',
            'Attachment_Answer_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Answer_Date can\'t be set as the property %s is already set. Only one property must be set among these properties: Answer_Date, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Answer_Date value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $answer_Date
     * @return \StructType\Questionnaire_Answer_DataType
     */
    public function setAnswer_Date($answer_Date = null)
    {
        // validation for constraint: string
        if (!is_null($answer_Date) && !is_string($answer_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answer_Date, true), gettype($answer_Date)), __LINE__);
        }
        // validation for constraint: choice(Multiple_Choice_Answer_Data, Answer_Date, Answer_Numeric, Answer_Text, Attachment_Answer_Data)
        if ('' !== ($answer_DateChoiceErrorMessage = self::validateAnswer_DateForChoiceConstraintsFromSetAnswer_Date($answer_Date))) {
            throw new \InvalidArgumentException($answer_DateChoiceErrorMessage, __LINE__);
        }
        if (is_null($answer_Date) || (is_array($answer_Date) && empty($answer_Date))) {
            unset($this->Answer_Date);
        } else {
            $this->Answer_Date = $answer_Date;
        }
        return $this;
    }
    /**
     * Get Answer_Numeric value
     * @return float|null
     */
    public function getAnswer_Numeric()
    {
        return isset($this->Answer_Numeric) ? $this->Answer_Numeric : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAnswer_Numeric method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnswer_Numeric method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAnswer_NumericForChoiceConstraintsFromSetAnswer_Numeric($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Multiple_Choice_Answer_Data',
            'Answer_Date',
            'Answer_Text',
            'Attachment_Answer_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Answer_Numeric can\'t be set as the property %s is already set. Only one property must be set among these properties: Answer_Numeric, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Answer_Numeric value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $answer_Numeric
     * @return \StructType\Questionnaire_Answer_DataType
     */
    public function setAnswer_Numeric($answer_Numeric = null)
    {
        // validation for constraint: float
        if (!is_null($answer_Numeric) && !(is_float($answer_Numeric) || is_numeric($answer_Numeric))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($answer_Numeric, true), gettype($answer_Numeric)), __LINE__);
        }
        // validation for constraint: choice(Multiple_Choice_Answer_Data, Answer_Date, Answer_Numeric, Answer_Text, Attachment_Answer_Data)
        if ('' !== ($answer_NumericChoiceErrorMessage = self::validateAnswer_NumericForChoiceConstraintsFromSetAnswer_Numeric($answer_Numeric))) {
            throw new \InvalidArgumentException($answer_NumericChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($answer_Numeric) && mb_strlen(mb_substr($answer_Numeric, false !== mb_strpos($answer_Numeric, '.') ? mb_strpos($answer_Numeric, '.') + 1 : mb_strlen($answer_Numeric))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($answer_Numeric, true), mb_strlen(mb_substr($answer_Numeric, mb_strpos($answer_Numeric, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($answer_Numeric) && $answer_Numeric < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($answer_Numeric, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($answer_Numeric) && mb_strlen(preg_replace('/(\D)/', '', $answer_Numeric)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($answer_Numeric, true), mb_strlen(preg_replace('/(\D)/', '', $answer_Numeric))), __LINE__);
        }
        if (is_null($answer_Numeric) || (is_array($answer_Numeric) && empty($answer_Numeric))) {
            unset($this->Answer_Numeric);
        } else {
            $this->Answer_Numeric = $answer_Numeric;
        }
        return $this;
    }
    /**
     * Get Answer_Text value
     * @return string|null
     */
    public function getAnswer_Text()
    {
        return isset($this->Answer_Text) ? $this->Answer_Text : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAnswer_Text method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnswer_Text method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAnswer_TextForChoiceConstraintsFromSetAnswer_Text($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Multiple_Choice_Answer_Data',
            'Answer_Date',
            'Answer_Numeric',
            'Attachment_Answer_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Answer_Text can\'t be set as the property %s is already set. Only one property must be set among these properties: Answer_Text, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Answer_Text value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $answer_Text
     * @return \StructType\Questionnaire_Answer_DataType
     */
    public function setAnswer_Text($answer_Text = null)
    {
        // validation for constraint: string
        if (!is_null($answer_Text) && !is_string($answer_Text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answer_Text, true), gettype($answer_Text)), __LINE__);
        }
        // validation for constraint: choice(Multiple_Choice_Answer_Data, Answer_Date, Answer_Numeric, Answer_Text, Attachment_Answer_Data)
        if ('' !== ($answer_TextChoiceErrorMessage = self::validateAnswer_TextForChoiceConstraintsFromSetAnswer_Text($answer_Text))) {
            throw new \InvalidArgumentException($answer_TextChoiceErrorMessage, __LINE__);
        }
        if (is_null($answer_Text) || (is_array($answer_Text) && empty($answer_Text))) {
            unset($this->Answer_Text);
        } else {
            $this->Answer_Text = $answer_Text;
        }
        return $this;
    }
    /**
     * Get Attachment_Answer_Data value
     * @return \StructType\Questionnaire_Attachment_Answer_DataType[]|null
     */
    public function getAttachment_Answer_Data()
    {
        return isset($this->Attachment_Answer_Data) ? $this->Attachment_Answer_Data : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Answer_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Answer_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_Answer_DataForArrayConstraintsFromSetAttachment_Answer_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $questionnaire_Answer_DataTypeAttachment_Answer_DataItem) {
            // validation for constraint: itemType
            if (!$questionnaire_Answer_DataTypeAttachment_Answer_DataItem instanceof \StructType\Questionnaire_Attachment_Answer_DataType) {
                $invalidValues[] = is_object($questionnaire_Answer_DataTypeAttachment_Answer_DataItem) ? get_class($questionnaire_Answer_DataTypeAttachment_Answer_DataItem) : sprintf('%s(%s)', gettype($questionnaire_Answer_DataTypeAttachment_Answer_DataItem), var_export($questionnaire_Answer_DataTypeAttachment_Answer_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Answer_Data property can only contain items of type \StructType\Questionnaire_Attachment_Answer_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAttachment_Answer_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Answer_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAttachment_Answer_DataForChoiceConstraintsFromSetAttachment_Answer_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Multiple_Choice_Answer_Data',
            'Answer_Date',
            'Answer_Numeric',
            'Answer_Text',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Attachment_Answer_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Attachment_Answer_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Attachment_Answer_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Questionnaire_Attachment_Answer_DataType[] $attachment_Answer_Data
     * @return \StructType\Questionnaire_Answer_DataType
     */
    public function setAttachment_Answer_Data(array $attachment_Answer_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_Answer_DataArrayErrorMessage = self::validateAttachment_Answer_DataForArrayConstraintsFromSetAttachment_Answer_Data($attachment_Answer_Data))) {
            throw new \InvalidArgumentException($attachment_Answer_DataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Multiple_Choice_Answer_Data, Answer_Date, Answer_Numeric, Answer_Text, Attachment_Answer_Data)
        if ('' !== ($attachment_Answer_DataChoiceErrorMessage = self::validateAttachment_Answer_DataForChoiceConstraintsFromSetAttachment_Answer_Data($attachment_Answer_Data))) {
            throw new \InvalidArgumentException($attachment_Answer_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($attachment_Answer_Data) || (is_array($attachment_Answer_Data) && empty($attachment_Answer_Data))) {
            unset($this->Attachment_Answer_Data);
        } else {
            $this->Attachment_Answer_Data = $attachment_Answer_Data;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToAttachment_Answer_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToAttachment_Answer_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToAttachment_Answer_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Multiple_Choice_Answer_Data',
            'Answer_Date',
            'Answer_Numeric',
            'Answer_Text',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Attachment_Answer_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Attachment_Answer_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Attachment_Answer_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Questionnaire_Attachment_Answer_DataType $item
     * @return \StructType\Questionnaire_Answer_DataType
     */
    public function addToAttachment_Answer_Data(\StructType\Questionnaire_Attachment_Answer_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Questionnaire_Attachment_Answer_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Answer_Data property can only contain items of type \StructType\Questionnaire_Attachment_Answer_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Multiple_Choice_Answer_Data, Answer_Date, Answer_Numeric, Answer_Text, Attachment_Answer_Data)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToAttachment_Answer_Data($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Attachment_Answer_Data[] = $item;
        return $this;
    }
}
