<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Web_Conference_Interview_Data_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains interview data for the web conference.
 * @subpackage Structs
 */
class Put_Web_Conference_Interview_Data_RequestType extends AbstractStructBase
{
    /**
     * The Schedule_Snapshot_WID_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Schedule Snapshot where the Put Web Conference Interview Data web service updates the Interview Custom Integration event.
     * - maxOccurs: 1
     * @var string
     */
    public $Schedule_Snapshot_WID_Reference;
    /**
     * The Interview_Custom_Integration_WID_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Interview Custom Integration Event where Put Web Conference Interview Data web service saves the Web Conference Meeting ID/URL.
     * - maxOccurs: 1
     * @var string
     */
    public $Interview_Custom_Integration_WID_Reference;
    /**
     * The Web_Conference_Meeting_ID_Reference
     * Meta information extracted from the WSDL
     * - documentation: The web conference meeting ID that the Put Web Conference Interview Data web service saves to the Interview Custom Integration event.
     * - maxOccurs: 1
     * @var string
     */
    public $Web_Conference_Meeting_ID_Reference;
    /**
     * The Web_Conference_URL_Reference
     * Meta information extracted from the WSDL
     * - documentation: The web conference URL that the Put Web Conference Interview Data web service saves to the Interview Custom Integration event.
     * - maxOccurs: 1
     * @var string
     */
    public $Web_Conference_URL_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Web_Conference_Interview_Data_RequestType
     * @uses Put_Web_Conference_Interview_Data_RequestType::setSchedule_Snapshot_WID_Reference()
     * @uses Put_Web_Conference_Interview_Data_RequestType::setInterview_Custom_Integration_WID_Reference()
     * @uses Put_Web_Conference_Interview_Data_RequestType::setWeb_Conference_Meeting_ID_Reference()
     * @uses Put_Web_Conference_Interview_Data_RequestType::setWeb_Conference_URL_Reference()
     * @uses Put_Web_Conference_Interview_Data_RequestType::setVersion()
     * @param string $schedule_Snapshot_WID_Reference
     * @param string $interview_Custom_Integration_WID_Reference
     * @param string $web_Conference_Meeting_ID_Reference
     * @param string $web_Conference_URL_Reference
     * @param string $version
     */
    public function __construct($schedule_Snapshot_WID_Reference = null, $interview_Custom_Integration_WID_Reference = null, $web_Conference_Meeting_ID_Reference = null, $web_Conference_URL_Reference = null, $version = null)
    {
        $this
            ->setSchedule_Snapshot_WID_Reference($schedule_Snapshot_WID_Reference)
            ->setInterview_Custom_Integration_WID_Reference($interview_Custom_Integration_WID_Reference)
            ->setWeb_Conference_Meeting_ID_Reference($web_Conference_Meeting_ID_Reference)
            ->setWeb_Conference_URL_Reference($web_Conference_URL_Reference)
            ->setVersion($version);
    }
    /**
     * Get Schedule_Snapshot_WID_Reference value
     * @return string|null
     */
    public function getSchedule_Snapshot_WID_Reference()
    {
        return $this->Schedule_Snapshot_WID_Reference;
    }
    /**
     * Set Schedule_Snapshot_WID_Reference value
     * @param string $schedule_Snapshot_WID_Reference
     * @return \StructType\Put_Web_Conference_Interview_Data_RequestType
     */
    public function setSchedule_Snapshot_WID_Reference($schedule_Snapshot_WID_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($schedule_Snapshot_WID_Reference) && !is_string($schedule_Snapshot_WID_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedule_Snapshot_WID_Reference, true), gettype($schedule_Snapshot_WID_Reference)), __LINE__);
        }
        $this->Schedule_Snapshot_WID_Reference = $schedule_Snapshot_WID_Reference;
        return $this;
    }
    /**
     * Get Interview_Custom_Integration_WID_Reference value
     * @return string|null
     */
    public function getInterview_Custom_Integration_WID_Reference()
    {
        return $this->Interview_Custom_Integration_WID_Reference;
    }
    /**
     * Set Interview_Custom_Integration_WID_Reference value
     * @param string $interview_Custom_Integration_WID_Reference
     * @return \StructType\Put_Web_Conference_Interview_Data_RequestType
     */
    public function setInterview_Custom_Integration_WID_Reference($interview_Custom_Integration_WID_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($interview_Custom_Integration_WID_Reference) && !is_string($interview_Custom_Integration_WID_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interview_Custom_Integration_WID_Reference, true), gettype($interview_Custom_Integration_WID_Reference)), __LINE__);
        }
        $this->Interview_Custom_Integration_WID_Reference = $interview_Custom_Integration_WID_Reference;
        return $this;
    }
    /**
     * Get Web_Conference_Meeting_ID_Reference value
     * @return string|null
     */
    public function getWeb_Conference_Meeting_ID_Reference()
    {
        return $this->Web_Conference_Meeting_ID_Reference;
    }
    /**
     * Set Web_Conference_Meeting_ID_Reference value
     * @param string $web_Conference_Meeting_ID_Reference
     * @return \StructType\Put_Web_Conference_Interview_Data_RequestType
     */
    public function setWeb_Conference_Meeting_ID_Reference($web_Conference_Meeting_ID_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($web_Conference_Meeting_ID_Reference) && !is_string($web_Conference_Meeting_ID_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_Conference_Meeting_ID_Reference, true), gettype($web_Conference_Meeting_ID_Reference)), __LINE__);
        }
        $this->Web_Conference_Meeting_ID_Reference = $web_Conference_Meeting_ID_Reference;
        return $this;
    }
    /**
     * Get Web_Conference_URL_Reference value
     * @return string|null
     */
    public function getWeb_Conference_URL_Reference()
    {
        return $this->Web_Conference_URL_Reference;
    }
    /**
     * Set Web_Conference_URL_Reference value
     * @param string $web_Conference_URL_Reference
     * @return \StructType\Put_Web_Conference_Interview_Data_RequestType
     */
    public function setWeb_Conference_URL_Reference($web_Conference_URL_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($web_Conference_URL_Reference) && !is_string($web_Conference_URL_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_Conference_URL_Reference, true), gettype($web_Conference_URL_Reference)), __LINE__);
        }
        $this->Web_Conference_URL_Reference = $web_Conference_URL_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Web_Conference_Interview_Data_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
