<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Maintain_Candidate_List_Assignment_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Put Maintain Candidate List Assignment Response
 * @subpackage Structs
 */
class Put_Maintain_Candidate_List_Assignment_ResponseType extends AbstractStructBase
{
    /**
     * The Candidate_List_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for the Candidate List Assignment
     * - minOccurs: 0
     * @var \StructType\Candidate_List_Rule_Configuration_SingletonObjectType
     */
    public $Candidate_List_Assignment_Reference;
    /**
     * The Maintain_Candidate_List_Assignment_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the response data for the request
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Maintain_Candidate_List_Assignment_Response_DataType[]
     */
    public $Maintain_Candidate_List_Assignment_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Maintain_Candidate_List_Assignment_ResponseType
     * @uses Put_Maintain_Candidate_List_Assignment_ResponseType::setCandidate_List_Assignment_Reference()
     * @uses Put_Maintain_Candidate_List_Assignment_ResponseType::setMaintain_Candidate_List_Assignment_Data()
     * @uses Put_Maintain_Candidate_List_Assignment_ResponseType::setVersion()
     * @param \StructType\Candidate_List_Rule_Configuration_SingletonObjectType $candidate_List_Assignment_Reference
     * @param \StructType\Maintain_Candidate_List_Assignment_Response_DataType[] $maintain_Candidate_List_Assignment_Data
     * @param string $version
     */
    public function __construct(\StructType\Candidate_List_Rule_Configuration_SingletonObjectType $candidate_List_Assignment_Reference = null, array $maintain_Candidate_List_Assignment_Data = array(), $version = null)
    {
        $this
            ->setCandidate_List_Assignment_Reference($candidate_List_Assignment_Reference)
            ->setMaintain_Candidate_List_Assignment_Data($maintain_Candidate_List_Assignment_Data)
            ->setVersion($version);
    }
    /**
     * Get Candidate_List_Assignment_Reference value
     * @return \StructType\Candidate_List_Rule_Configuration_SingletonObjectType|null
     */
    public function getCandidate_List_Assignment_Reference()
    {
        return $this->Candidate_List_Assignment_Reference;
    }
    /**
     * Set Candidate_List_Assignment_Reference value
     * @param \StructType\Candidate_List_Rule_Configuration_SingletonObjectType $candidate_List_Assignment_Reference
     * @return \StructType\Put_Maintain_Candidate_List_Assignment_ResponseType
     */
    public function setCandidate_List_Assignment_Reference(\StructType\Candidate_List_Rule_Configuration_SingletonObjectType $candidate_List_Assignment_Reference = null)
    {
        $this->Candidate_List_Assignment_Reference = $candidate_List_Assignment_Reference;
        return $this;
    }
    /**
     * Get Maintain_Candidate_List_Assignment_Data value
     * @return \StructType\Maintain_Candidate_List_Assignment_Response_DataType[]|null
     */
    public function getMaintain_Candidate_List_Assignment_Data()
    {
        return $this->Maintain_Candidate_List_Assignment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setMaintain_Candidate_List_Assignment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMaintain_Candidate_List_Assignment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMaintain_Candidate_List_Assignment_DataForArrayConstraintsFromSetMaintain_Candidate_List_Assignment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Maintain_Candidate_List_Assignment_ResponseTypeMaintain_Candidate_List_Assignment_DataItem) {
            // validation for constraint: itemType
            if (!$put_Maintain_Candidate_List_Assignment_ResponseTypeMaintain_Candidate_List_Assignment_DataItem instanceof \StructType\Maintain_Candidate_List_Assignment_Response_DataType) {
                $invalidValues[] = is_object($put_Maintain_Candidate_List_Assignment_ResponseTypeMaintain_Candidate_List_Assignment_DataItem) ? get_class($put_Maintain_Candidate_List_Assignment_ResponseTypeMaintain_Candidate_List_Assignment_DataItem) : sprintf('%s(%s)', gettype($put_Maintain_Candidate_List_Assignment_ResponseTypeMaintain_Candidate_List_Assignment_DataItem), var_export($put_Maintain_Candidate_List_Assignment_ResponseTypeMaintain_Candidate_List_Assignment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Maintain_Candidate_List_Assignment_Data property can only contain items of type \StructType\Maintain_Candidate_List_Assignment_Response_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Maintain_Candidate_List_Assignment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Maintain_Candidate_List_Assignment_Response_DataType[] $maintain_Candidate_List_Assignment_Data
     * @return \StructType\Put_Maintain_Candidate_List_Assignment_ResponseType
     */
    public function setMaintain_Candidate_List_Assignment_Data(array $maintain_Candidate_List_Assignment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($maintain_Candidate_List_Assignment_DataArrayErrorMessage = self::validateMaintain_Candidate_List_Assignment_DataForArrayConstraintsFromSetMaintain_Candidate_List_Assignment_Data($maintain_Candidate_List_Assignment_Data))) {
            throw new \InvalidArgumentException($maintain_Candidate_List_Assignment_DataArrayErrorMessage, __LINE__);
        }
        $this->Maintain_Candidate_List_Assignment_Data = $maintain_Candidate_List_Assignment_Data;
        return $this;
    }
    /**
     * Add item to Maintain_Candidate_List_Assignment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Maintain_Candidate_List_Assignment_Response_DataType $item
     * @return \StructType\Put_Maintain_Candidate_List_Assignment_ResponseType
     */
    public function addToMaintain_Candidate_List_Assignment_Data(\StructType\Maintain_Candidate_List_Assignment_Response_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Maintain_Candidate_List_Assignment_Response_DataType) {
            throw new \InvalidArgumentException(sprintf('The Maintain_Candidate_List_Assignment_Data property can only contain items of type \StructType\Maintain_Candidate_List_Assignment_Response_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Maintain_Candidate_List_Assignment_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Maintain_Candidate_List_Assignment_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
