<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Job_Requisition_Interview_Settings_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the job requisition reference and job requisition interview team data.
 * @subpackage Structs
 */
class Put_Job_Requisition_Interview_Settings_RequestType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Interview_Team_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the job requisition.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Interview_Team_Reference;
    /**
     * The Job_Requisition_Interview_Team_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains job requisition interview team data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Interview_Settings_DataType[]
     */
    public $Job_Requisition_Interview_Team_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Job_Requisition_Interview_Settings_RequestType
     * @uses Put_Job_Requisition_Interview_Settings_RequestType::setJob_Requisition_Interview_Team_Reference()
     * @uses Put_Job_Requisition_Interview_Settings_RequestType::setJob_Requisition_Interview_Team_Data()
     * @uses Put_Job_Requisition_Interview_Settings_RequestType::setVersion()
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Interview_Team_Reference
     * @param \StructType\Job_Requisition_Interview_Settings_DataType[] $job_Requisition_Interview_Team_Data
     * @param string $version
     */
    public function __construct(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Interview_Team_Reference = null, array $job_Requisition_Interview_Team_Data = array(), $version = null)
    {
        $this
            ->setJob_Requisition_Interview_Team_Reference($job_Requisition_Interview_Team_Reference)
            ->setJob_Requisition_Interview_Team_Data($job_Requisition_Interview_Team_Data)
            ->setVersion($version);
    }
    /**
     * Get Job_Requisition_Interview_Team_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Interview_Team_Reference()
    {
        return $this->Job_Requisition_Interview_Team_Reference;
    }
    /**
     * Set Job_Requisition_Interview_Team_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Interview_Team_Reference
     * @return \StructType\Put_Job_Requisition_Interview_Settings_RequestType
     */
    public function setJob_Requisition_Interview_Team_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Interview_Team_Reference = null)
    {
        $this->Job_Requisition_Interview_Team_Reference = $job_Requisition_Interview_Team_Reference;
        return $this;
    }
    /**
     * Get Job_Requisition_Interview_Team_Data value
     * @return \StructType\Job_Requisition_Interview_Settings_DataType[]|null
     */
    public function getJob_Requisition_Interview_Team_Data()
    {
        return $this->Job_Requisition_Interview_Team_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Interview_Team_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Interview_Team_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_Interview_Team_DataForArrayConstraintsFromSetJob_Requisition_Interview_Team_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Job_Requisition_Interview_Settings_RequestTypeJob_Requisition_Interview_Team_DataItem) {
            // validation for constraint: itemType
            if (!$put_Job_Requisition_Interview_Settings_RequestTypeJob_Requisition_Interview_Team_DataItem instanceof \StructType\Job_Requisition_Interview_Settings_DataType) {
                $invalidValues[] = is_object($put_Job_Requisition_Interview_Settings_RequestTypeJob_Requisition_Interview_Team_DataItem) ? get_class($put_Job_Requisition_Interview_Settings_RequestTypeJob_Requisition_Interview_Team_DataItem) : sprintf('%s(%s)', gettype($put_Job_Requisition_Interview_Settings_RequestTypeJob_Requisition_Interview_Team_DataItem), var_export($put_Job_Requisition_Interview_Settings_RequestTypeJob_Requisition_Interview_Team_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Interview_Team_Data property can only contain items of type \StructType\Job_Requisition_Interview_Settings_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Interview_Team_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_Interview_Settings_DataType[] $job_Requisition_Interview_Team_Data
     * @return \StructType\Put_Job_Requisition_Interview_Settings_RequestType
     */
    public function setJob_Requisition_Interview_Team_Data(array $job_Requisition_Interview_Team_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_Interview_Team_DataArrayErrorMessage = self::validateJob_Requisition_Interview_Team_DataForArrayConstraintsFromSetJob_Requisition_Interview_Team_Data($job_Requisition_Interview_Team_Data))) {
            throw new \InvalidArgumentException($job_Requisition_Interview_Team_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Interview_Team_Data = $job_Requisition_Interview_Team_Data;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Interview_Team_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_Interview_Settings_DataType $item
     * @return \StructType\Put_Job_Requisition_Interview_Settings_RequestType
     */
    public function addToJob_Requisition_Interview_Team_Data(\StructType\Job_Requisition_Interview_Settings_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Requisition_Interview_Settings_DataType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Interview_Team_Data property can only contain items of type \StructType\Job_Requisition_Interview_Settings_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Interview_Team_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Job_Requisition_Interview_Settings_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
