<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Background_Check_Package_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing request attributes, Background Check Package reference, and test details.
 * @subpackage Structs
 */
class Put_Background_Check_Package_RequestType extends AbstractStructBase
{
    /**
     * The Background_Check_Package_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of the Background Check Package.
     * - minOccurs: 0
     * @var \StructType\Background_Check_PackageObjectType
     */
    public $Background_Check_Package_Reference;
    /**
     * The Background_Check_Package_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that contains the Background Check Package details.
     * @var \StructType\Background_Check_Package_DataType
     */
    public $Background_Check_Package_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the request is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Background_Check_Package_RequestType
     * @uses Put_Background_Check_Package_RequestType::setBackground_Check_Package_Reference()
     * @uses Put_Background_Check_Package_RequestType::setBackground_Check_Package_Data()
     * @uses Put_Background_Check_Package_RequestType::setAdd_Only()
     * @uses Put_Background_Check_Package_RequestType::setVersion()
     * @param \StructType\Background_Check_PackageObjectType $background_Check_Package_Reference
     * @param \StructType\Background_Check_Package_DataType $background_Check_Package_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Background_Check_PackageObjectType $background_Check_Package_Reference = null, \StructType\Background_Check_Package_DataType $background_Check_Package_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setBackground_Check_Package_Reference($background_Check_Package_Reference)
            ->setBackground_Check_Package_Data($background_Check_Package_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Background_Check_Package_Reference value
     * @return \StructType\Background_Check_PackageObjectType|null
     */
    public function getBackground_Check_Package_Reference()
    {
        return $this->Background_Check_Package_Reference;
    }
    /**
     * Set Background_Check_Package_Reference value
     * @param \StructType\Background_Check_PackageObjectType $background_Check_Package_Reference
     * @return \StructType\Put_Background_Check_Package_RequestType
     */
    public function setBackground_Check_Package_Reference(\StructType\Background_Check_PackageObjectType $background_Check_Package_Reference = null)
    {
        $this->Background_Check_Package_Reference = $background_Check_Package_Reference;
        return $this;
    }
    /**
     * Get Background_Check_Package_Data value
     * @return \StructType\Background_Check_Package_DataType|null
     */
    public function getBackground_Check_Package_Data()
    {
        return $this->Background_Check_Package_Data;
    }
    /**
     * Set Background_Check_Package_Data value
     * @param \StructType\Background_Check_Package_DataType $background_Check_Package_Data
     * @return \StructType\Put_Background_Check_Package_RequestType
     */
    public function setBackground_Check_Package_Data(\StructType\Background_Check_Package_DataType $background_Check_Package_Data = null)
    {
        $this->Background_Check_Package_Data = $background_Check_Package_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Background_Check_Package_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Background_Check_Package_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
