<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pre-Hire_Data_WWSType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Wrapper element for the Applicant Data Web Service.
 * @subpackage Structs
 */
class Pre_Hire_Data_WWSType extends AbstractStructBase
{
    /**
     * The Applicant_ID
     * Meta information extracted from the WSDL
     * - documentation: Applicant ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Applicant_ID;
    /**
     * The Personal_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for Personal Data.
     * - minOccurs: 0
     * @var \StructType\Personal_Information_DataType
     */
    public $Personal_Data;
    /**
     * The Qualification_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for the Qualification Data.
     * - minOccurs: 0
     * @var \StructType\Person_Qualification_DataType
     */
    public $Qualification_Data;
    /**
     * The Recruiting_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for Recruiting Data.Security Note: This element is secured to the following domains : Manage Recruiting: Consider Applicants
     * - minOccurs: 0
     * @var \StructType\Recruiting_DataType
     */
    public $Recruiting_Data;
    /**
     * The Resume_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the applicant's resume(s).
     * - minOccurs: 0
     * @var \StructType\Pre_Hire_Resume_DataType
     */
    public $Resume_Data;
    /**
     * The Background_Check_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains Background Check Information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Background_Check_Overall_Status_DataType[]
     */
    public $Background_Check_Data;
    /**
     * The External_Integration_ID_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\External_Integration_ID_DataType
     */
    public $External_Integration_ID_Data;
    /**
     * The Document_Field_Result_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_Field_Result_DataType[]
     */
    public $Document_Field_Result_Data;
    /**
     * Constructor method for Pre-Hire_Data_WWSType
     * @uses Pre_Hire_Data_WWSType::setApplicant_ID()
     * @uses Pre_Hire_Data_WWSType::setPersonal_Data()
     * @uses Pre_Hire_Data_WWSType::setQualification_Data()
     * @uses Pre_Hire_Data_WWSType::setRecruiting_Data()
     * @uses Pre_Hire_Data_WWSType::setResume_Data()
     * @uses Pre_Hire_Data_WWSType::setBackground_Check_Data()
     * @uses Pre_Hire_Data_WWSType::setExternal_Integration_ID_Data()
     * @uses Pre_Hire_Data_WWSType::setDocument_Field_Result_Data()
     * @param string $applicant_ID
     * @param \StructType\Personal_Information_DataType $personal_Data
     * @param \StructType\Person_Qualification_DataType $qualification_Data
     * @param \StructType\Recruiting_DataType $recruiting_Data
     * @param \StructType\Pre_Hire_Resume_DataType $resume_Data
     * @param \StructType\Background_Check_Overall_Status_DataType[] $background_Check_Data
     * @param \StructType\External_Integration_ID_DataType $external_Integration_ID_Data
     * @param \StructType\Document_Field_Result_DataType[] $document_Field_Result_Data
     */
    public function __construct($applicant_ID = null, \StructType\Personal_Information_DataType $personal_Data = null, \StructType\Person_Qualification_DataType $qualification_Data = null, \StructType\Recruiting_DataType $recruiting_Data = null, \StructType\Pre_Hire_Resume_DataType $resume_Data = null, array $background_Check_Data = array(), \StructType\External_Integration_ID_DataType $external_Integration_ID_Data = null, array $document_Field_Result_Data = array())
    {
        $this
            ->setApplicant_ID($applicant_ID)
            ->setPersonal_Data($personal_Data)
            ->setQualification_Data($qualification_Data)
            ->setRecruiting_Data($recruiting_Data)
            ->setResume_Data($resume_Data)
            ->setBackground_Check_Data($background_Check_Data)
            ->setExternal_Integration_ID_Data($external_Integration_ID_Data)
            ->setDocument_Field_Result_Data($document_Field_Result_Data);
    }
    /**
     * Get Applicant_ID value
     * @return string|null
     */
    public function getApplicant_ID()
    {
        return $this->Applicant_ID;
    }
    /**
     * Set Applicant_ID value
     * @param string $applicant_ID
     * @return \StructType\Pre_Hire_Data_WWSType
     */
    public function setApplicant_ID($applicant_ID = null)
    {
        // validation for constraint: string
        if (!is_null($applicant_ID) && !is_string($applicant_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicant_ID, true), gettype($applicant_ID)), __LINE__);
        }
        $this->Applicant_ID = $applicant_ID;
        return $this;
    }
    /**
     * Get Personal_Data value
     * @return \StructType\Personal_Information_DataType|null
     */
    public function getPersonal_Data()
    {
        return $this->Personal_Data;
    }
    /**
     * Set Personal_Data value
     * @param \StructType\Personal_Information_DataType $personal_Data
     * @return \StructType\Pre_Hire_Data_WWSType
     */
    public function setPersonal_Data(\StructType\Personal_Information_DataType $personal_Data = null)
    {
        $this->Personal_Data = $personal_Data;
        return $this;
    }
    /**
     * Get Qualification_Data value
     * @return \StructType\Person_Qualification_DataType|null
     */
    public function getQualification_Data()
    {
        return $this->Qualification_Data;
    }
    /**
     * Set Qualification_Data value
     * @param \StructType\Person_Qualification_DataType $qualification_Data
     * @return \StructType\Pre_Hire_Data_WWSType
     */
    public function setQualification_Data(\StructType\Person_Qualification_DataType $qualification_Data = null)
    {
        $this->Qualification_Data = $qualification_Data;
        return $this;
    }
    /**
     * Get Recruiting_Data value
     * @return \StructType\Recruiting_DataType|null
     */
    public function getRecruiting_Data()
    {
        return $this->Recruiting_Data;
    }
    /**
     * Set Recruiting_Data value
     * @param \StructType\Recruiting_DataType $recruiting_Data
     * @return \StructType\Pre_Hire_Data_WWSType
     */
    public function setRecruiting_Data(\StructType\Recruiting_DataType $recruiting_Data = null)
    {
        $this->Recruiting_Data = $recruiting_Data;
        return $this;
    }
    /**
     * Get Resume_Data value
     * @return \StructType\Pre_Hire_Resume_DataType|null
     */
    public function getResume_Data()
    {
        return $this->Resume_Data;
    }
    /**
     * Set Resume_Data value
     * @param \StructType\Pre_Hire_Resume_DataType $resume_Data
     * @return \StructType\Pre_Hire_Data_WWSType
     */
    public function setResume_Data(\StructType\Pre_Hire_Resume_DataType $resume_Data = null)
    {
        $this->Resume_Data = $resume_Data;
        return $this;
    }
    /**
     * Get Background_Check_Data value
     * @return \StructType\Background_Check_Overall_Status_DataType[]|null
     */
    public function getBackground_Check_Data()
    {
        return $this->Background_Check_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBackground_Check_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBackground_Check_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBackground_Check_DataForArrayConstraintsFromSetBackground_Check_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pre_Hire_Data_WWSTypeBackground_Check_DataItem) {
            // validation for constraint: itemType
            if (!$pre_Hire_Data_WWSTypeBackground_Check_DataItem instanceof \StructType\Background_Check_Overall_Status_DataType) {
                $invalidValues[] = is_object($pre_Hire_Data_WWSTypeBackground_Check_DataItem) ? get_class($pre_Hire_Data_WWSTypeBackground_Check_DataItem) : sprintf('%s(%s)', gettype($pre_Hire_Data_WWSTypeBackground_Check_DataItem), var_export($pre_Hire_Data_WWSTypeBackground_Check_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Background_Check_Data property can only contain items of type \StructType\Background_Check_Overall_Status_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Background_Check_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Background_Check_Overall_Status_DataType[] $background_Check_Data
     * @return \StructType\Pre_Hire_Data_WWSType
     */
    public function setBackground_Check_Data(array $background_Check_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($background_Check_DataArrayErrorMessage = self::validateBackground_Check_DataForArrayConstraintsFromSetBackground_Check_Data($background_Check_Data))) {
            throw new \InvalidArgumentException($background_Check_DataArrayErrorMessage, __LINE__);
        }
        $this->Background_Check_Data = $background_Check_Data;
        return $this;
    }
    /**
     * Add item to Background_Check_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Background_Check_Overall_Status_DataType $item
     * @return \StructType\Pre_Hire_Data_WWSType
     */
    public function addToBackground_Check_Data(\StructType\Background_Check_Overall_Status_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Background_Check_Overall_Status_DataType) {
            throw new \InvalidArgumentException(sprintf('The Background_Check_Data property can only contain items of type \StructType\Background_Check_Overall_Status_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Background_Check_Data[] = $item;
        return $this;
    }
    /**
     * Get External_Integration_ID_Data value
     * @return \StructType\External_Integration_ID_DataType|null
     */
    public function getExternal_Integration_ID_Data()
    {
        return $this->External_Integration_ID_Data;
    }
    /**
     * Set External_Integration_ID_Data value
     * @param \StructType\External_Integration_ID_DataType $external_Integration_ID_Data
     * @return \StructType\Pre_Hire_Data_WWSType
     */
    public function setExternal_Integration_ID_Data(\StructType\External_Integration_ID_DataType $external_Integration_ID_Data = null)
    {
        $this->External_Integration_ID_Data = $external_Integration_ID_Data;
        return $this;
    }
    /**
     * Get Document_Field_Result_Data value
     * @return \StructType\Document_Field_Result_DataType[]|null
     */
    public function getDocument_Field_Result_Data()
    {
        return $this->Document_Field_Result_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument_Field_Result_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument_Field_Result_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocument_Field_Result_DataForArrayConstraintsFromSetDocument_Field_Result_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pre_Hire_Data_WWSTypeDocument_Field_Result_DataItem) {
            // validation for constraint: itemType
            if (!$pre_Hire_Data_WWSTypeDocument_Field_Result_DataItem instanceof \StructType\Document_Field_Result_DataType) {
                $invalidValues[] = is_object($pre_Hire_Data_WWSTypeDocument_Field_Result_DataItem) ? get_class($pre_Hire_Data_WWSTypeDocument_Field_Result_DataItem) : sprintf('%s(%s)', gettype($pre_Hire_Data_WWSTypeDocument_Field_Result_DataItem), var_export($pre_Hire_Data_WWSTypeDocument_Field_Result_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document_Field_Result_Data property can only contain items of type \StructType\Document_Field_Result_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document_Field_Result_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Field_Result_DataType[] $document_Field_Result_Data
     * @return \StructType\Pre_Hire_Data_WWSType
     */
    public function setDocument_Field_Result_Data(array $document_Field_Result_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($document_Field_Result_DataArrayErrorMessage = self::validateDocument_Field_Result_DataForArrayConstraintsFromSetDocument_Field_Result_Data($document_Field_Result_Data))) {
            throw new \InvalidArgumentException($document_Field_Result_DataArrayErrorMessage, __LINE__);
        }
        $this->Document_Field_Result_Data = $document_Field_Result_Data;
        return $this;
    }
    /**
     * Add item to Document_Field_Result_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Field_Result_DataType $item
     * @return \StructType\Pre_Hire_Data_WWSType
     */
    public function addToDocument_Field_Result_Data(\StructType\Document_Field_Result_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_Field_Result_DataType) {
            throw new \InvalidArgumentException(sprintf('The Document_Field_Result_Data property can only contain items of type \StructType\Document_Field_Result_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document_Field_Result_Data[] = $item;
        return $this;
    }
}
