<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: The response group allows for the response data to be tailored to only included elements that the user is looking for. If no response group is provided in the request the only the following elements will be returned: Reference and
 * Position Definition Data
 * @subpackage Structs
 */
class Position_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Reference for the Position is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Position_Definition_Data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the details of the Position is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Position_Definition_Data;
    /**
     * The Include_Position_Restrictions_Data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Hiring Restrictions is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Position_Restrictions_Data;
    /**
     * The Include_Position_Restriction_Working_Hours_Details_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, the response includes Position Restriction Working Hours Details Data.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Position_Restriction_Working_Hours_Details_Data;
    /**
     * The Include_Default_Compensation_Data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Default Compensation is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Default_Compensation_Data;
    /**
     * The Include_Default_Position_Organization_Assignment_Data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Default Position Organization Assignment Data is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Default_Position_Organization_Assignment_Data;
    /**
     * The Include_Worker_For_Filled_Positions_Data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Worker for Filled Positions is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Worker_For_Filled_Positions_Data;
    /**
     * The Include_Qualifications
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Position's Qualifications (Competencies, Education, Responsibilities, etc.) are included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Qualifications;
    /**
     * The Include_Job_Requisition_Data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Position's Open Job Requisition (if there is one) is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Job_Requisition_Data;
    /**
     * The Include_Job_Requisition_Attachments
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Position's Open Job Requisition Attachments (if they exist) are included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Job_Requisition_Attachments;
    /**
     * Constructor method for Position_Response_GroupType
     * @uses Position_Response_GroupType::setInclude_Reference()
     * @uses Position_Response_GroupType::setInclude_Position_Definition_Data()
     * @uses Position_Response_GroupType::setInclude_Position_Restrictions_Data()
     * @uses Position_Response_GroupType::setInclude_Position_Restriction_Working_Hours_Details_Data()
     * @uses Position_Response_GroupType::setInclude_Default_Compensation_Data()
     * @uses Position_Response_GroupType::setInclude_Default_Position_Organization_Assignment_Data()
     * @uses Position_Response_GroupType::setInclude_Worker_For_Filled_Positions_Data()
     * @uses Position_Response_GroupType::setInclude_Qualifications()
     * @uses Position_Response_GroupType::setInclude_Job_Requisition_Data()
     * @uses Position_Response_GroupType::setInclude_Job_Requisition_Attachments()
     * @param bool $include_Reference
     * @param bool $include_Position_Definition_Data
     * @param bool $include_Position_Restrictions_Data
     * @param bool $include_Position_Restriction_Working_Hours_Details_Data
     * @param bool $include_Default_Compensation_Data
     * @param bool $include_Default_Position_Organization_Assignment_Data
     * @param bool $include_Worker_For_Filled_Positions_Data
     * @param bool $include_Qualifications
     * @param bool $include_Job_Requisition_Data
     * @param bool $include_Job_Requisition_Attachments
     */
    public function __construct($include_Reference = null, $include_Position_Definition_Data = null, $include_Position_Restrictions_Data = null, $include_Position_Restriction_Working_Hours_Details_Data = null, $include_Default_Compensation_Data = null, $include_Default_Position_Organization_Assignment_Data = null, $include_Worker_For_Filled_Positions_Data = null, $include_Qualifications = null, $include_Job_Requisition_Data = null, $include_Job_Requisition_Attachments = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Position_Definition_Data($include_Position_Definition_Data)
            ->setInclude_Position_Restrictions_Data($include_Position_Restrictions_Data)
            ->setInclude_Position_Restriction_Working_Hours_Details_Data($include_Position_Restriction_Working_Hours_Details_Data)
            ->setInclude_Default_Compensation_Data($include_Default_Compensation_Data)
            ->setInclude_Default_Position_Organization_Assignment_Data($include_Default_Position_Organization_Assignment_Data)
            ->setInclude_Worker_For_Filled_Positions_Data($include_Worker_For_Filled_Positions_Data)
            ->setInclude_Qualifications($include_Qualifications)
            ->setInclude_Job_Requisition_Data($include_Job_Requisition_Data)
            ->setInclude_Job_Requisition_Attachments($include_Job_Requisition_Attachments);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Position_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Position_Definition_Data value
     * @return bool|null
     */
    public function getInclude_Position_Definition_Data()
    {
        return $this->Include_Position_Definition_Data;
    }
    /**
     * Set Include_Position_Definition_Data value
     * @param bool $include_Position_Definition_Data
     * @return \StructType\Position_Response_GroupType
     */
    public function setInclude_Position_Definition_Data($include_Position_Definition_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Position_Definition_Data) && !is_bool($include_Position_Definition_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Position_Definition_Data, true), gettype($include_Position_Definition_Data)), __LINE__);
        }
        $this->Include_Position_Definition_Data = $include_Position_Definition_Data;
        return $this;
    }
    /**
     * Get Include_Position_Restrictions_Data value
     * @return bool|null
     */
    public function getInclude_Position_Restrictions_Data()
    {
        return $this->Include_Position_Restrictions_Data;
    }
    /**
     * Set Include_Position_Restrictions_Data value
     * @param bool $include_Position_Restrictions_Data
     * @return \StructType\Position_Response_GroupType
     */
    public function setInclude_Position_Restrictions_Data($include_Position_Restrictions_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Position_Restrictions_Data) && !is_bool($include_Position_Restrictions_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Position_Restrictions_Data, true), gettype($include_Position_Restrictions_Data)), __LINE__);
        }
        $this->Include_Position_Restrictions_Data = $include_Position_Restrictions_Data;
        return $this;
    }
    /**
     * Get Include_Position_Restriction_Working_Hours_Details_Data value
     * @return bool|null
     */
    public function getInclude_Position_Restriction_Working_Hours_Details_Data()
    {
        return $this->Include_Position_Restriction_Working_Hours_Details_Data;
    }
    /**
     * Set Include_Position_Restriction_Working_Hours_Details_Data value
     * @param bool $include_Position_Restriction_Working_Hours_Details_Data
     * @return \StructType\Position_Response_GroupType
     */
    public function setInclude_Position_Restriction_Working_Hours_Details_Data($include_Position_Restriction_Working_Hours_Details_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Position_Restriction_Working_Hours_Details_Data) && !is_bool($include_Position_Restriction_Working_Hours_Details_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Position_Restriction_Working_Hours_Details_Data, true), gettype($include_Position_Restriction_Working_Hours_Details_Data)), __LINE__);
        }
        $this->Include_Position_Restriction_Working_Hours_Details_Data = $include_Position_Restriction_Working_Hours_Details_Data;
        return $this;
    }
    /**
     * Get Include_Default_Compensation_Data value
     * @return bool|null
     */
    public function getInclude_Default_Compensation_Data()
    {
        return $this->Include_Default_Compensation_Data;
    }
    /**
     * Set Include_Default_Compensation_Data value
     * @param bool $include_Default_Compensation_Data
     * @return \StructType\Position_Response_GroupType
     */
    public function setInclude_Default_Compensation_Data($include_Default_Compensation_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Default_Compensation_Data) && !is_bool($include_Default_Compensation_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Default_Compensation_Data, true), gettype($include_Default_Compensation_Data)), __LINE__);
        }
        $this->Include_Default_Compensation_Data = $include_Default_Compensation_Data;
        return $this;
    }
    /**
     * Get Include_Default_Position_Organization_Assignment_Data value
     * @return bool|null
     */
    public function getInclude_Default_Position_Organization_Assignment_Data()
    {
        return $this->Include_Default_Position_Organization_Assignment_Data;
    }
    /**
     * Set Include_Default_Position_Organization_Assignment_Data value
     * @param bool $include_Default_Position_Organization_Assignment_Data
     * @return \StructType\Position_Response_GroupType
     */
    public function setInclude_Default_Position_Organization_Assignment_Data($include_Default_Position_Organization_Assignment_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Default_Position_Organization_Assignment_Data) && !is_bool($include_Default_Position_Organization_Assignment_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Default_Position_Organization_Assignment_Data, true), gettype($include_Default_Position_Organization_Assignment_Data)), __LINE__);
        }
        $this->Include_Default_Position_Organization_Assignment_Data = $include_Default_Position_Organization_Assignment_Data;
        return $this;
    }
    /**
     * Get Include_Worker_For_Filled_Positions_Data value
     * @return bool|null
     */
    public function getInclude_Worker_For_Filled_Positions_Data()
    {
        return $this->Include_Worker_For_Filled_Positions_Data;
    }
    /**
     * Set Include_Worker_For_Filled_Positions_Data value
     * @param bool $include_Worker_For_Filled_Positions_Data
     * @return \StructType\Position_Response_GroupType
     */
    public function setInclude_Worker_For_Filled_Positions_Data($include_Worker_For_Filled_Positions_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Worker_For_Filled_Positions_Data) && !is_bool($include_Worker_For_Filled_Positions_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Worker_For_Filled_Positions_Data, true), gettype($include_Worker_For_Filled_Positions_Data)), __LINE__);
        }
        $this->Include_Worker_For_Filled_Positions_Data = $include_Worker_For_Filled_Positions_Data;
        return $this;
    }
    /**
     * Get Include_Qualifications value
     * @return bool|null
     */
    public function getInclude_Qualifications()
    {
        return $this->Include_Qualifications;
    }
    /**
     * Set Include_Qualifications value
     * @param bool $include_Qualifications
     * @return \StructType\Position_Response_GroupType
     */
    public function setInclude_Qualifications($include_Qualifications = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Qualifications) && !is_bool($include_Qualifications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Qualifications, true), gettype($include_Qualifications)), __LINE__);
        }
        $this->Include_Qualifications = $include_Qualifications;
        return $this;
    }
    /**
     * Get Include_Job_Requisition_Data value
     * @return bool|null
     */
    public function getInclude_Job_Requisition_Data()
    {
        return $this->Include_Job_Requisition_Data;
    }
    /**
     * Set Include_Job_Requisition_Data value
     * @param bool $include_Job_Requisition_Data
     * @return \StructType\Position_Response_GroupType
     */
    public function setInclude_Job_Requisition_Data($include_Job_Requisition_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Job_Requisition_Data) && !is_bool($include_Job_Requisition_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Job_Requisition_Data, true), gettype($include_Job_Requisition_Data)), __LINE__);
        }
        $this->Include_Job_Requisition_Data = $include_Job_Requisition_Data;
        return $this;
    }
    /**
     * Get Include_Job_Requisition_Attachments value
     * @return bool|null
     */
    public function getInclude_Job_Requisition_Attachments()
    {
        return $this->Include_Job_Requisition_Attachments;
    }
    /**
     * Set Include_Job_Requisition_Attachments value
     * @param bool $include_Job_Requisition_Attachments
     * @return \StructType\Position_Response_GroupType
     */
    public function setInclude_Job_Requisition_Attachments($include_Job_Requisition_Attachments = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Job_Requisition_Attachments) && !is_bool($include_Job_Requisition_Attachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Job_Requisition_Attachments, true), gettype($include_Job_Requisition_Attachments)), __LINE__);
        }
        $this->Include_Job_Requisition_Attachments = $include_Job_Requisition_Attachments;
        return $this;
    }
}
