<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for general data pertaining to a position opening.
 * @subpackage Structs
 */
class Position_Details_DataType extends AbstractStructBase
{
    /**
     * The Position_ID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier for the Position
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Position_ID;
    /**
     * The Job_Posting_Title
     * Meta information extracted from the WSDL
     * - documentation: Job Posting Title for the Position.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_Title;
    /**
     * The Academic_Tenure_Eligible
     * Meta information extracted from the WSDL
     * - documentation: Value that represents if the position is eligible for academic tenure.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Academic_Tenure_Eligible;
    /**
     * The Job_Description_Summary
     * Meta information extracted from the WSDL
     * - documentation: Job Description Summary (plain text) for the Position.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Description_Summary;
    /**
     * The Job_Description
     * Meta information extracted from the WSDL
     * - documentation: Job Description (rich text) for the Position.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Description;
    /**
     * The Position_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The status history for the position. Doesn't respect the As of Effective Date filter. To filter by effective date, use the Get Worker Event History web service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Worker_EventObjectType[]
     */
    public $Position_Status_Reference;
    /**
     * The Available_For_Hire
     * Meta information extracted from the WSDL
     * - documentation: Returns a true if this is able to be filled by a worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Available_For_Hire;
    /**
     * The Available_for_Recruiting
     * Meta information extracted from the WSDL
     * - documentation: Returns true if this is available for recruiting. If Enable Job Requisitons is turned off in the tenant, this is the same as Available for Hire.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Available_for_Recruiting;
    /**
     * The Hiring_Freeze
     * Meta information extracted from the WSDL
     * - documentation: Boolean attribute identifying whether a Hiring Freeze is currently in affect.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Hiring_Freeze;
    /**
     * The Work_Shift_Required
     * Meta information extracted from the WSDL
     * - documentation: Returns true if the position is restricted to only one job profile and that job profile requires a work shift.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Work_Shift_Required;
    /**
     * The Available_for_Overlap
     * Meta information extracted from the WSDL
     * - documentation: Returns true if the Position Restriction is available to be overlapped.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Available_for_Overlap;
    /**
     * The Earliest_Overlap_Date
     * Meta information extracted from the WSDL
     * - documentation: Returns the earliest date this Position Restriction can be filled with an overlapping worker. This will only have a value if the position restriction is available to be overlapped.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Earliest_Overlap_Date;
    /**
     * The Critical_Job
     * Meta information extracted from the WSDL
     * - documentation: Boolean attribute which is set to yes if the Position Restriction is considered a critical job.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Critical_Job;
    /**
     * The Difficulty_to_Fill_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Difficulty to Fill for this Position Restriction.
     * - minOccurs: 0
     * @var \StructType\Difficulty_to_FillObjectType
     */
    public $Difficulty_to_Fill_Reference;
    /**
     * Constructor method for Position_Details_DataType
     * @uses Position_Details_DataType::setPosition_ID()
     * @uses Position_Details_DataType::setJob_Posting_Title()
     * @uses Position_Details_DataType::setAcademic_Tenure_Eligible()
     * @uses Position_Details_DataType::setJob_Description_Summary()
     * @uses Position_Details_DataType::setJob_Description()
     * @uses Position_Details_DataType::setPosition_Status_Reference()
     * @uses Position_Details_DataType::setAvailable_For_Hire()
     * @uses Position_Details_DataType::setAvailable_for_Recruiting()
     * @uses Position_Details_DataType::setHiring_Freeze()
     * @uses Position_Details_DataType::setWork_Shift_Required()
     * @uses Position_Details_DataType::setAvailable_for_Overlap()
     * @uses Position_Details_DataType::setEarliest_Overlap_Date()
     * @uses Position_Details_DataType::setCritical_Job()
     * @uses Position_Details_DataType::setDifficulty_to_Fill_Reference()
     * @param string $position_ID
     * @param string $job_Posting_Title
     * @param bool $academic_Tenure_Eligible
     * @param string $job_Description_Summary
     * @param string $job_Description
     * @param \StructType\Worker_EventObjectType[] $position_Status_Reference
     * @param bool $available_For_Hire
     * @param bool $available_for_Recruiting
     * @param bool $hiring_Freeze
     * @param bool $work_Shift_Required
     * @param bool $available_for_Overlap
     * @param string $earliest_Overlap_Date
     * @param bool $critical_Job
     * @param \StructType\Difficulty_to_FillObjectType $difficulty_to_Fill_Reference
     */
    public function __construct($position_ID = null, $job_Posting_Title = null, $academic_Tenure_Eligible = null, $job_Description_Summary = null, $job_Description = null, array $position_Status_Reference = array(), $available_For_Hire = null, $available_for_Recruiting = null, $hiring_Freeze = null, $work_Shift_Required = null, $available_for_Overlap = null, $earliest_Overlap_Date = null, $critical_Job = null, \StructType\Difficulty_to_FillObjectType $difficulty_to_Fill_Reference = null)
    {
        $this
            ->setPosition_ID($position_ID)
            ->setJob_Posting_Title($job_Posting_Title)
            ->setAcademic_Tenure_Eligible($academic_Tenure_Eligible)
            ->setJob_Description_Summary($job_Description_Summary)
            ->setJob_Description($job_Description)
            ->setPosition_Status_Reference($position_Status_Reference)
            ->setAvailable_For_Hire($available_For_Hire)
            ->setAvailable_for_Recruiting($available_for_Recruiting)
            ->setHiring_Freeze($hiring_Freeze)
            ->setWork_Shift_Required($work_Shift_Required)
            ->setAvailable_for_Overlap($available_for_Overlap)
            ->setEarliest_Overlap_Date($earliest_Overlap_Date)
            ->setCritical_Job($critical_Job)
            ->setDifficulty_to_Fill_Reference($difficulty_to_Fill_Reference);
    }
    /**
     * Get Position_ID value
     * @return string|null
     */
    public function getPosition_ID()
    {
        return $this->Position_ID;
    }
    /**
     * Set Position_ID value
     * @param string $position_ID
     * @return \StructType\Position_Details_DataType
     */
    public function setPosition_ID($position_ID = null)
    {
        // validation for constraint: string
        if (!is_null($position_ID) && !is_string($position_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($position_ID, true), gettype($position_ID)), __LINE__);
        }
        $this->Position_ID = $position_ID;
        return $this;
    }
    /**
     * Get Job_Posting_Title value
     * @return string|null
     */
    public function getJob_Posting_Title()
    {
        return $this->Job_Posting_Title;
    }
    /**
     * Set Job_Posting_Title value
     * @param string $job_Posting_Title
     * @return \StructType\Position_Details_DataType
     */
    public function setJob_Posting_Title($job_Posting_Title = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Title) && !is_string($job_Posting_Title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Title, true), gettype($job_Posting_Title)), __LINE__);
        }
        $this->Job_Posting_Title = $job_Posting_Title;
        return $this;
    }
    /**
     * Get Academic_Tenure_Eligible value
     * @return bool|null
     */
    public function getAcademic_Tenure_Eligible()
    {
        return $this->Academic_Tenure_Eligible;
    }
    /**
     * Set Academic_Tenure_Eligible value
     * @param bool $academic_Tenure_Eligible
     * @return \StructType\Position_Details_DataType
     */
    public function setAcademic_Tenure_Eligible($academic_Tenure_Eligible = null)
    {
        // validation for constraint: boolean
        if (!is_null($academic_Tenure_Eligible) && !is_bool($academic_Tenure_Eligible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($academic_Tenure_Eligible, true), gettype($academic_Tenure_Eligible)), __LINE__);
        }
        $this->Academic_Tenure_Eligible = $academic_Tenure_Eligible;
        return $this;
    }
    /**
     * Get Job_Description_Summary value
     * @return string|null
     */
    public function getJob_Description_Summary()
    {
        return $this->Job_Description_Summary;
    }
    /**
     * Set Job_Description_Summary value
     * @param string $job_Description_Summary
     * @return \StructType\Position_Details_DataType
     */
    public function setJob_Description_Summary($job_Description_Summary = null)
    {
        // validation for constraint: string
        if (!is_null($job_Description_Summary) && !is_string($job_Description_Summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Description_Summary, true), gettype($job_Description_Summary)), __LINE__);
        }
        $this->Job_Description_Summary = $job_Description_Summary;
        return $this;
    }
    /**
     * Get Job_Description value
     * @return string|null
     */
    public function getJob_Description()
    {
        return $this->Job_Description;
    }
    /**
     * Set Job_Description value
     * @param string $job_Description
     * @return \StructType\Position_Details_DataType
     */
    public function setJob_Description($job_Description = null)
    {
        // validation for constraint: string
        if (!is_null($job_Description) && !is_string($job_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Description, true), gettype($job_Description)), __LINE__);
        }
        $this->Job_Description = $job_Description;
        return $this;
    }
    /**
     * Get Position_Status_Reference value
     * @return \StructType\Worker_EventObjectType[]|null
     */
    public function getPosition_Status_Reference()
    {
        return $this->Position_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePosition_Status_ReferenceForArrayConstraintsFromSetPosition_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $position_Details_DataTypePosition_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$position_Details_DataTypePosition_Status_ReferenceItem instanceof \StructType\Worker_EventObjectType) {
                $invalidValues[] = is_object($position_Details_DataTypePosition_Status_ReferenceItem) ? get_class($position_Details_DataTypePosition_Status_ReferenceItem) : sprintf('%s(%s)', gettype($position_Details_DataTypePosition_Status_ReferenceItem), var_export($position_Details_DataTypePosition_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Position_Status_Reference property can only contain items of type \StructType\Worker_EventObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Position_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_EventObjectType[] $position_Status_Reference
     * @return \StructType\Position_Details_DataType
     */
    public function setPosition_Status_Reference(array $position_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($position_Status_ReferenceArrayErrorMessage = self::validatePosition_Status_ReferenceForArrayConstraintsFromSetPosition_Status_Reference($position_Status_Reference))) {
            throw new \InvalidArgumentException($position_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Position_Status_Reference = $position_Status_Reference;
        return $this;
    }
    /**
     * Add item to Position_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_EventObjectType $item
     * @return \StructType\Position_Details_DataType
     */
    public function addToPosition_Status_Reference(\StructType\Worker_EventObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Worker_EventObjectType) {
            throw new \InvalidArgumentException(sprintf('The Position_Status_Reference property can only contain items of type \StructType\Worker_EventObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Position_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Available_For_Hire value
     * @return bool|null
     */
    public function getAvailable_For_Hire()
    {
        return $this->Available_For_Hire;
    }
    /**
     * Set Available_For_Hire value
     * @param bool $available_For_Hire
     * @return \StructType\Position_Details_DataType
     */
    public function setAvailable_For_Hire($available_For_Hire = null)
    {
        // validation for constraint: boolean
        if (!is_null($available_For_Hire) && !is_bool($available_For_Hire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($available_For_Hire, true), gettype($available_For_Hire)), __LINE__);
        }
        $this->Available_For_Hire = $available_For_Hire;
        return $this;
    }
    /**
     * Get Available_for_Recruiting value
     * @return bool|null
     */
    public function getAvailable_for_Recruiting()
    {
        return $this->Available_for_Recruiting;
    }
    /**
     * Set Available_for_Recruiting value
     * @param bool $available_for_Recruiting
     * @return \StructType\Position_Details_DataType
     */
    public function setAvailable_for_Recruiting($available_for_Recruiting = null)
    {
        // validation for constraint: boolean
        if (!is_null($available_for_Recruiting) && !is_bool($available_for_Recruiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($available_for_Recruiting, true), gettype($available_for_Recruiting)), __LINE__);
        }
        $this->Available_for_Recruiting = $available_for_Recruiting;
        return $this;
    }
    /**
     * Get Hiring_Freeze value
     * @return bool|null
     */
    public function getHiring_Freeze()
    {
        return $this->Hiring_Freeze;
    }
    /**
     * Set Hiring_Freeze value
     * @param bool $hiring_Freeze
     * @return \StructType\Position_Details_DataType
     */
    public function setHiring_Freeze($hiring_Freeze = null)
    {
        // validation for constraint: boolean
        if (!is_null($hiring_Freeze) && !is_bool($hiring_Freeze)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hiring_Freeze, true), gettype($hiring_Freeze)), __LINE__);
        }
        $this->Hiring_Freeze = $hiring_Freeze;
        return $this;
    }
    /**
     * Get Work_Shift_Required value
     * @return bool|null
     */
    public function getWork_Shift_Required()
    {
        return $this->Work_Shift_Required;
    }
    /**
     * Set Work_Shift_Required value
     * @param bool $work_Shift_Required
     * @return \StructType\Position_Details_DataType
     */
    public function setWork_Shift_Required($work_Shift_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($work_Shift_Required) && !is_bool($work_Shift_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($work_Shift_Required, true), gettype($work_Shift_Required)), __LINE__);
        }
        $this->Work_Shift_Required = $work_Shift_Required;
        return $this;
    }
    /**
     * Get Available_for_Overlap value
     * @return bool|null
     */
    public function getAvailable_for_Overlap()
    {
        return $this->Available_for_Overlap;
    }
    /**
     * Set Available_for_Overlap value
     * @param bool $available_for_Overlap
     * @return \StructType\Position_Details_DataType
     */
    public function setAvailable_for_Overlap($available_for_Overlap = null)
    {
        // validation for constraint: boolean
        if (!is_null($available_for_Overlap) && !is_bool($available_for_Overlap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($available_for_Overlap, true), gettype($available_for_Overlap)), __LINE__);
        }
        $this->Available_for_Overlap = $available_for_Overlap;
        return $this;
    }
    /**
     * Get Earliest_Overlap_Date value
     * @return string|null
     */
    public function getEarliest_Overlap_Date()
    {
        return $this->Earliest_Overlap_Date;
    }
    /**
     * Set Earliest_Overlap_Date value
     * @param string $earliest_Overlap_Date
     * @return \StructType\Position_Details_DataType
     */
    public function setEarliest_Overlap_Date($earliest_Overlap_Date = null)
    {
        // validation for constraint: string
        if (!is_null($earliest_Overlap_Date) && !is_string($earliest_Overlap_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliest_Overlap_Date, true), gettype($earliest_Overlap_Date)), __LINE__);
        }
        $this->Earliest_Overlap_Date = $earliest_Overlap_Date;
        return $this;
    }
    /**
     * Get Critical_Job value
     * @return bool|null
     */
    public function getCritical_Job()
    {
        return $this->Critical_Job;
    }
    /**
     * Set Critical_Job value
     * @param bool $critical_Job
     * @return \StructType\Position_Details_DataType
     */
    public function setCritical_Job($critical_Job = null)
    {
        // validation for constraint: boolean
        if (!is_null($critical_Job) && !is_bool($critical_Job)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($critical_Job, true), gettype($critical_Job)), __LINE__);
        }
        $this->Critical_Job = $critical_Job;
        return $this;
    }
    /**
     * Get Difficulty_to_Fill_Reference value
     * @return \StructType\Difficulty_to_FillObjectType|null
     */
    public function getDifficulty_to_Fill_Reference()
    {
        return $this->Difficulty_to_Fill_Reference;
    }
    /**
     * Set Difficulty_to_Fill_Reference value
     * @param \StructType\Difficulty_to_FillObjectType $difficulty_to_Fill_Reference
     * @return \StructType\Position_Details_DataType
     */
    public function setDifficulty_to_Fill_Reference(\StructType\Difficulty_to_FillObjectType $difficulty_to_Fill_Reference = null)
    {
        $this->Difficulty_to_Fill_Reference = $difficulty_to_Fill_Reference;
        return $this;
    }
}
