<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the detailed information about a Position.
 * @subpackage Structs
 */
class Position_DataType extends AbstractStructBase
{
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the supervisory organization on the position.
     * @var \StructType\Supervisory_OrganizationObjectType
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Date this position is effective.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Effective_Date;
    /**
     * The Position_Definition_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Position_Details_DataType
     */
    public $Position_Definition_Data;
    /**
     * The Position_Restrictions_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Position_Group_Restriction_Summary_DataType
     */
    public $Position_Restrictions_Data;
    /**
     * The Position_Restriction_Working_Hours_Details_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Working_Hours_Details_DataType
     */
    public $Position_Restriction_Working_Hours_Details_Data;
    /**
     * The Default_Compensation_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Compensation_Default_DataType
     */
    public $Default_Compensation_Data;
    /**
     * The Default_Position_Organization_Assignments_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Default_Position_Organization_Assignments_DataType
     */
    public $Default_Position_Organization_Assignments_Data;
    /**
     * The Worker_For_Filled_Position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Worker_For_Filled_PositionType
     */
    public $Worker_For_Filled_Position;
    /**
     * The Qualification_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public $Qualification_Data;
    /**
     * The Integration_Field_Override_Data
     * Meta information extracted from the WSDL
     * - documentation: Position External Field Result Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_Field_Result_DataType[]
     */
    public $Integration_Field_Override_Data;
    /**
     * The Job_Requisition_Data
     * Meta information extracted from the WSDL
     * - documentation: Returns the effective Job Requisition for the Position. Starting in WD22, this requisition can have a status of 'Open' or 'Frozen'. If you need to see that status, please use the v22.0 version of the web service.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_DataType
     */
    public $Job_Requisition_Data;
    /**
     * The Closed
     * Meta information extracted from the WSDL
     * - documentation: Returns true of the position is closed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Closed;
    /**
     * Constructor method for Position_DataType
     * @uses Position_DataType::setSupervisory_Organization_Reference()
     * @uses Position_DataType::setEffective_Date()
     * @uses Position_DataType::setPosition_Definition_Data()
     * @uses Position_DataType::setPosition_Restrictions_Data()
     * @uses Position_DataType::setPosition_Restriction_Working_Hours_Details_Data()
     * @uses Position_DataType::setDefault_Compensation_Data()
     * @uses Position_DataType::setDefault_Position_Organization_Assignments_Data()
     * @uses Position_DataType::setWorker_For_Filled_Position()
     * @uses Position_DataType::setQualification_Data()
     * @uses Position_DataType::setIntegration_Field_Override_Data()
     * @uses Position_DataType::setJob_Requisition_Data()
     * @uses Position_DataType::setClosed()
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @param string $effective_Date
     * @param \StructType\Position_Details_DataType $position_Definition_Data
     * @param \StructType\Position_Group_Restriction_Summary_DataType $position_Restrictions_Data
     * @param \StructType\Working_Hours_Details_DataType $position_Restriction_Working_Hours_Details_Data
     * @param \StructType\Compensation_Default_DataType $default_Compensation_Data
     * @param \StructType\Default_Position_Organization_Assignments_DataType $default_Position_Organization_Assignments_Data
     * @param \StructType\Worker_For_Filled_PositionType $worker_For_Filled_Position
     * @param \StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data
     * @param \StructType\Document_Field_Result_DataType[] $integration_Field_Override_Data
     * @param \StructType\Job_Requisition_DataType $job_Requisition_Data
     * @param bool $closed
     */
    public function __construct(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null, $effective_Date = null, \StructType\Position_Details_DataType $position_Definition_Data = null, \StructType\Position_Group_Restriction_Summary_DataType $position_Restrictions_Data = null, \StructType\Working_Hours_Details_DataType $position_Restriction_Working_Hours_Details_Data = null, \StructType\Compensation_Default_DataType $default_Compensation_Data = null, \StructType\Default_Position_Organization_Assignments_DataType $default_Position_Organization_Assignments_Data = null, \StructType\Worker_For_Filled_PositionType $worker_For_Filled_Position = null, \StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data = null, array $integration_Field_Override_Data = array(), \StructType\Job_Requisition_DataType $job_Requisition_Data = null, $closed = null)
    {
        $this
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setEffective_Date($effective_Date)
            ->setPosition_Definition_Data($position_Definition_Data)
            ->setPosition_Restrictions_Data($position_Restrictions_Data)
            ->setPosition_Restriction_Working_Hours_Details_Data($position_Restriction_Working_Hours_Details_Data)
            ->setDefault_Compensation_Data($default_Compensation_Data)
            ->setDefault_Position_Organization_Assignments_Data($default_Position_Organization_Assignments_Data)
            ->setWorker_For_Filled_Position($worker_For_Filled_Position)
            ->setQualification_Data($qualification_Data)
            ->setIntegration_Field_Override_Data($integration_Field_Override_Data)
            ->setJob_Requisition_Data($job_Requisition_Data)
            ->setClosed($closed);
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @return \StructType\Position_DataType
     */
    public function setSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Position_DataType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Position_Definition_Data value
     * @return \StructType\Position_Details_DataType|null
     */
    public function getPosition_Definition_Data()
    {
        return $this->Position_Definition_Data;
    }
    /**
     * Set Position_Definition_Data value
     * @param \StructType\Position_Details_DataType $position_Definition_Data
     * @return \StructType\Position_DataType
     */
    public function setPosition_Definition_Data(\StructType\Position_Details_DataType $position_Definition_Data = null)
    {
        $this->Position_Definition_Data = $position_Definition_Data;
        return $this;
    }
    /**
     * Get Position_Restrictions_Data value
     * @return \StructType\Position_Group_Restriction_Summary_DataType|null
     */
    public function getPosition_Restrictions_Data()
    {
        return $this->Position_Restrictions_Data;
    }
    /**
     * Set Position_Restrictions_Data value
     * @param \StructType\Position_Group_Restriction_Summary_DataType $position_Restrictions_Data
     * @return \StructType\Position_DataType
     */
    public function setPosition_Restrictions_Data(\StructType\Position_Group_Restriction_Summary_DataType $position_Restrictions_Data = null)
    {
        $this->Position_Restrictions_Data = $position_Restrictions_Data;
        return $this;
    }
    /**
     * Get Position_Restriction_Working_Hours_Details_Data value
     * @return \StructType\Working_Hours_Details_DataType|null
     */
    public function getPosition_Restriction_Working_Hours_Details_Data()
    {
        return $this->Position_Restriction_Working_Hours_Details_Data;
    }
    /**
     * Set Position_Restriction_Working_Hours_Details_Data value
     * @param \StructType\Working_Hours_Details_DataType $position_Restriction_Working_Hours_Details_Data
     * @return \StructType\Position_DataType
     */
    public function setPosition_Restriction_Working_Hours_Details_Data(\StructType\Working_Hours_Details_DataType $position_Restriction_Working_Hours_Details_Data = null)
    {
        $this->Position_Restriction_Working_Hours_Details_Data = $position_Restriction_Working_Hours_Details_Data;
        return $this;
    }
    /**
     * Get Default_Compensation_Data value
     * @return \StructType\Compensation_Default_DataType|null
     */
    public function getDefault_Compensation_Data()
    {
        return $this->Default_Compensation_Data;
    }
    /**
     * Set Default_Compensation_Data value
     * @param \StructType\Compensation_Default_DataType $default_Compensation_Data
     * @return \StructType\Position_DataType
     */
    public function setDefault_Compensation_Data(\StructType\Compensation_Default_DataType $default_Compensation_Data = null)
    {
        $this->Default_Compensation_Data = $default_Compensation_Data;
        return $this;
    }
    /**
     * Get Default_Position_Organization_Assignments_Data value
     * @return \StructType\Default_Position_Organization_Assignments_DataType|null
     */
    public function getDefault_Position_Organization_Assignments_Data()
    {
        return $this->Default_Position_Organization_Assignments_Data;
    }
    /**
     * Set Default_Position_Organization_Assignments_Data value
     * @param \StructType\Default_Position_Organization_Assignments_DataType $default_Position_Organization_Assignments_Data
     * @return \StructType\Position_DataType
     */
    public function setDefault_Position_Organization_Assignments_Data(\StructType\Default_Position_Organization_Assignments_DataType $default_Position_Organization_Assignments_Data = null)
    {
        $this->Default_Position_Organization_Assignments_Data = $default_Position_Organization_Assignments_Data;
        return $this;
    }
    /**
     * Get Worker_For_Filled_Position value
     * @return \StructType\Worker_For_Filled_PositionType|null
     */
    public function getWorker_For_Filled_Position()
    {
        return $this->Worker_For_Filled_Position;
    }
    /**
     * Set Worker_For_Filled_Position value
     * @param \StructType\Worker_For_Filled_PositionType $worker_For_Filled_Position
     * @return \StructType\Position_DataType
     */
    public function setWorker_For_Filled_Position(\StructType\Worker_For_Filled_PositionType $worker_For_Filled_Position = null)
    {
        $this->Worker_For_Filled_Position = $worker_For_Filled_Position;
        return $this;
    }
    /**
     * Get Qualification_Data value
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType|null
     */
    public function getQualification_Data()
    {
        return $this->Qualification_Data;
    }
    /**
     * Set Qualification_Data value
     * @param \StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data
     * @return \StructType\Position_DataType
     */
    public function setQualification_Data(\StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data = null)
    {
        $this->Qualification_Data = $qualification_Data;
        return $this;
    }
    /**
     * Get Integration_Field_Override_Data value
     * @return \StructType\Document_Field_Result_DataType[]|null
     */
    public function getIntegration_Field_Override_Data()
    {
        return $this->Integration_Field_Override_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setIntegration_Field_Override_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIntegration_Field_Override_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIntegration_Field_Override_DataForArrayConstraintsFromSetIntegration_Field_Override_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $position_DataTypeIntegration_Field_Override_DataItem) {
            // validation for constraint: itemType
            if (!$position_DataTypeIntegration_Field_Override_DataItem instanceof \StructType\Document_Field_Result_DataType) {
                $invalidValues[] = is_object($position_DataTypeIntegration_Field_Override_DataItem) ? get_class($position_DataTypeIntegration_Field_Override_DataItem) : sprintf('%s(%s)', gettype($position_DataTypeIntegration_Field_Override_DataItem), var_export($position_DataTypeIntegration_Field_Override_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Integration_Field_Override_Data property can only contain items of type \StructType\Document_Field_Result_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Integration_Field_Override_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Field_Result_DataType[] $integration_Field_Override_Data
     * @return \StructType\Position_DataType
     */
    public function setIntegration_Field_Override_Data(array $integration_Field_Override_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($integration_Field_Override_DataArrayErrorMessage = self::validateIntegration_Field_Override_DataForArrayConstraintsFromSetIntegration_Field_Override_Data($integration_Field_Override_Data))) {
            throw new \InvalidArgumentException($integration_Field_Override_DataArrayErrorMessage, __LINE__);
        }
        $this->Integration_Field_Override_Data = $integration_Field_Override_Data;
        return $this;
    }
    /**
     * Add item to Integration_Field_Override_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Field_Result_DataType $item
     * @return \StructType\Position_DataType
     */
    public function addToIntegration_Field_Override_Data(\StructType\Document_Field_Result_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_Field_Result_DataType) {
            throw new \InvalidArgumentException(sprintf('The Integration_Field_Override_Data property can only contain items of type \StructType\Document_Field_Result_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Integration_Field_Override_Data[] = $item;
        return $this;
    }
    /**
     * Get Job_Requisition_Data value
     * @return \StructType\Job_Requisition_DataType|null
     */
    public function getJob_Requisition_Data()
    {
        return $this->Job_Requisition_Data;
    }
    /**
     * Set Job_Requisition_Data value
     * @param \StructType\Job_Requisition_DataType $job_Requisition_Data
     * @return \StructType\Position_DataType
     */
    public function setJob_Requisition_Data(\StructType\Job_Requisition_DataType $job_Requisition_Data = null)
    {
        $this->Job_Requisition_Data = $job_Requisition_Data;
        return $this;
    }
    /**
     * Get Closed value
     * @return bool|null
     */
    public function getClosed()
    {
        return $this->Closed;
    }
    /**
     * Set Closed value
     * @param bool $closed
     * @return \StructType\Position_DataType
     */
    public function setClosed($closed = null)
    {
        // validation for constraint: boolean
        if (!is_null($closed) && !is_bool($closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($closed, true), gettype($closed)), __LINE__);
        }
        $this->Closed = $closed;
        return $this;
    }
}
