<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Personal_Information_For_Country_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specify the ~worker’s~ Position to collect the country for Personal Information for the worker. | Specify the pre-hire's In-Progress Hire Event country or 1 of the Considered for Positions' country or the Hiring Restrictions
 * country to collect the Personal Information for the pre-hire. | Personal Information by Country
 * @subpackage Structs
 */
class Personal_Information_For_Country_DataType extends AbstractStructBase
{
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: Country for Personal Information.
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Country_Personal_Information_Data
     * Meta information extracted from the WSDL
     * - documentation: Country Specific Personal Information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Country_Personal_Information_DataType[]
     */
    public $Country_Personal_Information_Data;
    /**
     * Constructor method for Personal_Information_For_Country_DataType
     * @uses Personal_Information_For_Country_DataType::setCountry_Reference()
     * @uses Personal_Information_For_Country_DataType::setCountry_Personal_Information_Data()
     * @param \StructType\CountryObjectType $country_Reference
     * @param \StructType\Country_Personal_Information_DataType[] $country_Personal_Information_Data
     */
    public function __construct(\StructType\CountryObjectType $country_Reference = null, array $country_Personal_Information_Data = array())
    {
        $this
            ->setCountry_Reference($country_Reference)
            ->setCountry_Personal_Information_Data($country_Personal_Information_Data);
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Personal_Information_For_Country_DataType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Country_Personal_Information_Data value
     * @return \StructType\Country_Personal_Information_DataType[]|null
     */
    public function getCountry_Personal_Information_Data()
    {
        return $this->Country_Personal_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCountry_Personal_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountry_Personal_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountry_Personal_Information_DataForArrayConstraintsFromSetCountry_Personal_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personal_Information_For_Country_DataTypeCountry_Personal_Information_DataItem) {
            // validation for constraint: itemType
            if (!$personal_Information_For_Country_DataTypeCountry_Personal_Information_DataItem instanceof \StructType\Country_Personal_Information_DataType) {
                $invalidValues[] = is_object($personal_Information_For_Country_DataTypeCountry_Personal_Information_DataItem) ? get_class($personal_Information_For_Country_DataTypeCountry_Personal_Information_DataItem) : sprintf('%s(%s)', gettype($personal_Information_For_Country_DataTypeCountry_Personal_Information_DataItem), var_export($personal_Information_For_Country_DataTypeCountry_Personal_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Country_Personal_Information_Data property can only contain items of type \StructType\Country_Personal_Information_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Country_Personal_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Country_Personal_Information_DataType[] $country_Personal_Information_Data
     * @return \StructType\Personal_Information_For_Country_DataType
     */
    public function setCountry_Personal_Information_Data(array $country_Personal_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($country_Personal_Information_DataArrayErrorMessage = self::validateCountry_Personal_Information_DataForArrayConstraintsFromSetCountry_Personal_Information_Data($country_Personal_Information_Data))) {
            throw new \InvalidArgumentException($country_Personal_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Country_Personal_Information_Data = $country_Personal_Information_Data;
        return $this;
    }
    /**
     * Add item to Country_Personal_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Country_Personal_Information_DataType $item
     * @return \StructType\Personal_Information_For_Country_DataType
     */
    public function addToCountry_Personal_Information_Data(\StructType\Country_Personal_Information_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Country_Personal_Information_DataType) {
            throw new \InvalidArgumentException(sprintf('The Country_Personal_Information_Data property can only contain items of type \StructType\Country_Personal_Information_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Country_Personal_Information_Data[] = $item;
        return $this;
    }
}
