<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person_Biographic_and_Demographic_Information_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Specify an Aboriginal/Indigenous Identification Details Reference that is valid for this country. | To specify a value for Aboriginal/Indigenous Identification Details, you must enable Aboriginal/Indigenous Identification Details as
 * an allowed field for the country the job is located in. | Specify an active Aboriginal/Indigenous Identification Details Reference. | When you specify a value for the Aboriginal/Indigenous Identification Details, you must also specify Yes for
 * Aboriginal/Indigenous Identification. | To specify a value for Aboriginal/Indigenous Identification, you must enable Aboriginal/Indigenous Identification as an allowed field for the country the job is located in. | Specify a Social Benefits Locality
 * that is valid for this country. | Specify a Marital Status that is valid for this country. | Specify a Religion that is valid for this country. | Specify an Ethnicity that is valid for this country. | Specify a Gender that is valid for this country.
 * | Specify an LGBT Identification that is valid for this country. | Sexual Orientation is not tracked for the specified Location Context. The Location Context is derived from the Country of the Location for the Position. | Gender Identity is not
 * tracked for the specified Location Context. The Location Context is derived from the Country of the Location for the Position. | Pronoun is not tracked for the specified Location Context. The Location Context is derived from the Country of the
 * Location for the Position. | The Sexual Orientation and Gender Identity is not tracked for the specified Location Context. The Location Context is derived from the Country of the Location. | The Additional Nationalities is not tracked for the
 * specified Location Context. The Location Context is derived from the Country of the Location. | The Primary Nationality is not tracked for the specified Location Context. The Location Context is derived from the Country of the Location. | The
 * Religion is not tracked for the specified Location Context. The Location Context is derived from the Country of the Location. | The Social Benefits Locality is not tracked for the specified Location Context. The Location Context is derived from the
 * Country of the Location. | The Hispanic or Latino ethnicity does not exist in the specified Location Context. The Location Context is derived from the Country of the Location of the Position | The city of birth is not tracked for the specified
 * Location Context. The Location Context is derived from the Country of the Location | The ethnicity does not exist in the specified Location Context. The Location Context is derived from the Country of the Location of the Position | The country region
 * of birth is not tracked for the specified Location Context. The Location Context is derived from the Country of the Location for the Position | The country of birth is not tracked for the specified Location Context. The Location Context is derived
 * from the Country of the Location for the Position | The date of birth is not tracked in the specified Location Context. The Location Context is derived from the Country of the Location specified for the Position. | The marital status does not exist
 * in the specified Location Context. The Location Context is derived from the Country of the Location specified for the Position. | The Citizenship Status is not tracked for the specified Location Context. The Location Context is derived from the
 * Country of the Location for the Position. | The Gender is not tracked for the specified Location Context. The Location Context is derived from the Country of the Location for the Position. | Contains Candidate Personal Info: Gender, Date of Birth,
 * Country of Birth, Place of Birth Region, Place of Birth City, Ethnicity, Social Benefits Locality, Marital Status, Hispanic/Latino, Military Service, Religion, Citizenship Status , Primary Nationality, Additional Nationalities, Relative Name,
 * Disabilities, Sexual Orientation Gender Identity
 * @subpackage Structs
 */
class Person_Biographic_and_Demographic_Information_DataType extends AbstractStructBase
{
    /**
     * The Gender_Reference
     * Meta information extracted from the WSDL
     * - documentation: External Committee Member can specify Gender
     * - minOccurs: 0
     * @var \StructType\GenderObjectType
     */
    public $Gender_Reference;
    /**
     * The Date_of_Birth
     * Meta information extracted from the WSDL
     * - documentation: External Committee Member can specify Date of Birth
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date_of_Birth;
    /**
     * The Birth_Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Country of Birth
     * - minOccurs: 0
     * @var \StructType\CountryObjectType
     */
    public $Birth_Country_Reference;
    /**
     * The Birth_Region_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Place of Birth Region
     * - minOccurs: 0
     * @var \StructType\Country_RegionObjectType
     */
    public $Birth_Region_Reference;
    /**
     * The City_of_Birth
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Place of Birth City
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City_of_Birth;
    /**
     * The Marital_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: External Committee Member can specify Marital Status
     * - minOccurs: 0
     * @var \StructType\Marital_StatusObjectType
     */
    public $Marital_Status_Reference;
    /**
     * The Hispanic_or_Latino
     * Meta information extracted from the WSDL
     * - documentation: External Committee Member can specify if they are of Hispanic or Latino descent
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Hispanic_or_Latino;
    /**
     * The Aboriginal_Indigenous_Identification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Aboriginal/Indigenous Identification
     * - minOccurs: 0
     * @var \StructType\Aboriginal_Indigenous_Identification_SelectionObjectType
     */
    public $Aboriginal_Indigenous_Identification_Reference;
    /**
     * The Aboriginal_Indigenous_Identification_Details_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Aboriginal/Indigenous Identification Details
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Aboriginal_Indigenous_DetailsObjectType[]
     */
    public $Aboriginal_Indigenous_Identification_Details_Reference;
    /**
     * The Ethnicity_Reference
     * Meta information extracted from the WSDL
     * - documentation: External Committee Member can specify there Ethnicity. It must be recognized by the Country they are applying in.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EthnicityObjectType[]
     */
    public $Ethnicity_Reference;
    /**
     * The Religion_Reference
     * Meta information extracted from the WSDL
     * - documentation: External Committee Member can specify Religion
     * - minOccurs: 0
     * @var \StructType\ReligionObjectType
     */
    public $Religion_Reference;
    /**
     * The Citizenship_Reference
     * Meta information extracted from the WSDL
     * - documentation: External Committee Member can specify Citizenship Status
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Citizenship_StatusObjectType[]
     */
    public $Citizenship_Reference;
    /**
     * The Nationality_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Nationality
     * - minOccurs: 0
     * @var \StructType\CountryObjectType
     */
    public $Nationality_Reference;
    /**
     * The Additional_Nationality_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Additional Nationalities
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CountryObjectType[]
     */
    public $Additional_Nationality_Reference;
    /**
     * The Social_Benefits_Locality_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Social Benefits Locality
     * - minOccurs: 0
     * @var \StructType\Social_Benefits_LocalityObjectType
     */
    public $Social_Benefits_Locality_Reference;
    /**
     * The LGBT_Identification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Sexual Orientation Gender Identity
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LGBT_IdentificationObjectType[]
     */
    public $LGBT_Identification_Reference;
    /**
     * The Sexual_Orientation_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Sexual Orientation.
     * - minOccurs: 0
     * @var \StructType\Sexual_OrientationObjectType
     */
    public $Sexual_Orientation_Reference;
    /**
     * The Gender_Identity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Gender Identity.
     * - minOccurs: 0
     * @var \StructType\Gender_IdentityObjectType
     */
    public $Gender_Identity_Reference;
    /**
     * The Pronoun_Reference
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Pronoun.
     * - minOccurs: 0
     * @var \StructType\PronounObjectType
     */
    public $Pronoun_Reference;
    /**
     * The Disability_Status_Data
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Disability Information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Disability_Status_DataType[]
     */
    public $Disability_Status_Data;
    /**
     * The Military_Service_Information_Data
     * Meta information extracted from the WSDL
     * - documentation: Candidate can specify Military Service Information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Military_Service_Information_DataType[]
     */
    public $Military_Service_Information_Data;
    /**
     * Constructor method for Person_Biographic_and_Demographic_Information_DataType
     * @uses Person_Biographic_and_Demographic_Information_DataType::setGender_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setDate_of_Birth()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setBirth_Country_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setBirth_Region_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setCity_of_Birth()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setMarital_Status_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setHispanic_or_Latino()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setAboriginal_Indigenous_Identification_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setAboriginal_Indigenous_Identification_Details_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setEthnicity_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setReligion_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setCitizenship_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setNationality_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setAdditional_Nationality_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setSocial_Benefits_Locality_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setLGBT_Identification_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setSexual_Orientation_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setGender_Identity_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setPronoun_Reference()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setDisability_Status_Data()
     * @uses Person_Biographic_and_Demographic_Information_DataType::setMilitary_Service_Information_Data()
     * @param \StructType\GenderObjectType $gender_Reference
     * @param string $date_of_Birth
     * @param \StructType\CountryObjectType $birth_Country_Reference
     * @param \StructType\Country_RegionObjectType $birth_Region_Reference
     * @param string $city_of_Birth
     * @param \StructType\Marital_StatusObjectType $marital_Status_Reference
     * @param bool $hispanic_or_Latino
     * @param \StructType\Aboriginal_Indigenous_Identification_SelectionObjectType $aboriginal_Indigenous_Identification_Reference
     * @param \StructType\Aboriginal_Indigenous_DetailsObjectType[] $aboriginal_Indigenous_Identification_Details_Reference
     * @param \StructType\EthnicityObjectType[] $ethnicity_Reference
     * @param \StructType\ReligionObjectType $religion_Reference
     * @param \StructType\Citizenship_StatusObjectType[] $citizenship_Reference
     * @param \StructType\CountryObjectType $nationality_Reference
     * @param \StructType\CountryObjectType[] $additional_Nationality_Reference
     * @param \StructType\Social_Benefits_LocalityObjectType $social_Benefits_Locality_Reference
     * @param \StructType\LGBT_IdentificationObjectType[] $lGBT_Identification_Reference
     * @param \StructType\Sexual_OrientationObjectType $sexual_Orientation_Reference
     * @param \StructType\Gender_IdentityObjectType $gender_Identity_Reference
     * @param \StructType\PronounObjectType $pronoun_Reference
     * @param \StructType\Candidate_Disability_Status_DataType[] $disability_Status_Data
     * @param \StructType\Candidate_Military_Service_Information_DataType[] $military_Service_Information_Data
     */
    public function __construct(\StructType\GenderObjectType $gender_Reference = null, $date_of_Birth = null, \StructType\CountryObjectType $birth_Country_Reference = null, \StructType\Country_RegionObjectType $birth_Region_Reference = null, $city_of_Birth = null, \StructType\Marital_StatusObjectType $marital_Status_Reference = null, $hispanic_or_Latino = null, \StructType\Aboriginal_Indigenous_Identification_SelectionObjectType $aboriginal_Indigenous_Identification_Reference = null, array $aboriginal_Indigenous_Identification_Details_Reference = array(), array $ethnicity_Reference = array(), \StructType\ReligionObjectType $religion_Reference = null, array $citizenship_Reference = array(), \StructType\CountryObjectType $nationality_Reference = null, array $additional_Nationality_Reference = array(), \StructType\Social_Benefits_LocalityObjectType $social_Benefits_Locality_Reference = null, array $lGBT_Identification_Reference = array(), \StructType\Sexual_OrientationObjectType $sexual_Orientation_Reference = null, \StructType\Gender_IdentityObjectType $gender_Identity_Reference = null, \StructType\PronounObjectType $pronoun_Reference = null, array $disability_Status_Data = array(), array $military_Service_Information_Data = array())
    {
        $this
            ->setGender_Reference($gender_Reference)
            ->setDate_of_Birth($date_of_Birth)
            ->setBirth_Country_Reference($birth_Country_Reference)
            ->setBirth_Region_Reference($birth_Region_Reference)
            ->setCity_of_Birth($city_of_Birth)
            ->setMarital_Status_Reference($marital_Status_Reference)
            ->setHispanic_or_Latino($hispanic_or_Latino)
            ->setAboriginal_Indigenous_Identification_Reference($aboriginal_Indigenous_Identification_Reference)
            ->setAboriginal_Indigenous_Identification_Details_Reference($aboriginal_Indigenous_Identification_Details_Reference)
            ->setEthnicity_Reference($ethnicity_Reference)
            ->setReligion_Reference($religion_Reference)
            ->setCitizenship_Reference($citizenship_Reference)
            ->setNationality_Reference($nationality_Reference)
            ->setAdditional_Nationality_Reference($additional_Nationality_Reference)
            ->setSocial_Benefits_Locality_Reference($social_Benefits_Locality_Reference)
            ->setLGBT_Identification_Reference($lGBT_Identification_Reference)
            ->setSexual_Orientation_Reference($sexual_Orientation_Reference)
            ->setGender_Identity_Reference($gender_Identity_Reference)
            ->setPronoun_Reference($pronoun_Reference)
            ->setDisability_Status_Data($disability_Status_Data)
            ->setMilitary_Service_Information_Data($military_Service_Information_Data);
    }
    /**
     * Get Gender_Reference value
     * @return \StructType\GenderObjectType|null
     */
    public function getGender_Reference()
    {
        return $this->Gender_Reference;
    }
    /**
     * Set Gender_Reference value
     * @param \StructType\GenderObjectType $gender_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setGender_Reference(\StructType\GenderObjectType $gender_Reference = null)
    {
        $this->Gender_Reference = $gender_Reference;
        return $this;
    }
    /**
     * Get Date_of_Birth value
     * @return string|null
     */
    public function getDate_of_Birth()
    {
        return $this->Date_of_Birth;
    }
    /**
     * Set Date_of_Birth value
     * @param string $date_of_Birth
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setDate_of_Birth($date_of_Birth = null)
    {
        // validation for constraint: string
        if (!is_null($date_of_Birth) && !is_string($date_of_Birth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_of_Birth, true), gettype($date_of_Birth)), __LINE__);
        }
        $this->Date_of_Birth = $date_of_Birth;
        return $this;
    }
    /**
     * Get Birth_Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getBirth_Country_Reference()
    {
        return $this->Birth_Country_Reference;
    }
    /**
     * Set Birth_Country_Reference value
     * @param \StructType\CountryObjectType $birth_Country_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setBirth_Country_Reference(\StructType\CountryObjectType $birth_Country_Reference = null)
    {
        $this->Birth_Country_Reference = $birth_Country_Reference;
        return $this;
    }
    /**
     * Get Birth_Region_Reference value
     * @return \StructType\Country_RegionObjectType|null
     */
    public function getBirth_Region_Reference()
    {
        return $this->Birth_Region_Reference;
    }
    /**
     * Set Birth_Region_Reference value
     * @param \StructType\Country_RegionObjectType $birth_Region_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setBirth_Region_Reference(\StructType\Country_RegionObjectType $birth_Region_Reference = null)
    {
        $this->Birth_Region_Reference = $birth_Region_Reference;
        return $this;
    }
    /**
     * Get City_of_Birth value
     * @return string|null
     */
    public function getCity_of_Birth()
    {
        return $this->City_of_Birth;
    }
    /**
     * Set City_of_Birth value
     * @param string $city_of_Birth
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setCity_of_Birth($city_of_Birth = null)
    {
        // validation for constraint: string
        if (!is_null($city_of_Birth) && !is_string($city_of_Birth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city_of_Birth, true), gettype($city_of_Birth)), __LINE__);
        }
        $this->City_of_Birth = $city_of_Birth;
        return $this;
    }
    /**
     * Get Marital_Status_Reference value
     * @return \StructType\Marital_StatusObjectType|null
     */
    public function getMarital_Status_Reference()
    {
        return $this->Marital_Status_Reference;
    }
    /**
     * Set Marital_Status_Reference value
     * @param \StructType\Marital_StatusObjectType $marital_Status_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setMarital_Status_Reference(\StructType\Marital_StatusObjectType $marital_Status_Reference = null)
    {
        $this->Marital_Status_Reference = $marital_Status_Reference;
        return $this;
    }
    /**
     * Get Hispanic_or_Latino value
     * @return bool|null
     */
    public function getHispanic_or_Latino()
    {
        return $this->Hispanic_or_Latino;
    }
    /**
     * Set Hispanic_or_Latino value
     * @param bool $hispanic_or_Latino
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setHispanic_or_Latino($hispanic_or_Latino = null)
    {
        // validation for constraint: boolean
        if (!is_null($hispanic_or_Latino) && !is_bool($hispanic_or_Latino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hispanic_or_Latino, true), gettype($hispanic_or_Latino)), __LINE__);
        }
        $this->Hispanic_or_Latino = $hispanic_or_Latino;
        return $this;
    }
    /**
     * Get Aboriginal_Indigenous_Identification_Reference value
     * @return \StructType\Aboriginal_Indigenous_Identification_SelectionObjectType|null
     */
    public function getAboriginal_Indigenous_Identification_Reference()
    {
        return $this->Aboriginal_Indigenous_Identification_Reference;
    }
    /**
     * Set Aboriginal_Indigenous_Identification_Reference value
     * @param \StructType\Aboriginal_Indigenous_Identification_SelectionObjectType $aboriginal_Indigenous_Identification_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setAboriginal_Indigenous_Identification_Reference(\StructType\Aboriginal_Indigenous_Identification_SelectionObjectType $aboriginal_Indigenous_Identification_Reference = null)
    {
        $this->Aboriginal_Indigenous_Identification_Reference = $aboriginal_Indigenous_Identification_Reference;
        return $this;
    }
    /**
     * Get Aboriginal_Indigenous_Identification_Details_Reference value
     * @return \StructType\Aboriginal_Indigenous_DetailsObjectType[]|null
     */
    public function getAboriginal_Indigenous_Identification_Details_Reference()
    {
        return $this->Aboriginal_Indigenous_Identification_Details_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAboriginal_Indigenous_Identification_Details_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAboriginal_Indigenous_Identification_Details_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAboriginal_Indigenous_Identification_Details_ReferenceForArrayConstraintsFromSetAboriginal_Indigenous_Identification_Details_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $person_Biographic_and_Demographic_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem) {
            // validation for constraint: itemType
            if (!$person_Biographic_and_Demographic_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem instanceof \StructType\Aboriginal_Indigenous_DetailsObjectType) {
                $invalidValues[] = is_object($person_Biographic_and_Demographic_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem) ? get_class($person_Biographic_and_Demographic_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem) : sprintf('%s(%s)', gettype($person_Biographic_and_Demographic_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem), var_export($person_Biographic_and_Demographic_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Aboriginal_Indigenous_Identification_Details_Reference property can only contain items of type \StructType\Aboriginal_Indigenous_DetailsObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Aboriginal_Indigenous_Identification_Details_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Aboriginal_Indigenous_DetailsObjectType[] $aboriginal_Indigenous_Identification_Details_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setAboriginal_Indigenous_Identification_Details_Reference(array $aboriginal_Indigenous_Identification_Details_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($aboriginal_Indigenous_Identification_Details_ReferenceArrayErrorMessage = self::validateAboriginal_Indigenous_Identification_Details_ReferenceForArrayConstraintsFromSetAboriginal_Indigenous_Identification_Details_Reference($aboriginal_Indigenous_Identification_Details_Reference))) {
            throw new \InvalidArgumentException($aboriginal_Indigenous_Identification_Details_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Aboriginal_Indigenous_Identification_Details_Reference = $aboriginal_Indigenous_Identification_Details_Reference;
        return $this;
    }
    /**
     * Add item to Aboriginal_Indigenous_Identification_Details_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Aboriginal_Indigenous_DetailsObjectType $item
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function addToAboriginal_Indigenous_Identification_Details_Reference(\StructType\Aboriginal_Indigenous_DetailsObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Aboriginal_Indigenous_DetailsObjectType) {
            throw new \InvalidArgumentException(sprintf('The Aboriginal_Indigenous_Identification_Details_Reference property can only contain items of type \StructType\Aboriginal_Indigenous_DetailsObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Aboriginal_Indigenous_Identification_Details_Reference[] = $item;
        return $this;
    }
    /**
     * Get Ethnicity_Reference value
     * @return \StructType\EthnicityObjectType[]|null
     */
    public function getEthnicity_Reference()
    {
        return $this->Ethnicity_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setEthnicity_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEthnicity_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEthnicity_ReferenceForArrayConstraintsFromSetEthnicity_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $person_Biographic_and_Demographic_Information_DataTypeEthnicity_ReferenceItem) {
            // validation for constraint: itemType
            if (!$person_Biographic_and_Demographic_Information_DataTypeEthnicity_ReferenceItem instanceof \StructType\EthnicityObjectType) {
                $invalidValues[] = is_object($person_Biographic_and_Demographic_Information_DataTypeEthnicity_ReferenceItem) ? get_class($person_Biographic_and_Demographic_Information_DataTypeEthnicity_ReferenceItem) : sprintf('%s(%s)', gettype($person_Biographic_and_Demographic_Information_DataTypeEthnicity_ReferenceItem), var_export($person_Biographic_and_Demographic_Information_DataTypeEthnicity_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ethnicity_Reference property can only contain items of type \StructType\EthnicityObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ethnicity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\EthnicityObjectType[] $ethnicity_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setEthnicity_Reference(array $ethnicity_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($ethnicity_ReferenceArrayErrorMessage = self::validateEthnicity_ReferenceForArrayConstraintsFromSetEthnicity_Reference($ethnicity_Reference))) {
            throw new \InvalidArgumentException($ethnicity_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Ethnicity_Reference = $ethnicity_Reference;
        return $this;
    }
    /**
     * Add item to Ethnicity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\EthnicityObjectType $item
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function addToEthnicity_Reference(\StructType\EthnicityObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EthnicityObjectType) {
            throw new \InvalidArgumentException(sprintf('The Ethnicity_Reference property can only contain items of type \StructType\EthnicityObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ethnicity_Reference[] = $item;
        return $this;
    }
    /**
     * Get Religion_Reference value
     * @return \StructType\ReligionObjectType|null
     */
    public function getReligion_Reference()
    {
        return $this->Religion_Reference;
    }
    /**
     * Set Religion_Reference value
     * @param \StructType\ReligionObjectType $religion_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setReligion_Reference(\StructType\ReligionObjectType $religion_Reference = null)
    {
        $this->Religion_Reference = $religion_Reference;
        return $this;
    }
    /**
     * Get Citizenship_Reference value
     * @return \StructType\Citizenship_StatusObjectType[]|null
     */
    public function getCitizenship_Reference()
    {
        return $this->Citizenship_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCitizenship_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCitizenship_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCitizenship_ReferenceForArrayConstraintsFromSetCitizenship_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $person_Biographic_and_Demographic_Information_DataTypeCitizenship_ReferenceItem) {
            // validation for constraint: itemType
            if (!$person_Biographic_and_Demographic_Information_DataTypeCitizenship_ReferenceItem instanceof \StructType\Citizenship_StatusObjectType) {
                $invalidValues[] = is_object($person_Biographic_and_Demographic_Information_DataTypeCitizenship_ReferenceItem) ? get_class($person_Biographic_and_Demographic_Information_DataTypeCitizenship_ReferenceItem) : sprintf('%s(%s)', gettype($person_Biographic_and_Demographic_Information_DataTypeCitizenship_ReferenceItem), var_export($person_Biographic_and_Demographic_Information_DataTypeCitizenship_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Citizenship_Reference property can only contain items of type \StructType\Citizenship_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Citizenship_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Citizenship_StatusObjectType[] $citizenship_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setCitizenship_Reference(array $citizenship_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($citizenship_ReferenceArrayErrorMessage = self::validateCitizenship_ReferenceForArrayConstraintsFromSetCitizenship_Reference($citizenship_Reference))) {
            throw new \InvalidArgumentException($citizenship_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Citizenship_Reference = $citizenship_Reference;
        return $this;
    }
    /**
     * Add item to Citizenship_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Citizenship_StatusObjectType $item
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function addToCitizenship_Reference(\StructType\Citizenship_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Citizenship_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Citizenship_Reference property can only contain items of type \StructType\Citizenship_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Citizenship_Reference[] = $item;
        return $this;
    }
    /**
     * Get Nationality_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getNationality_Reference()
    {
        return $this->Nationality_Reference;
    }
    /**
     * Set Nationality_Reference value
     * @param \StructType\CountryObjectType $nationality_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setNationality_Reference(\StructType\CountryObjectType $nationality_Reference = null)
    {
        $this->Nationality_Reference = $nationality_Reference;
        return $this;
    }
    /**
     * Get Additional_Nationality_Reference value
     * @return \StructType\CountryObjectType[]|null
     */
    public function getAdditional_Nationality_Reference()
    {
        return $this->Additional_Nationality_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Nationality_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Nationality_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Nationality_ReferenceForArrayConstraintsFromSetAdditional_Nationality_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $person_Biographic_and_Demographic_Information_DataTypeAdditional_Nationality_ReferenceItem) {
            // validation for constraint: itemType
            if (!$person_Biographic_and_Demographic_Information_DataTypeAdditional_Nationality_ReferenceItem instanceof \StructType\CountryObjectType) {
                $invalidValues[] = is_object($person_Biographic_and_Demographic_Information_DataTypeAdditional_Nationality_ReferenceItem) ? get_class($person_Biographic_and_Demographic_Information_DataTypeAdditional_Nationality_ReferenceItem) : sprintf('%s(%s)', gettype($person_Biographic_and_Demographic_Information_DataTypeAdditional_Nationality_ReferenceItem), var_export($person_Biographic_and_Demographic_Information_DataTypeAdditional_Nationality_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Nationality_Reference property can only contain items of type \StructType\CountryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Nationality_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryObjectType[] $additional_Nationality_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setAdditional_Nationality_Reference(array $additional_Nationality_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Nationality_ReferenceArrayErrorMessage = self::validateAdditional_Nationality_ReferenceForArrayConstraintsFromSetAdditional_Nationality_Reference($additional_Nationality_Reference))) {
            throw new \InvalidArgumentException($additional_Nationality_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Additional_Nationality_Reference = $additional_Nationality_Reference;
        return $this;
    }
    /**
     * Add item to Additional_Nationality_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryObjectType $item
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function addToAdditional_Nationality_Reference(\StructType\CountryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CountryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Nationality_Reference property can only contain items of type \StructType\CountryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Nationality_Reference[] = $item;
        return $this;
    }
    /**
     * Get Social_Benefits_Locality_Reference value
     * @return \StructType\Social_Benefits_LocalityObjectType|null
     */
    public function getSocial_Benefits_Locality_Reference()
    {
        return $this->Social_Benefits_Locality_Reference;
    }
    /**
     * Set Social_Benefits_Locality_Reference value
     * @param \StructType\Social_Benefits_LocalityObjectType $social_Benefits_Locality_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setSocial_Benefits_Locality_Reference(\StructType\Social_Benefits_LocalityObjectType $social_Benefits_Locality_Reference = null)
    {
        $this->Social_Benefits_Locality_Reference = $social_Benefits_Locality_Reference;
        return $this;
    }
    /**
     * Get LGBT_Identification_Reference value
     * @return \StructType\LGBT_IdentificationObjectType[]|null
     */
    public function getLGBT_Identification_Reference()
    {
        return $this->LGBT_Identification_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setLGBT_Identification_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLGBT_Identification_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLGBT_Identification_ReferenceForArrayConstraintsFromSetLGBT_Identification_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $person_Biographic_and_Demographic_Information_DataTypeLGBT_Identification_ReferenceItem) {
            // validation for constraint: itemType
            if (!$person_Biographic_and_Demographic_Information_DataTypeLGBT_Identification_ReferenceItem instanceof \StructType\LGBT_IdentificationObjectType) {
                $invalidValues[] = is_object($person_Biographic_and_Demographic_Information_DataTypeLGBT_Identification_ReferenceItem) ? get_class($person_Biographic_and_Demographic_Information_DataTypeLGBT_Identification_ReferenceItem) : sprintf('%s(%s)', gettype($person_Biographic_and_Demographic_Information_DataTypeLGBT_Identification_ReferenceItem), var_export($person_Biographic_and_Demographic_Information_DataTypeLGBT_Identification_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LGBT_Identification_Reference property can only contain items of type \StructType\LGBT_IdentificationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LGBT_Identification_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LGBT_IdentificationObjectType[] $lGBT_Identification_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setLGBT_Identification_Reference(array $lGBT_Identification_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($lGBT_Identification_ReferenceArrayErrorMessage = self::validateLGBT_Identification_ReferenceForArrayConstraintsFromSetLGBT_Identification_Reference($lGBT_Identification_Reference))) {
            throw new \InvalidArgumentException($lGBT_Identification_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->LGBT_Identification_Reference = $lGBT_Identification_Reference;
        return $this;
    }
    /**
     * Add item to LGBT_Identification_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LGBT_IdentificationObjectType $item
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function addToLGBT_Identification_Reference(\StructType\LGBT_IdentificationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LGBT_IdentificationObjectType) {
            throw new \InvalidArgumentException(sprintf('The LGBT_Identification_Reference property can only contain items of type \StructType\LGBT_IdentificationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LGBT_Identification_Reference[] = $item;
        return $this;
    }
    /**
     * Get Sexual_Orientation_Reference value
     * @return \StructType\Sexual_OrientationObjectType|null
     */
    public function getSexual_Orientation_Reference()
    {
        return $this->Sexual_Orientation_Reference;
    }
    /**
     * Set Sexual_Orientation_Reference value
     * @param \StructType\Sexual_OrientationObjectType $sexual_Orientation_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setSexual_Orientation_Reference(\StructType\Sexual_OrientationObjectType $sexual_Orientation_Reference = null)
    {
        $this->Sexual_Orientation_Reference = $sexual_Orientation_Reference;
        return $this;
    }
    /**
     * Get Gender_Identity_Reference value
     * @return \StructType\Gender_IdentityObjectType|null
     */
    public function getGender_Identity_Reference()
    {
        return $this->Gender_Identity_Reference;
    }
    /**
     * Set Gender_Identity_Reference value
     * @param \StructType\Gender_IdentityObjectType $gender_Identity_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setGender_Identity_Reference(\StructType\Gender_IdentityObjectType $gender_Identity_Reference = null)
    {
        $this->Gender_Identity_Reference = $gender_Identity_Reference;
        return $this;
    }
    /**
     * Get Pronoun_Reference value
     * @return \StructType\PronounObjectType|null
     */
    public function getPronoun_Reference()
    {
        return $this->Pronoun_Reference;
    }
    /**
     * Set Pronoun_Reference value
     * @param \StructType\PronounObjectType $pronoun_Reference
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setPronoun_Reference(\StructType\PronounObjectType $pronoun_Reference = null)
    {
        $this->Pronoun_Reference = $pronoun_Reference;
        return $this;
    }
    /**
     * Get Disability_Status_Data value
     * @return \StructType\Candidate_Disability_Status_DataType[]|null
     */
    public function getDisability_Status_Data()
    {
        return $this->Disability_Status_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDisability_Status_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisability_Status_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisability_Status_DataForArrayConstraintsFromSetDisability_Status_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $person_Biographic_and_Demographic_Information_DataTypeDisability_Status_DataItem) {
            // validation for constraint: itemType
            if (!$person_Biographic_and_Demographic_Information_DataTypeDisability_Status_DataItem instanceof \StructType\Candidate_Disability_Status_DataType) {
                $invalidValues[] = is_object($person_Biographic_and_Demographic_Information_DataTypeDisability_Status_DataItem) ? get_class($person_Biographic_and_Demographic_Information_DataTypeDisability_Status_DataItem) : sprintf('%s(%s)', gettype($person_Biographic_and_Demographic_Information_DataTypeDisability_Status_DataItem), var_export($person_Biographic_and_Demographic_Information_DataTypeDisability_Status_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Disability_Status_Data property can only contain items of type \StructType\Candidate_Disability_Status_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Disability_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Disability_Status_DataType[] $disability_Status_Data
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setDisability_Status_Data(array $disability_Status_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($disability_Status_DataArrayErrorMessage = self::validateDisability_Status_DataForArrayConstraintsFromSetDisability_Status_Data($disability_Status_Data))) {
            throw new \InvalidArgumentException($disability_Status_DataArrayErrorMessage, __LINE__);
        }
        $this->Disability_Status_Data = $disability_Status_Data;
        return $this;
    }
    /**
     * Add item to Disability_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Disability_Status_DataType $item
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function addToDisability_Status_Data(\StructType\Candidate_Disability_Status_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Disability_Status_DataType) {
            throw new \InvalidArgumentException(sprintf('The Disability_Status_Data property can only contain items of type \StructType\Candidate_Disability_Status_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Disability_Status_Data[] = $item;
        return $this;
    }
    /**
     * Get Military_Service_Information_Data value
     * @return \StructType\Candidate_Military_Service_Information_DataType[]|null
     */
    public function getMilitary_Service_Information_Data()
    {
        return $this->Military_Service_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setMilitary_Service_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMilitary_Service_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMilitary_Service_Information_DataForArrayConstraintsFromSetMilitary_Service_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $person_Biographic_and_Demographic_Information_DataTypeMilitary_Service_Information_DataItem) {
            // validation for constraint: itemType
            if (!$person_Biographic_and_Demographic_Information_DataTypeMilitary_Service_Information_DataItem instanceof \StructType\Candidate_Military_Service_Information_DataType) {
                $invalidValues[] = is_object($person_Biographic_and_Demographic_Information_DataTypeMilitary_Service_Information_DataItem) ? get_class($person_Biographic_and_Demographic_Information_DataTypeMilitary_Service_Information_DataItem) : sprintf('%s(%s)', gettype($person_Biographic_and_Demographic_Information_DataTypeMilitary_Service_Information_DataItem), var_export($person_Biographic_and_Demographic_Information_DataTypeMilitary_Service_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Military_Service_Information_Data property can only contain items of type \StructType\Candidate_Military_Service_Information_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Military_Service_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Military_Service_Information_DataType[] $military_Service_Information_Data
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function setMilitary_Service_Information_Data(array $military_Service_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($military_Service_Information_DataArrayErrorMessage = self::validateMilitary_Service_Information_DataForArrayConstraintsFromSetMilitary_Service_Information_Data($military_Service_Information_Data))) {
            throw new \InvalidArgumentException($military_Service_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Military_Service_Information_Data = $military_Service_Information_Data;
        return $this;
    }
    /**
     * Add item to Military_Service_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Military_Service_Information_DataType $item
     * @return \StructType\Person_Biographic_and_Demographic_Information_DataType
     */
    public function addToMilitary_Service_Information_Data(\StructType\Candidate_Military_Service_Information_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Military_Service_Information_DataType) {
            throw new \InvalidArgumentException(sprintf('The Military_Service_Information_Data property can only contain items of type \StructType\Candidate_Military_Service_Information_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Military_Service_Information_Data[] = $item;
        return $this;
    }
}
