<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Organization_Role_Assignment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for a Organization Role Assignment
 * @subpackage Structs
 */
class Organization_Role_Assignment_DataType extends AbstractStructBase
{
    /**
     * The Role_Assigner_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Role Assigner (e.g., Organization or Project) this role assignment is for.
     * - minOccurs: 0
     * @var \StructType\Role_AssignerObjectType
     */
    public $Role_Assigner_Reference;
    /**
     * The Organization_Role_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Organization Role being assigned.
     * @var \StructType\Assignable_RoleObjectType
     */
    public $Organization_Role_Reference;
    /**
     * The Role_Assignee_Reference
     * Meta information extracted from the WSDL
     * - documentation: The positions to assign to this role assignment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoleeObjectType[]
     */
    public $Role_Assignee_Reference;
    /**
     * The Single_Assignment_Manager_Reference
     * Meta information extracted from the WSDL
     * - documentation: Position explicitly assigned as 'Single Assignment Manager' for a Supervisory org. Must be a position assigned to the Manager role and in 'Maintain Assignable Roles' for the Manager role, the 'Restricted to Single Assignment' option
     * must be turned off. If this field is left blank, the position specified for 'Single Assignment Manager' will be removed.
     * - minOccurs: 0
     * @var \StructType\RoleeObjectType
     */
    public $Single_Assignment_Manager_Reference;
    /**
     * Constructor method for Organization_Role_Assignment_DataType
     * @uses Organization_Role_Assignment_DataType::setRole_Assigner_Reference()
     * @uses Organization_Role_Assignment_DataType::setOrganization_Role_Reference()
     * @uses Organization_Role_Assignment_DataType::setRole_Assignee_Reference()
     * @uses Organization_Role_Assignment_DataType::setSingle_Assignment_Manager_Reference()
     * @param \StructType\Role_AssignerObjectType $role_Assigner_Reference
     * @param \StructType\Assignable_RoleObjectType $organization_Role_Reference
     * @param \StructType\RoleeObjectType[] $role_Assignee_Reference
     * @param \StructType\RoleeObjectType $single_Assignment_Manager_Reference
     */
    public function __construct(\StructType\Role_AssignerObjectType $role_Assigner_Reference = null, \StructType\Assignable_RoleObjectType $organization_Role_Reference = null, array $role_Assignee_Reference = array(), \StructType\RoleeObjectType $single_Assignment_Manager_Reference = null)
    {
        $this
            ->setRole_Assigner_Reference($role_Assigner_Reference)
            ->setOrganization_Role_Reference($organization_Role_Reference)
            ->setRole_Assignee_Reference($role_Assignee_Reference)
            ->setSingle_Assignment_Manager_Reference($single_Assignment_Manager_Reference);
    }
    /**
     * Get Role_Assigner_Reference value
     * @return \StructType\Role_AssignerObjectType|null
     */
    public function getRole_Assigner_Reference()
    {
        return $this->Role_Assigner_Reference;
    }
    /**
     * Set Role_Assigner_Reference value
     * @param \StructType\Role_AssignerObjectType $role_Assigner_Reference
     * @return \StructType\Organization_Role_Assignment_DataType
     */
    public function setRole_Assigner_Reference(\StructType\Role_AssignerObjectType $role_Assigner_Reference = null)
    {
        $this->Role_Assigner_Reference = $role_Assigner_Reference;
        return $this;
    }
    /**
     * Get Organization_Role_Reference value
     * @return \StructType\Assignable_RoleObjectType|null
     */
    public function getOrganization_Role_Reference()
    {
        return $this->Organization_Role_Reference;
    }
    /**
     * Set Organization_Role_Reference value
     * @param \StructType\Assignable_RoleObjectType $organization_Role_Reference
     * @return \StructType\Organization_Role_Assignment_DataType
     */
    public function setOrganization_Role_Reference(\StructType\Assignable_RoleObjectType $organization_Role_Reference = null)
    {
        $this->Organization_Role_Reference = $organization_Role_Reference;
        return $this;
    }
    /**
     * Get Role_Assignee_Reference value
     * @return \StructType\RoleeObjectType[]|null
     */
    public function getRole_Assignee_Reference()
    {
        return $this->Role_Assignee_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRole_Assignee_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRole_Assignee_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRole_Assignee_ReferenceForArrayConstraintsFromSetRole_Assignee_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organization_Role_Assignment_DataTypeRole_Assignee_ReferenceItem) {
            // validation for constraint: itemType
            if (!$organization_Role_Assignment_DataTypeRole_Assignee_ReferenceItem instanceof \StructType\RoleeObjectType) {
                $invalidValues[] = is_object($organization_Role_Assignment_DataTypeRole_Assignee_ReferenceItem) ? get_class($organization_Role_Assignment_DataTypeRole_Assignee_ReferenceItem) : sprintf('%s(%s)', gettype($organization_Role_Assignment_DataTypeRole_Assignee_ReferenceItem), var_export($organization_Role_Assignment_DataTypeRole_Assignee_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Role_Assignee_Reference property can only contain items of type \StructType\RoleeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Role_Assignee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RoleeObjectType[] $role_Assignee_Reference
     * @return \StructType\Organization_Role_Assignment_DataType
     */
    public function setRole_Assignee_Reference(array $role_Assignee_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($role_Assignee_ReferenceArrayErrorMessage = self::validateRole_Assignee_ReferenceForArrayConstraintsFromSetRole_Assignee_Reference($role_Assignee_Reference))) {
            throw new \InvalidArgumentException($role_Assignee_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Role_Assignee_Reference = $role_Assignee_Reference;
        return $this;
    }
    /**
     * Add item to Role_Assignee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RoleeObjectType $item
     * @return \StructType\Organization_Role_Assignment_DataType
     */
    public function addToRole_Assignee_Reference(\StructType\RoleeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoleeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Role_Assignee_Reference property can only contain items of type \StructType\RoleeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Role_Assignee_Reference[] = $item;
        return $this;
    }
    /**
     * Get Single_Assignment_Manager_Reference value
     * @return \StructType\RoleeObjectType|null
     */
    public function getSingle_Assignment_Manager_Reference()
    {
        return $this->Single_Assignment_Manager_Reference;
    }
    /**
     * Set Single_Assignment_Manager_Reference value
     * @param \StructType\RoleeObjectType $single_Assignment_Manager_Reference
     * @return \StructType\Organization_Role_Assignment_DataType
     */
    public function setSingle_Assignment_Manager_Reference(\StructType\RoleeObjectType $single_Assignment_Manager_Reference = null)
    {
        $this->Single_Assignment_Manager_Reference = $single_Assignment_Manager_Reference;
        return $this;
    }
}
