<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Move_Job_Requisition_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specify the Job Requisition to be moved and the Job Requisition's new Supervisory Organization.
 * @subpackage Structs
 */
class Move_Job_Requisition_DataType extends AbstractStructBase
{
    /**
     * The Job_Requisition_to_be_Moved_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Job Requisition that will be moved to a new Supervisory Organization.
     * @var \StructType\Job_RequisitionObjectType
     */
    public $Job_Requisition_to_be_Moved_Reference;
    /**
     * The New_Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: A Job Requisition's Worker Type must be consistent with the proposed Supervisory Organization's hiring restrictions. | A Job Requisition cannot be moved to an Organization with an availability date later than it's recruiting start
     * date. | The Supervisory Organization where the Job Requisition will move.
     * @var \StructType\Supervisory_OrganizationObjectType
     */
    public $New_Supervisory_Organization_Reference;
    /**
     * Constructor method for Move_Job_Requisition_DataType
     * @uses Move_Job_Requisition_DataType::setJob_Requisition_to_be_Moved_Reference()
     * @uses Move_Job_Requisition_DataType::setNew_Supervisory_Organization_Reference()
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_to_be_Moved_Reference
     * @param \StructType\Supervisory_OrganizationObjectType $new_Supervisory_Organization_Reference
     */
    public function __construct(\StructType\Job_RequisitionObjectType $job_Requisition_to_be_Moved_Reference = null, \StructType\Supervisory_OrganizationObjectType $new_Supervisory_Organization_Reference = null)
    {
        $this
            ->setJob_Requisition_to_be_Moved_Reference($job_Requisition_to_be_Moved_Reference)
            ->setNew_Supervisory_Organization_Reference($new_Supervisory_Organization_Reference);
    }
    /**
     * Get Job_Requisition_to_be_Moved_Reference value
     * @return \StructType\Job_RequisitionObjectType|null
     */
    public function getJob_Requisition_to_be_Moved_Reference()
    {
        return $this->Job_Requisition_to_be_Moved_Reference;
    }
    /**
     * Set Job_Requisition_to_be_Moved_Reference value
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_to_be_Moved_Reference
     * @return \StructType\Move_Job_Requisition_DataType
     */
    public function setJob_Requisition_to_be_Moved_Reference(\StructType\Job_RequisitionObjectType $job_Requisition_to_be_Moved_Reference = null)
    {
        $this->Job_Requisition_to_be_Moved_Reference = $job_Requisition_to_be_Moved_Reference;
        return $this;
    }
    /**
     * Get New_Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType|null
     */
    public function getNew_Supervisory_Organization_Reference()
    {
        return $this->New_Supervisory_Organization_Reference;
    }
    /**
     * Set New_Supervisory_Organization_Reference value
     * @param \StructType\Supervisory_OrganizationObjectType $new_Supervisory_Organization_Reference
     * @return \StructType\Move_Job_Requisition_DataType
     */
    public function setNew_Supervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $new_Supervisory_Organization_Reference = null)
    {
        $this->New_Supervisory_Organization_Reference = $new_Supervisory_Organization_Reference;
        return $this;
    }
}
