<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Masked_Job_Requisition_Default_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the data an individual row of the Masked Job Requisition Defaults table.
 * @subpackage Structs
 */
class Masked_Job_Requisition_Default_DataType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: The order of the job requisition interview team session. | Order | The order for the Recruiting Self-Schedule Calendar Type. | The Row Order | An alphanumeric value indicating the order of this row.
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * @var string
     */
    public $Order;
    /**
     * The Condition_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Job Requisition Condition Rule evaluated by this row.
     * - minOccurs: 0
     * @var \StructType\Condition_RuleObjectType
     */
    public $Condition_Rule_Reference;
    /**
     * The Masked_Configuration_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Masked Recruiting Configuration to be returned if this row evaluates true.
     * - minOccurs: 0
     * @var \StructType\Masked_ConfigurationObjectType
     */
    public $Masked_Configuration_Reference;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comments about the row.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Masked_Job_Requisition_Default_DataType
     * @uses Masked_Job_Requisition_Default_DataType::setOrder()
     * @uses Masked_Job_Requisition_Default_DataType::setCondition_Rule_Reference()
     * @uses Masked_Job_Requisition_Default_DataType::setMasked_Configuration_Reference()
     * @uses Masked_Job_Requisition_Default_DataType::setComment()
     * @param string $order
     * @param \StructType\Condition_RuleObjectType $condition_Rule_Reference
     * @param \StructType\Masked_ConfigurationObjectType $masked_Configuration_Reference
     * @param string $comment
     */
    public function __construct($order = null, \StructType\Condition_RuleObjectType $condition_Rule_Reference = null, \StructType\Masked_ConfigurationObjectType $masked_Configuration_Reference = null, $comment = null)
    {
        $this
            ->setOrder($order)
            ->setCondition_Rule_Reference($condition_Rule_Reference)
            ->setMasked_Configuration_Reference($masked_Configuration_Reference)
            ->setComment($comment);
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Masked_Job_Requisition_Default_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($order) && mb_strlen($order) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Condition_Rule_Reference value
     * @return \StructType\Condition_RuleObjectType|null
     */
    public function getCondition_Rule_Reference()
    {
        return $this->Condition_Rule_Reference;
    }
    /**
     * Set Condition_Rule_Reference value
     * @param \StructType\Condition_RuleObjectType $condition_Rule_Reference
     * @return \StructType\Masked_Job_Requisition_Default_DataType
     */
    public function setCondition_Rule_Reference(\StructType\Condition_RuleObjectType $condition_Rule_Reference = null)
    {
        $this->Condition_Rule_Reference = $condition_Rule_Reference;
        return $this;
    }
    /**
     * Get Masked_Configuration_Reference value
     * @return \StructType\Masked_ConfigurationObjectType|null
     */
    public function getMasked_Configuration_Reference()
    {
        return $this->Masked_Configuration_Reference;
    }
    /**
     * Set Masked_Configuration_Reference value
     * @param \StructType\Masked_ConfigurationObjectType $masked_Configuration_Reference
     * @return \StructType\Masked_Job_Requisition_Default_DataType
     */
    public function setMasked_Configuration_Reference(\StructType\Masked_ConfigurationObjectType $masked_Configuration_Reference = null)
    {
        $this->Masked_Configuration_Reference = $masked_Configuration_Reference;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Masked_Job_Requisition_Default_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
