<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Masked_Configuration_Item_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for Masked Configuration Item Data
 * @subpackage Structs
 */
class Masked_Configuration_Item_DataType extends AbstractStructBase
{
    /**
     * The Recruiting_Stage_Reference
     * Meta information extracted from the WSDL
     * - documentation: Recruiting Stage for Masked Configuration Item
     * @var \StructType\Recruiting_Stage__Workday_Owned_ObjectType
     */
    public $Recruiting_Stage_Reference;
    /**
     * The Security_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Security Groups for Masked Configuration Item
     * - maxOccurs: unbounded
     * @var \StructType\Role_Based_Security_Group__Unconstrained_ObjectType[]
     */
    public $Security_Group_Reference;
    /**
     * Constructor method for Masked_Configuration_Item_DataType
     * @uses Masked_Configuration_Item_DataType::setRecruiting_Stage_Reference()
     * @uses Masked_Configuration_Item_DataType::setSecurity_Group_Reference()
     * @param \StructType\Recruiting_Stage__Workday_Owned_ObjectType $recruiting_Stage_Reference
     * @param \StructType\Role_Based_Security_Group__Unconstrained_ObjectType[] $security_Group_Reference
     */
    public function __construct(\StructType\Recruiting_Stage__Workday_Owned_ObjectType $recruiting_Stage_Reference = null, array $security_Group_Reference = array())
    {
        $this
            ->setRecruiting_Stage_Reference($recruiting_Stage_Reference)
            ->setSecurity_Group_Reference($security_Group_Reference);
    }
    /**
     * Get Recruiting_Stage_Reference value
     * @return \StructType\Recruiting_Stage__Workday_Owned_ObjectType|null
     */
    public function getRecruiting_Stage_Reference()
    {
        return $this->Recruiting_Stage_Reference;
    }
    /**
     * Set Recruiting_Stage_Reference value
     * @param \StructType\Recruiting_Stage__Workday_Owned_ObjectType $recruiting_Stage_Reference
     * @return \StructType\Masked_Configuration_Item_DataType
     */
    public function setRecruiting_Stage_Reference(\StructType\Recruiting_Stage__Workday_Owned_ObjectType $recruiting_Stage_Reference = null)
    {
        $this->Recruiting_Stage_Reference = $recruiting_Stage_Reference;
        return $this;
    }
    /**
     * Get Security_Group_Reference value
     * @return \StructType\Role_Based_Security_Group__Unconstrained_ObjectType[]|null
     */
    public function getSecurity_Group_Reference()
    {
        return $this->Security_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSecurity_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSecurity_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSecurity_Group_ReferenceForArrayConstraintsFromSetSecurity_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $masked_Configuration_Item_DataTypeSecurity_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$masked_Configuration_Item_DataTypeSecurity_Group_ReferenceItem instanceof \StructType\Role_Based_Security_Group__Unconstrained_ObjectType) {
                $invalidValues[] = is_object($masked_Configuration_Item_DataTypeSecurity_Group_ReferenceItem) ? get_class($masked_Configuration_Item_DataTypeSecurity_Group_ReferenceItem) : sprintf('%s(%s)', gettype($masked_Configuration_Item_DataTypeSecurity_Group_ReferenceItem), var_export($masked_Configuration_Item_DataTypeSecurity_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Security_Group_Reference property can only contain items of type \StructType\Role_Based_Security_Group__Unconstrained_ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Security_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Role_Based_Security_Group__Unconstrained_ObjectType[] $security_Group_Reference
     * @return \StructType\Masked_Configuration_Item_DataType
     */
    public function setSecurity_Group_Reference(array $security_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($security_Group_ReferenceArrayErrorMessage = self::validateSecurity_Group_ReferenceForArrayConstraintsFromSetSecurity_Group_Reference($security_Group_Reference))) {
            throw new \InvalidArgumentException($security_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Security_Group_Reference = $security_Group_Reference;
        return $this;
    }
    /**
     * Add item to Security_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Role_Based_Security_Group__Unconstrained_ObjectType $item
     * @return \StructType\Masked_Configuration_Item_DataType
     */
    public function addToSecurity_Group_Reference(\StructType\Role_Based_Security_Group__Unconstrained_ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Role_Based_Security_Group__Unconstrained_ObjectType) {
            throw new \InvalidArgumentException(sprintf('The Security_Group_Reference property can only contain items of type \StructType\Role_Based_Security_Group__Unconstrained_ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Security_Group_Reference[] = $item;
        return $this;
    }
}
