<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_Recommend_Interview_Settings_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains job requisition recommend interview settings data.
 * @subpackage Structs
 */
class Job_Requisition_Recommend_Interview_Settings_DataType extends AbstractStructBase
{
    /**
     * The Calendar_Event_Start_Time
     * Meta information extracted from the WSDL
     * - documentation: The recommend interview start time
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Calendar_Event_Start_Time;
    /**
     * The Calendar_Event_End_Time
     * Meta information extracted from the WSDL
     * - documentation: The recommend interview end time
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Calendar_Event_End_Time;
    /**
     * The Range_of_Dates_Reference
     * Meta information extracted from the WSDL
     * - documentation: The range of dates options for recommend interview
     * - minOccurs: 0
     * @var \StructType\Range_of_DatesObjectType
     */
    public $Range_of_Dates_Reference;
    /**
     * The Days_of_the_Week_Reference
     * Meta information extracted from the WSDL
     * - documentation: The days of the week options for recommended interview
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Day_of_the_WeekObjectType[]
     */
    public $Days_of_the_Week_Reference;
    /**
     * The Interview_Session_Order_Preference_Reference
     * Meta information extracted from the WSDL
     * - documentation: The interviewer order preference for recommend interview
     * - minOccurs: 0
     * @var \StructType\Interview_Session_Order_PreferenceObjectType
     */
    public $Interview_Session_Order_Preference_Reference;
    /**
     * The Interview_Room_Reference
     * Meta information extracted from the WSDL
     * - documentation: The interview room selection for recommend interview
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Interview_RoomObjectType[]
     */
    public $Interview_Room_Reference;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The location selection for recommend interview
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Location_Reference;
    /**
     * The Use_Same_Location
     * Meta information extracted from the WSDL
     * - documentation: The option to use same location for recommend interview
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Same_Location;
    /**
     * Constructor method for Job_Requisition_Recommend_Interview_Settings_DataType
     * @uses Job_Requisition_Recommend_Interview_Settings_DataType::setCalendar_Event_Start_Time()
     * @uses Job_Requisition_Recommend_Interview_Settings_DataType::setCalendar_Event_End_Time()
     * @uses Job_Requisition_Recommend_Interview_Settings_DataType::setRange_of_Dates_Reference()
     * @uses Job_Requisition_Recommend_Interview_Settings_DataType::setDays_of_the_Week_Reference()
     * @uses Job_Requisition_Recommend_Interview_Settings_DataType::setInterview_Session_Order_Preference_Reference()
     * @uses Job_Requisition_Recommend_Interview_Settings_DataType::setInterview_Room_Reference()
     * @uses Job_Requisition_Recommend_Interview_Settings_DataType::setLocation_Reference()
     * @uses Job_Requisition_Recommend_Interview_Settings_DataType::setUse_Same_Location()
     * @param string $calendar_Event_Start_Time
     * @param string $calendar_Event_End_Time
     * @param \StructType\Range_of_DatesObjectType $range_of_Dates_Reference
     * @param \StructType\Day_of_the_WeekObjectType[] $days_of_the_Week_Reference
     * @param \StructType\Interview_Session_Order_PreferenceObjectType $interview_Session_Order_Preference_Reference
     * @param \StructType\Interview_RoomObjectType[] $interview_Room_Reference
     * @param \StructType\LocationObjectType[] $location_Reference
     * @param bool $use_Same_Location
     */
    public function __construct($calendar_Event_Start_Time = null, $calendar_Event_End_Time = null, \StructType\Range_of_DatesObjectType $range_of_Dates_Reference = null, array $days_of_the_Week_Reference = array(), \StructType\Interview_Session_Order_PreferenceObjectType $interview_Session_Order_Preference_Reference = null, array $interview_Room_Reference = array(), array $location_Reference = array(), $use_Same_Location = null)
    {
        $this
            ->setCalendar_Event_Start_Time($calendar_Event_Start_Time)
            ->setCalendar_Event_End_Time($calendar_Event_End_Time)
            ->setRange_of_Dates_Reference($range_of_Dates_Reference)
            ->setDays_of_the_Week_Reference($days_of_the_Week_Reference)
            ->setInterview_Session_Order_Preference_Reference($interview_Session_Order_Preference_Reference)
            ->setInterview_Room_Reference($interview_Room_Reference)
            ->setLocation_Reference($location_Reference)
            ->setUse_Same_Location($use_Same_Location);
    }
    /**
     * Get Calendar_Event_Start_Time value
     * @return string|null
     */
    public function getCalendar_Event_Start_Time()
    {
        return $this->Calendar_Event_Start_Time;
    }
    /**
     * Set Calendar_Event_Start_Time value
     * @param string $calendar_Event_Start_Time
     * @return \StructType\Job_Requisition_Recommend_Interview_Settings_DataType
     */
    public function setCalendar_Event_Start_Time($calendar_Event_Start_Time = null)
    {
        // validation for constraint: string
        if (!is_null($calendar_Event_Start_Time) && !is_string($calendar_Event_Start_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calendar_Event_Start_Time, true), gettype($calendar_Event_Start_Time)), __LINE__);
        }
        $this->Calendar_Event_Start_Time = $calendar_Event_Start_Time;
        return $this;
    }
    /**
     * Get Calendar_Event_End_Time value
     * @return string|null
     */
    public function getCalendar_Event_End_Time()
    {
        return $this->Calendar_Event_End_Time;
    }
    /**
     * Set Calendar_Event_End_Time value
     * @param string $calendar_Event_End_Time
     * @return \StructType\Job_Requisition_Recommend_Interview_Settings_DataType
     */
    public function setCalendar_Event_End_Time($calendar_Event_End_Time = null)
    {
        // validation for constraint: string
        if (!is_null($calendar_Event_End_Time) && !is_string($calendar_Event_End_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calendar_Event_End_Time, true), gettype($calendar_Event_End_Time)), __LINE__);
        }
        $this->Calendar_Event_End_Time = $calendar_Event_End_Time;
        return $this;
    }
    /**
     * Get Range_of_Dates_Reference value
     * @return \StructType\Range_of_DatesObjectType|null
     */
    public function getRange_of_Dates_Reference()
    {
        return $this->Range_of_Dates_Reference;
    }
    /**
     * Set Range_of_Dates_Reference value
     * @param \StructType\Range_of_DatesObjectType $range_of_Dates_Reference
     * @return \StructType\Job_Requisition_Recommend_Interview_Settings_DataType
     */
    public function setRange_of_Dates_Reference(\StructType\Range_of_DatesObjectType $range_of_Dates_Reference = null)
    {
        $this->Range_of_Dates_Reference = $range_of_Dates_Reference;
        return $this;
    }
    /**
     * Get Days_of_the_Week_Reference value
     * @return \StructType\Day_of_the_WeekObjectType[]|null
     */
    public function getDays_of_the_Week_Reference()
    {
        return $this->Days_of_the_Week_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDays_of_the_Week_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDays_of_the_Week_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDays_of_the_Week_ReferenceForArrayConstraintsFromSetDays_of_the_Week_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Recommend_Interview_Settings_DataTypeDays_of_the_Week_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Recommend_Interview_Settings_DataTypeDays_of_the_Week_ReferenceItem instanceof \StructType\Day_of_the_WeekObjectType) {
                $invalidValues[] = is_object($job_Requisition_Recommend_Interview_Settings_DataTypeDays_of_the_Week_ReferenceItem) ? get_class($job_Requisition_Recommend_Interview_Settings_DataTypeDays_of_the_Week_ReferenceItem) : sprintf('%s(%s)', gettype($job_Requisition_Recommend_Interview_Settings_DataTypeDays_of_the_Week_ReferenceItem), var_export($job_Requisition_Recommend_Interview_Settings_DataTypeDays_of_the_Week_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Days_of_the_Week_Reference property can only contain items of type \StructType\Day_of_the_WeekObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Days_of_the_Week_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Day_of_the_WeekObjectType[] $days_of_the_Week_Reference
     * @return \StructType\Job_Requisition_Recommend_Interview_Settings_DataType
     */
    public function setDays_of_the_Week_Reference(array $days_of_the_Week_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($days_of_the_Week_ReferenceArrayErrorMessage = self::validateDays_of_the_Week_ReferenceForArrayConstraintsFromSetDays_of_the_Week_Reference($days_of_the_Week_Reference))) {
            throw new \InvalidArgumentException($days_of_the_Week_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Days_of_the_Week_Reference = $days_of_the_Week_Reference;
        return $this;
    }
    /**
     * Add item to Days_of_the_Week_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Day_of_the_WeekObjectType $item
     * @return \StructType\Job_Requisition_Recommend_Interview_Settings_DataType
     */
    public function addToDays_of_the_Week_Reference(\StructType\Day_of_the_WeekObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Day_of_the_WeekObjectType) {
            throw new \InvalidArgumentException(sprintf('The Days_of_the_Week_Reference property can only contain items of type \StructType\Day_of_the_WeekObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Days_of_the_Week_Reference[] = $item;
        return $this;
    }
    /**
     * Get Interview_Session_Order_Preference_Reference value
     * @return \StructType\Interview_Session_Order_PreferenceObjectType|null
     */
    public function getInterview_Session_Order_Preference_Reference()
    {
        return $this->Interview_Session_Order_Preference_Reference;
    }
    /**
     * Set Interview_Session_Order_Preference_Reference value
     * @param \StructType\Interview_Session_Order_PreferenceObjectType $interview_Session_Order_Preference_Reference
     * @return \StructType\Job_Requisition_Recommend_Interview_Settings_DataType
     */
    public function setInterview_Session_Order_Preference_Reference(\StructType\Interview_Session_Order_PreferenceObjectType $interview_Session_Order_Preference_Reference = null)
    {
        $this->Interview_Session_Order_Preference_Reference = $interview_Session_Order_Preference_Reference;
        return $this;
    }
    /**
     * Get Interview_Room_Reference value
     * @return \StructType\Interview_RoomObjectType[]|null
     */
    public function getInterview_Room_Reference()
    {
        return $this->Interview_Room_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInterview_Room_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview_Room_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterview_Room_ReferenceForArrayConstraintsFromSetInterview_Room_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Recommend_Interview_Settings_DataTypeInterview_Room_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Recommend_Interview_Settings_DataTypeInterview_Room_ReferenceItem instanceof \StructType\Interview_RoomObjectType) {
                $invalidValues[] = is_object($job_Requisition_Recommend_Interview_Settings_DataTypeInterview_Room_ReferenceItem) ? get_class($job_Requisition_Recommend_Interview_Settings_DataTypeInterview_Room_ReferenceItem) : sprintf('%s(%s)', gettype($job_Requisition_Recommend_Interview_Settings_DataTypeInterview_Room_ReferenceItem), var_export($job_Requisition_Recommend_Interview_Settings_DataTypeInterview_Room_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interview_Room_Reference property can only contain items of type \StructType\Interview_RoomObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interview_Room_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_RoomObjectType[] $interview_Room_Reference
     * @return \StructType\Job_Requisition_Recommend_Interview_Settings_DataType
     */
    public function setInterview_Room_Reference(array $interview_Room_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($interview_Room_ReferenceArrayErrorMessage = self::validateInterview_Room_ReferenceForArrayConstraintsFromSetInterview_Room_Reference($interview_Room_Reference))) {
            throw new \InvalidArgumentException($interview_Room_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Interview_Room_Reference = $interview_Room_Reference;
        return $this;
    }
    /**
     * Add item to Interview_Room_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_RoomObjectType $item
     * @return \StructType\Job_Requisition_Recommend_Interview_Settings_DataType
     */
    public function addToInterview_Room_Reference(\StructType\Interview_RoomObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Interview_RoomObjectType) {
            throw new \InvalidArgumentException(sprintf('The Interview_Room_Reference property can only contain items of type \StructType\Interview_RoomObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interview_Room_Reference[] = $item;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocation_ReferenceForArrayConstraintsFromSetLocation_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Recommend_Interview_Settings_DataTypeLocation_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Recommend_Interview_Settings_DataTypeLocation_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($job_Requisition_Recommend_Interview_Settings_DataTypeLocation_ReferenceItem) ? get_class($job_Requisition_Recommend_Interview_Settings_DataTypeLocation_ReferenceItem) : sprintf('%s(%s)', gettype($job_Requisition_Recommend_Interview_Settings_DataTypeLocation_ReferenceItem), var_export($job_Requisition_Recommend_Interview_Settings_DataTypeLocation_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $location_Reference
     * @return \StructType\Job_Requisition_Recommend_Interview_Settings_DataType
     */
    public function setLocation_Reference(array $location_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($location_ReferenceArrayErrorMessage = self::validateLocation_ReferenceForArrayConstraintsFromSetLocation_Reference($location_Reference))) {
            throw new \InvalidArgumentException($location_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Add item to Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Job_Requisition_Recommend_Interview_Settings_DataType
     */
    public function addToLocation_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location_Reference[] = $item;
        return $this;
    }
    /**
     * Get Use_Same_Location value
     * @return bool|null
     */
    public function getUse_Same_Location()
    {
        return $this->Use_Same_Location;
    }
    /**
     * Set Use_Same_Location value
     * @param bool $use_Same_Location
     * @return \StructType\Job_Requisition_Recommend_Interview_Settings_DataType
     */
    public function setUse_Same_Location($use_Same_Location = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Same_Location) && !is_bool($use_Same_Location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Same_Location, true), gettype($use_Same_Location)), __LINE__);
        }
        $this->Use_Same_Location = $use_Same_Location;
        return $this;
    }
}
