<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_Questionnaire_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Questionnaires to be used by Job Requisition for Internal and External Career Site Job Postings. For use by Recruiting customers only.
 * @subpackage Structs
 */
class Job_Requisition_Questionnaire_DataType extends AbstractStructBase
{
    /**
     * The Questionnaire_for_Internal_Career_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: The primary questionnaire associated with the job posting on the internal career site.
     * - minOccurs: 0
     * @var \StructType\QuestionnaireObjectType
     */
    public $Questionnaire_for_Internal_Career_Site_Reference;
    /**
     * The Secondary_Questionnaire_for_Internal_Career_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: The secondary questionnaire associated with the job posting on the internal career site.
     * - minOccurs: 0
     * @var \StructType\QuestionnaireObjectType
     */
    public $Secondary_Questionnaire_for_Internal_Career_Site_Reference;
    /**
     * The Questionnaire_for_External_Career_Sites_Reference
     * Meta information extracted from the WSDL
     * - documentation: The primary questionnaire associated with the job posting on external career sites.
     * - minOccurs: 0
     * @var \StructType\QuestionnaireObjectType
     */
    public $Questionnaire_for_External_Career_Sites_Reference;
    /**
     * The Secondary_Questionnaire_for_External_Career_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: The secondary questionnaire associated with the job posting on external career sites.
     * - minOccurs: 0
     * @var \StructType\QuestionnaireObjectType
     */
    public $Secondary_Questionnaire_for_External_Career_Site_Reference;
    /**
     * Constructor method for Job_Requisition_Questionnaire_DataType
     * @uses Job_Requisition_Questionnaire_DataType::setQuestionnaire_for_Internal_Career_Site_Reference()
     * @uses Job_Requisition_Questionnaire_DataType::setSecondary_Questionnaire_for_Internal_Career_Site_Reference()
     * @uses Job_Requisition_Questionnaire_DataType::setQuestionnaire_for_External_Career_Sites_Reference()
     * @uses Job_Requisition_Questionnaire_DataType::setSecondary_Questionnaire_for_External_Career_Site_Reference()
     * @param \StructType\QuestionnaireObjectType $questionnaire_for_Internal_Career_Site_Reference
     * @param \StructType\QuestionnaireObjectType $secondary_Questionnaire_for_Internal_Career_Site_Reference
     * @param \StructType\QuestionnaireObjectType $questionnaire_for_External_Career_Sites_Reference
     * @param \StructType\QuestionnaireObjectType $secondary_Questionnaire_for_External_Career_Site_Reference
     */
    public function __construct(\StructType\QuestionnaireObjectType $questionnaire_for_Internal_Career_Site_Reference = null, \StructType\QuestionnaireObjectType $secondary_Questionnaire_for_Internal_Career_Site_Reference = null, \StructType\QuestionnaireObjectType $questionnaire_for_External_Career_Sites_Reference = null, \StructType\QuestionnaireObjectType $secondary_Questionnaire_for_External_Career_Site_Reference = null)
    {
        $this
            ->setQuestionnaire_for_Internal_Career_Site_Reference($questionnaire_for_Internal_Career_Site_Reference)
            ->setSecondary_Questionnaire_for_Internal_Career_Site_Reference($secondary_Questionnaire_for_Internal_Career_Site_Reference)
            ->setQuestionnaire_for_External_Career_Sites_Reference($questionnaire_for_External_Career_Sites_Reference)
            ->setSecondary_Questionnaire_for_External_Career_Site_Reference($secondary_Questionnaire_for_External_Career_Site_Reference);
    }
    /**
     * Get Questionnaire_for_Internal_Career_Site_Reference value
     * @return \StructType\QuestionnaireObjectType|null
     */
    public function getQuestionnaire_for_Internal_Career_Site_Reference()
    {
        return $this->Questionnaire_for_Internal_Career_Site_Reference;
    }
    /**
     * Set Questionnaire_for_Internal_Career_Site_Reference value
     * @param \StructType\QuestionnaireObjectType $questionnaire_for_Internal_Career_Site_Reference
     * @return \StructType\Job_Requisition_Questionnaire_DataType
     */
    public function setQuestionnaire_for_Internal_Career_Site_Reference(\StructType\QuestionnaireObjectType $questionnaire_for_Internal_Career_Site_Reference = null)
    {
        $this->Questionnaire_for_Internal_Career_Site_Reference = $questionnaire_for_Internal_Career_Site_Reference;
        return $this;
    }
    /**
     * Get Secondary_Questionnaire_for_Internal_Career_Site_Reference value
     * @return \StructType\QuestionnaireObjectType|null
     */
    public function getSecondary_Questionnaire_for_Internal_Career_Site_Reference()
    {
        return $this->Secondary_Questionnaire_for_Internal_Career_Site_Reference;
    }
    /**
     * Set Secondary_Questionnaire_for_Internal_Career_Site_Reference value
     * @param \StructType\QuestionnaireObjectType $secondary_Questionnaire_for_Internal_Career_Site_Reference
     * @return \StructType\Job_Requisition_Questionnaire_DataType
     */
    public function setSecondary_Questionnaire_for_Internal_Career_Site_Reference(\StructType\QuestionnaireObjectType $secondary_Questionnaire_for_Internal_Career_Site_Reference = null)
    {
        $this->Secondary_Questionnaire_for_Internal_Career_Site_Reference = $secondary_Questionnaire_for_Internal_Career_Site_Reference;
        return $this;
    }
    /**
     * Get Questionnaire_for_External_Career_Sites_Reference value
     * @return \StructType\QuestionnaireObjectType|null
     */
    public function getQuestionnaire_for_External_Career_Sites_Reference()
    {
        return $this->Questionnaire_for_External_Career_Sites_Reference;
    }
    /**
     * Set Questionnaire_for_External_Career_Sites_Reference value
     * @param \StructType\QuestionnaireObjectType $questionnaire_for_External_Career_Sites_Reference
     * @return \StructType\Job_Requisition_Questionnaire_DataType
     */
    public function setQuestionnaire_for_External_Career_Sites_Reference(\StructType\QuestionnaireObjectType $questionnaire_for_External_Career_Sites_Reference = null)
    {
        $this->Questionnaire_for_External_Career_Sites_Reference = $questionnaire_for_External_Career_Sites_Reference;
        return $this;
    }
    /**
     * Get Secondary_Questionnaire_for_External_Career_Site_Reference value
     * @return \StructType\QuestionnaireObjectType|null
     */
    public function getSecondary_Questionnaire_for_External_Career_Site_Reference()
    {
        return $this->Secondary_Questionnaire_for_External_Career_Site_Reference;
    }
    /**
     * Set Secondary_Questionnaire_for_External_Career_Site_Reference value
     * @param \StructType\QuestionnaireObjectType $secondary_Questionnaire_for_External_Career_Site_Reference
     * @return \StructType\Job_Requisition_Questionnaire_DataType
     */
    public function setSecondary_Questionnaire_for_External_Career_Site_Reference(\StructType\QuestionnaireObjectType $secondary_Questionnaire_for_External_Career_Site_Reference = null)
    {
        $this->Secondary_Questionnaire_for_External_Career_Site_Reference = $secondary_Questionnaire_for_External_Career_Site_Reference;
        return $this;
    }
}
