<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Job_Requisition_Organizations_Data_for_Business_ProcessType StructType
 * Meta information extracted from the WSDL
 * - documentation: Containing element for the cost center and custom organizations related to the job requisition.
 * @subpackage Structs
 */
class Job_Requisition_Organizations_Data_for_Business_ProcessType extends AbstractStructBase
{
    /**
     * The Organization_Assignments_for_Job_Requisition_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Organization_Assignments_for_Job_Requisition_DataType
     */
    public $Organization_Assignments_for_Job_Requisition_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: If yes, deletes existing organizations before the data in this web service is processed.
     * @var bool
     */
    public $Replace_All;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If Yes, previous organizations are copied to this business process except for organization references.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for
     * Job_Requisition_Organizations_Data_for_Business_ProcessType
     * @uses Job_Requisition_Organizations_Data_for_Business_ProcessType::setOrganization_Assignments_for_Job_Requisition_Data()
     * @uses Job_Requisition_Organizations_Data_for_Business_ProcessType::setReplace_All()
     * @uses Job_Requisition_Organizations_Data_for_Business_ProcessType::setDelete()
     * @param \StructType\Organization_Assignments_for_Job_Requisition_DataType $organization_Assignments_for_Job_Requisition_Data
     * @param bool $replace_All
     * @param bool $delete
     */
    public function __construct(\StructType\Organization_Assignments_for_Job_Requisition_DataType $organization_Assignments_for_Job_Requisition_Data = null, $replace_All = null, $delete = null)
    {
        $this
            ->setOrganization_Assignments_for_Job_Requisition_Data($organization_Assignments_for_Job_Requisition_Data)
            ->setReplace_All($replace_All)
            ->setDelete($delete);
    }
    /**
     * Get Organization_Assignments_for_Job_Requisition_Data value
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType|null
     */
    public function getOrganization_Assignments_for_Job_Requisition_Data()
    {
        return $this->Organization_Assignments_for_Job_Requisition_Data;
    }
    /**
     * Set Organization_Assignments_for_Job_Requisition_Data value
     * @param \StructType\Organization_Assignments_for_Job_Requisition_DataType $organization_Assignments_for_Job_Requisition_Data
     * @return \StructType\Job_Requisition_Organizations_Data_for_Business_ProcessType
     */
    public function setOrganization_Assignments_for_Job_Requisition_Data(\StructType\Organization_Assignments_for_Job_Requisition_DataType $organization_Assignments_for_Job_Requisition_Data = null)
    {
        $this->Organization_Assignments_for_Job_Requisition_Data = $organization_Assignments_for_Job_Requisition_Data;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Job_Requisition_Organizations_Data_for_Business_ProcessType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Job_Requisition_Organizations_Data_for_Business_ProcessType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
