<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_Interview_Team_Session_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the reference id, order, interviewers, duration, interview type, alternate interviewers, and comment data for the job requisition interview team session.
 * @subpackage Structs
 */
class Job_Requisition_Interview_Team_Session_DataType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Interview_Session_ID
     * Meta information extracted from the WSDL
     * - documentation: The reference id of the job requisition interview team session.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Requisition_Interview_Session_ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: The order of the job requisition interview team session. | Order | The order for the Recruiting Self-Schedule Calendar Type. | The Row Order | An alphanumeric value indicating the order of this row.
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Interviewer_Reference
     * Meta information extracted from the WSDL
     * - documentation: The interviewers for the job requisition interview team session.
     * - maxOccurs: unbounded
     * @var \StructType\WorkerObjectType[]
     */
    public $Interviewer_Reference;
    /**
     * The Duration_in_Minutes
     * Meta information extracted from the WSDL
     * - documentation: The duration of the job requisition interview team session in minutes.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $Duration_in_Minutes;
    /**
     * The Interview_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The interview type for the job requisition team session.
     * - minOccurs: 0
     * @var \StructType\Interview_TypeObjectType
     */
    public $Interview_Type_Reference;
    /**
     * The Alternate_Interviewer_Reference
     * Meta information extracted from the WSDL
     * - documentation: The alternate interviewers on the job requisition interview team session.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Alternate_Interviewer_Reference;
    /**
     * The Competencies_Reference
     * Meta information extracted from the WSDL
     * - documentation: Interview competencies for the job requisition interview session.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompetencyObjectType[]
     */
    public $Competencies_Reference;
    /**
     * The Questionnaires_Reference
     * Meta information extracted from the WSDL
     * - documentation: Interview Questionnaires for the job requisition interview session.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\QuestionnaireObjectType[]
     */
    public $Questionnaires_Reference;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comments for the interviewers and alternate interviewers on the job requisition interview team session.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Job_Requisition_Interview_Team_Session_DataType
     * @uses Job_Requisition_Interview_Team_Session_DataType::setJob_Requisition_Interview_Session_ID()
     * @uses Job_Requisition_Interview_Team_Session_DataType::setOrder()
     * @uses Job_Requisition_Interview_Team_Session_DataType::setInterviewer_Reference()
     * @uses Job_Requisition_Interview_Team_Session_DataType::setDuration_in_Minutes()
     * @uses Job_Requisition_Interview_Team_Session_DataType::setInterview_Type_Reference()
     * @uses Job_Requisition_Interview_Team_Session_DataType::setAlternate_Interviewer_Reference()
     * @uses Job_Requisition_Interview_Team_Session_DataType::setCompetencies_Reference()
     * @uses Job_Requisition_Interview_Team_Session_DataType::setQuestionnaires_Reference()
     * @uses Job_Requisition_Interview_Team_Session_DataType::setComment()
     * @param string $job_Requisition_Interview_Session_ID
     * @param string $order
     * @param \StructType\WorkerObjectType[] $interviewer_Reference
     * @param float $duration_in_Minutes
     * @param \StructType\Interview_TypeObjectType $interview_Type_Reference
     * @param \StructType\WorkerObjectType[] $alternate_Interviewer_Reference
     * @param \StructType\CompetencyObjectType[] $competencies_Reference
     * @param \StructType\QuestionnaireObjectType[] $questionnaires_Reference
     * @param string $comment
     */
    public function __construct($job_Requisition_Interview_Session_ID = null, $order = null, array $interviewer_Reference = array(), $duration_in_Minutes = null, \StructType\Interview_TypeObjectType $interview_Type_Reference = null, array $alternate_Interviewer_Reference = array(), array $competencies_Reference = array(), array $questionnaires_Reference = array(), $comment = null)
    {
        $this
            ->setJob_Requisition_Interview_Session_ID($job_Requisition_Interview_Session_ID)
            ->setOrder($order)
            ->setInterviewer_Reference($interviewer_Reference)
            ->setDuration_in_Minutes($duration_in_Minutes)
            ->setInterview_Type_Reference($interview_Type_Reference)
            ->setAlternate_Interviewer_Reference($alternate_Interviewer_Reference)
            ->setCompetencies_Reference($competencies_Reference)
            ->setQuestionnaires_Reference($questionnaires_Reference)
            ->setComment($comment);
    }
    /**
     * Get Job_Requisition_Interview_Session_ID value
     * @return string|null
     */
    public function getJob_Requisition_Interview_Session_ID()
    {
        return $this->Job_Requisition_Interview_Session_ID;
    }
    /**
     * Set Job_Requisition_Interview_Session_ID value
     * @param string $job_Requisition_Interview_Session_ID
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function setJob_Requisition_Interview_Session_ID($job_Requisition_Interview_Session_ID = null)
    {
        // validation for constraint: string
        if (!is_null($job_Requisition_Interview_Session_ID) && !is_string($job_Requisition_Interview_Session_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Requisition_Interview_Session_ID, true), gettype($job_Requisition_Interview_Session_ID)), __LINE__);
        }
        $this->Job_Requisition_Interview_Session_ID = $job_Requisition_Interview_Session_ID;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($order) && mb_strlen($order) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Interviewer_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getInterviewer_Reference()
    {
        return $this->Interviewer_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInterviewer_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterviewer_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterviewer_ReferenceForArrayConstraintsFromSetInterviewer_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Interview_Team_Session_DataTypeInterviewer_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Interview_Team_Session_DataTypeInterviewer_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($job_Requisition_Interview_Team_Session_DataTypeInterviewer_ReferenceItem) ? get_class($job_Requisition_Interview_Team_Session_DataTypeInterviewer_ReferenceItem) : sprintf('%s(%s)', gettype($job_Requisition_Interview_Team_Session_DataTypeInterviewer_ReferenceItem), var_export($job_Requisition_Interview_Team_Session_DataTypeInterviewer_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interviewer_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interviewer_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $interviewer_Reference
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function setInterviewer_Reference(array $interviewer_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($interviewer_ReferenceArrayErrorMessage = self::validateInterviewer_ReferenceForArrayConstraintsFromSetInterviewer_Reference($interviewer_Reference))) {
            throw new \InvalidArgumentException($interviewer_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Interviewer_Reference = $interviewer_Reference;
        return $this;
    }
    /**
     * Add item to Interviewer_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function addToInterviewer_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Interviewer_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interviewer_Reference[] = $item;
        return $this;
    }
    /**
     * Get Duration_in_Minutes value
     * @return float|null
     */
    public function getDuration_in_Minutes()
    {
        return $this->Duration_in_Minutes;
    }
    /**
     * Set Duration_in_Minutes value
     * @param float $duration_in_Minutes
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function setDuration_in_Minutes($duration_in_Minutes = null)
    {
        // validation for constraint: float
        if (!is_null($duration_in_Minutes) && !(is_float($duration_in_Minutes) || is_numeric($duration_in_Minutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duration_in_Minutes, true), gettype($duration_in_Minutes)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($duration_in_Minutes) && mb_strlen(mb_substr($duration_in_Minutes, false !== mb_strpos($duration_in_Minutes, '.') ? mb_strpos($duration_in_Minutes, '.') + 1 : mb_strlen($duration_in_Minutes))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($duration_in_Minutes, true), mb_strlen(mb_substr($duration_in_Minutes, mb_strpos($duration_in_Minutes, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($duration_in_Minutes) && $duration_in_Minutes < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($duration_in_Minutes, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($duration_in_Minutes) && mb_strlen(preg_replace('/(\D)/', '', $duration_in_Minutes)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($duration_in_Minutes, true), mb_strlen(preg_replace('/(\D)/', '', $duration_in_Minutes))), __LINE__);
        }
        $this->Duration_in_Minutes = $duration_in_Minutes;
        return $this;
    }
    /**
     * Get Interview_Type_Reference value
     * @return \StructType\Interview_TypeObjectType|null
     */
    public function getInterview_Type_Reference()
    {
        return $this->Interview_Type_Reference;
    }
    /**
     * Set Interview_Type_Reference value
     * @param \StructType\Interview_TypeObjectType $interview_Type_Reference
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function setInterview_Type_Reference(\StructType\Interview_TypeObjectType $interview_Type_Reference = null)
    {
        $this->Interview_Type_Reference = $interview_Type_Reference;
        return $this;
    }
    /**
     * Get Alternate_Interviewer_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getAlternate_Interviewer_Reference()
    {
        return $this->Alternate_Interviewer_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Interviewer_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Interviewer_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Interviewer_ReferenceForArrayConstraintsFromSetAlternate_Interviewer_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Interview_Team_Session_DataTypeAlternate_Interviewer_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Interview_Team_Session_DataTypeAlternate_Interviewer_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($job_Requisition_Interview_Team_Session_DataTypeAlternate_Interviewer_ReferenceItem) ? get_class($job_Requisition_Interview_Team_Session_DataTypeAlternate_Interviewer_ReferenceItem) : sprintf('%s(%s)', gettype($job_Requisition_Interview_Team_Session_DataTypeAlternate_Interviewer_ReferenceItem), var_export($job_Requisition_Interview_Team_Session_DataTypeAlternate_Interviewer_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Interviewer_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Interviewer_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $alternate_Interviewer_Reference
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function setAlternate_Interviewer_Reference(array $alternate_Interviewer_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Interviewer_ReferenceArrayErrorMessage = self::validateAlternate_Interviewer_ReferenceForArrayConstraintsFromSetAlternate_Interviewer_Reference($alternate_Interviewer_Reference))) {
            throw new \InvalidArgumentException($alternate_Interviewer_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Interviewer_Reference = $alternate_Interviewer_Reference;
        return $this;
    }
    /**
     * Add item to Alternate_Interviewer_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function addToAlternate_Interviewer_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Interviewer_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Interviewer_Reference[] = $item;
        return $this;
    }
    /**
     * Get Competencies_Reference value
     * @return \StructType\CompetencyObjectType[]|null
     */
    public function getCompetencies_Reference()
    {
        return $this->Competencies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompetencies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompetencies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompetencies_ReferenceForArrayConstraintsFromSetCompetencies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Interview_Team_Session_DataTypeCompetencies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Interview_Team_Session_DataTypeCompetencies_ReferenceItem instanceof \StructType\CompetencyObjectType) {
                $invalidValues[] = is_object($job_Requisition_Interview_Team_Session_DataTypeCompetencies_ReferenceItem) ? get_class($job_Requisition_Interview_Team_Session_DataTypeCompetencies_ReferenceItem) : sprintf('%s(%s)', gettype($job_Requisition_Interview_Team_Session_DataTypeCompetencies_ReferenceItem), var_export($job_Requisition_Interview_Team_Session_DataTypeCompetencies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Competencies_Reference property can only contain items of type \StructType\CompetencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Competencies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompetencyObjectType[] $competencies_Reference
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function setCompetencies_Reference(array $competencies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($competencies_ReferenceArrayErrorMessage = self::validateCompetencies_ReferenceForArrayConstraintsFromSetCompetencies_Reference($competencies_Reference))) {
            throw new \InvalidArgumentException($competencies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Competencies_Reference = $competencies_Reference;
        return $this;
    }
    /**
     * Add item to Competencies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompetencyObjectType $item
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function addToCompetencies_Reference(\StructType\CompetencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompetencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Competencies_Reference property can only contain items of type \StructType\CompetencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Competencies_Reference[] = $item;
        return $this;
    }
    /**
     * Get Questionnaires_Reference value
     * @return \StructType\QuestionnaireObjectType[]|null
     */
    public function getQuestionnaires_Reference()
    {
        return $this->Questionnaires_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setQuestionnaires_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuestionnaires_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuestionnaires_ReferenceForArrayConstraintsFromSetQuestionnaires_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Interview_Team_Session_DataTypeQuestionnaires_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Interview_Team_Session_DataTypeQuestionnaires_ReferenceItem instanceof \StructType\QuestionnaireObjectType) {
                $invalidValues[] = is_object($job_Requisition_Interview_Team_Session_DataTypeQuestionnaires_ReferenceItem) ? get_class($job_Requisition_Interview_Team_Session_DataTypeQuestionnaires_ReferenceItem) : sprintf('%s(%s)', gettype($job_Requisition_Interview_Team_Session_DataTypeQuestionnaires_ReferenceItem), var_export($job_Requisition_Interview_Team_Session_DataTypeQuestionnaires_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Questionnaires_Reference property can only contain items of type \StructType\QuestionnaireObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Questionnaires_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionnaireObjectType[] $questionnaires_Reference
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function setQuestionnaires_Reference(array $questionnaires_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($questionnaires_ReferenceArrayErrorMessage = self::validateQuestionnaires_ReferenceForArrayConstraintsFromSetQuestionnaires_Reference($questionnaires_Reference))) {
            throw new \InvalidArgumentException($questionnaires_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Questionnaires_Reference = $questionnaires_Reference;
        return $this;
    }
    /**
     * Add item to Questionnaires_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionnaireObjectType $item
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function addToQuestionnaires_Reference(\StructType\QuestionnaireObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QuestionnaireObjectType) {
            throw new \InvalidArgumentException(sprintf('The Questionnaires_Reference property can only contain items of type \StructType\QuestionnaireObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Questionnaires_Reference[] = $item;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
