<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Site_Detail_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds all relevant details for a Job Posting Site.
 * @subpackage Structs
 */
class Job_Posting_Site_Detail_DataType extends AbstractStructBase
{
    /**
     * The Job_Posting_Site_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of Job Posting Site
     * - maxOccurs: 1
     * @var string
     */
    public $Job_Posting_Site_Name;
    /**
     * The Job_Posting_Site_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for Job Posting Site
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_Site_ID;
    /**
     * The Contract_ID
     * Meta information extracted from the WSDL
     * - documentation: Contract ID for Job Posting Site
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_ID;
    /**
     * The Job_Posting_Cost
     * Meta information extracted from the WSDL
     * - documentation: The cost of hosting a posting on a Job Posting Site
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Job_Posting_Cost;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The default currency used on a Job Posting Site
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Recruiting_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The recruiting source for a Job Posting Site
     * - minOccurs: 0
     * @var \StructType\Applicant_SourceObjectType
     */
    public $Recruiting_Source_Reference;
    /**
     * The Job_Posting_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: The template used for Job Posting Site
     * @var \StructType\Job_Posting_TemplateObjectType
     */
    public $Job_Posting_Template_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Whether or not the Job Posting Site is currently active or inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Job_Posting_Site_Detail_DataType
     * @uses Job_Posting_Site_Detail_DataType::setJob_Posting_Site_Name()
     * @uses Job_Posting_Site_Detail_DataType::setJob_Posting_Site_ID()
     * @uses Job_Posting_Site_Detail_DataType::setContract_ID()
     * @uses Job_Posting_Site_Detail_DataType::setJob_Posting_Cost()
     * @uses Job_Posting_Site_Detail_DataType::setCurrency_Reference()
     * @uses Job_Posting_Site_Detail_DataType::setRecruiting_Source_Reference()
     * @uses Job_Posting_Site_Detail_DataType::setJob_Posting_Template_Reference()
     * @uses Job_Posting_Site_Detail_DataType::setInactive()
     * @param string $job_Posting_Site_Name
     * @param string $job_Posting_Site_ID
     * @param string $contract_ID
     * @param float $job_Posting_Cost
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Applicant_SourceObjectType $recruiting_Source_Reference
     * @param \StructType\Job_Posting_TemplateObjectType $job_Posting_Template_Reference
     * @param bool $inactive
     */
    public function __construct($job_Posting_Site_Name = null, $job_Posting_Site_ID = null, $contract_ID = null, $job_Posting_Cost = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Applicant_SourceObjectType $recruiting_Source_Reference = null, \StructType\Job_Posting_TemplateObjectType $job_Posting_Template_Reference = null, $inactive = null)
    {
        $this
            ->setJob_Posting_Site_Name($job_Posting_Site_Name)
            ->setJob_Posting_Site_ID($job_Posting_Site_ID)
            ->setContract_ID($contract_ID)
            ->setJob_Posting_Cost($job_Posting_Cost)
            ->setCurrency_Reference($currency_Reference)
            ->setRecruiting_Source_Reference($recruiting_Source_Reference)
            ->setJob_Posting_Template_Reference($job_Posting_Template_Reference)
            ->setInactive($inactive);
    }
    /**
     * Get Job_Posting_Site_Name value
     * @return string|null
     */
    public function getJob_Posting_Site_Name()
    {
        return $this->Job_Posting_Site_Name;
    }
    /**
     * Set Job_Posting_Site_Name value
     * @param string $job_Posting_Site_Name
     * @return \StructType\Job_Posting_Site_Detail_DataType
     */
    public function setJob_Posting_Site_Name($job_Posting_Site_Name = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Site_Name) && !is_string($job_Posting_Site_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Site_Name, true), gettype($job_Posting_Site_Name)), __LINE__);
        }
        $this->Job_Posting_Site_Name = $job_Posting_Site_Name;
        return $this;
    }
    /**
     * Get Job_Posting_Site_ID value
     * @return string|null
     */
    public function getJob_Posting_Site_ID()
    {
        return $this->Job_Posting_Site_ID;
    }
    /**
     * Set Job_Posting_Site_ID value
     * @param string $job_Posting_Site_ID
     * @return \StructType\Job_Posting_Site_Detail_DataType
     */
    public function setJob_Posting_Site_ID($job_Posting_Site_ID = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Site_ID) && !is_string($job_Posting_Site_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Site_ID, true), gettype($job_Posting_Site_ID)), __LINE__);
        }
        $this->Job_Posting_Site_ID = $job_Posting_Site_ID;
        return $this;
    }
    /**
     * Get Contract_ID value
     * @return string|null
     */
    public function getContract_ID()
    {
        return $this->Contract_ID;
    }
    /**
     * Set Contract_ID value
     * @param string $contract_ID
     * @return \StructType\Job_Posting_Site_Detail_DataType
     */
    public function setContract_ID($contract_ID = null)
    {
        // validation for constraint: string
        if (!is_null($contract_ID) && !is_string($contract_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_ID, true), gettype($contract_ID)), __LINE__);
        }
        $this->Contract_ID = $contract_ID;
        return $this;
    }
    /**
     * Get Job_Posting_Cost value
     * @return float|null
     */
    public function getJob_Posting_Cost()
    {
        return $this->Job_Posting_Cost;
    }
    /**
     * Set Job_Posting_Cost value
     * @param float $job_Posting_Cost
     * @return \StructType\Job_Posting_Site_Detail_DataType
     */
    public function setJob_Posting_Cost($job_Posting_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($job_Posting_Cost) && !(is_float($job_Posting_Cost) || is_numeric($job_Posting_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($job_Posting_Cost, true), gettype($job_Posting_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($job_Posting_Cost) && mb_strlen(mb_substr($job_Posting_Cost, false !== mb_strpos($job_Posting_Cost, '.') ? mb_strpos($job_Posting_Cost, '.') + 1 : mb_strlen($job_Posting_Cost))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($job_Posting_Cost, true), mb_strlen(mb_substr($job_Posting_Cost, mb_strpos($job_Posting_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($job_Posting_Cost) && $job_Posting_Cost < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($job_Posting_Cost, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($job_Posting_Cost) && mb_strlen(preg_replace('/(\D)/', '', $job_Posting_Cost)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($job_Posting_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $job_Posting_Cost))), __LINE__);
        }
        $this->Job_Posting_Cost = $job_Posting_Cost;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Job_Posting_Site_Detail_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Recruiting_Source_Reference value
     * @return \StructType\Applicant_SourceObjectType|null
     */
    public function getRecruiting_Source_Reference()
    {
        return $this->Recruiting_Source_Reference;
    }
    /**
     * Set Recruiting_Source_Reference value
     * @param \StructType\Applicant_SourceObjectType $recruiting_Source_Reference
     * @return \StructType\Job_Posting_Site_Detail_DataType
     */
    public function setRecruiting_Source_Reference(\StructType\Applicant_SourceObjectType $recruiting_Source_Reference = null)
    {
        $this->Recruiting_Source_Reference = $recruiting_Source_Reference;
        return $this;
    }
    /**
     * Get Job_Posting_Template_Reference value
     * @return \StructType\Job_Posting_TemplateObjectType|null
     */
    public function getJob_Posting_Template_Reference()
    {
        return $this->Job_Posting_Template_Reference;
    }
    /**
     * Set Job_Posting_Template_Reference value
     * @param \StructType\Job_Posting_TemplateObjectType $job_Posting_Template_Reference
     * @return \StructType\Job_Posting_Site_Detail_DataType
     */
    public function setJob_Posting_Template_Reference(\StructType\Job_Posting_TemplateObjectType $job_Posting_Template_Reference = null)
    {
        $this->Job_Posting_Template_Reference = $job_Posting_Template_Reference;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Job_Posting_Site_Detail_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
