<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Site_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Enter an End Date that is after the Start Date. | A Job Posting has dates that overlap with 1 or more Job Postings for the same site. | Select another Job Posting Site because only an External Career Site can be designated as the
 * Primary Posting. | A Job Posting Site Name was entered, but there are no Job Posting Sites in the current tenant with the specified name. | Container for Job Posting Site Data.
 * @subpackage Structs
 */
class Job_Posting_Site_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier to reference a Job Posting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Job_Posting_Site_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the Job Posting Site. Specify the Job Posting Site by entering data here or in the Job Posting Site Reference.
     * - choice: Job_Posting_Site_Name | Job_Posting_Site_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var string
     */
    public $Job_Posting_Site_Name;
    /**
     * The Job_Posting_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: You can't post this requisition to this recruiting agency because this recruiting agency doesn't support confidential job postings. Use the Edit Recruiting Agency task to enable confidential job postings for this recruiting agency. |
     * Invalid agency posting site, please ensure the agency is active and/or update the agency location restrictions to match the job requisition to initiate this action. | Another Job Posting exists for the specified date range. Please update the existing
     * posting or select a different date range. | Reference to the Job Posting Site. Specify the Job Posting Site by entering data here or entering the Job Posting Site Name.
     * - choice: Job_Posting_Site_Name | Job_Posting_Site_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_Posting_SiteObjectType
     */
    public $Job_Posting_Site_Reference;
    /**
     * The Job_Posting_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Select a start date that's on or after the current date of the primary location for the job requisition. | Job Posting Start Date must be on or after Recruiting Start Date. | Start date of the job posting. Must be after today.
     * - maxOccurs: 1
     * @var string
     */
    public $Job_Posting_Start_Date;
    /**
     * The Job_Posting_End_Date
     * Meta information extracted from the WSDL
     * - documentation: End date of the Job Posting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_End_Date;
    /**
     * The Primary_Posting
     * Meta information extracted from the WSDL
     * - documentation: Job posting is the default job posting used for social share and invite to apply referrals. Will return false until post job business process is complete.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Primary_Posting;
    /**
     * The Forecasted_Payout
     * Meta information extracted from the WSDL
     * - documentation: The Forecasted Agency Payout on a Job Posting. Calculated at time of posting or updated later. The Currency for this value is stored separately on the Job Posting.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Forecasted_Payout;
    /**
     * The Agency_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Currency for the Forecasted Agency Payout stored on the Job Posting.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Agency_Currency_Reference;
    /**
     * Constructor method for Job_Posting_Site_DataType
     * @uses Job_Posting_Site_DataType::setID()
     * @uses Job_Posting_Site_DataType::setJob_Posting_Site_Name()
     * @uses Job_Posting_Site_DataType::setJob_Posting_Site_Reference()
     * @uses Job_Posting_Site_DataType::setJob_Posting_Start_Date()
     * @uses Job_Posting_Site_DataType::setJob_Posting_End_Date()
     * @uses Job_Posting_Site_DataType::setPrimary_Posting()
     * @uses Job_Posting_Site_DataType::setForecasted_Payout()
     * @uses Job_Posting_Site_DataType::setAgency_Currency_Reference()
     * @param string $iD
     * @param string $job_Posting_Site_Name
     * @param \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @param string $job_Posting_Start_Date
     * @param string $job_Posting_End_Date
     * @param bool $primary_Posting
     * @param float $forecasted_Payout
     * @param \StructType\CurrencyObjectType $agency_Currency_Reference
     */
    public function __construct($iD = null, $job_Posting_Site_Name = null, \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference = null, $job_Posting_Start_Date = null, $job_Posting_End_Date = null, $primary_Posting = null, $forecasted_Payout = null, \StructType\CurrencyObjectType $agency_Currency_Reference = null)
    {
        $this
            ->setID($iD)
            ->setJob_Posting_Site_Name($job_Posting_Site_Name)
            ->setJob_Posting_Site_Reference($job_Posting_Site_Reference)
            ->setJob_Posting_Start_Date($job_Posting_Start_Date)
            ->setJob_Posting_End_Date($job_Posting_End_Date)
            ->setPrimary_Posting($primary_Posting)
            ->setForecasted_Payout($forecasted_Payout)
            ->setAgency_Currency_Reference($agency_Currency_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Job_Posting_Site_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Job_Posting_Site_Name value
     * @return string|null
     */
    public function getJob_Posting_Site_Name()
    {
        return isset($this->Job_Posting_Site_Name) ? $this->Job_Posting_Site_Name : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Posting_Site_Name method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Site_Name method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Posting_Site_NameForChoiceConstraintsFromSetJob_Posting_Site_Name($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Posting_Site_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Posting_Site_Name can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Posting_Site_Name, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Posting_Site_Name value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $job_Posting_Site_Name
     * @return \StructType\Job_Posting_Site_DataType
     */
    public function setJob_Posting_Site_Name($job_Posting_Site_Name = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Site_Name) && !is_string($job_Posting_Site_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Site_Name, true), gettype($job_Posting_Site_Name)), __LINE__);
        }
        // validation for constraint: choice(Job_Posting_Site_Name, Job_Posting_Site_Reference)
        if ('' !== ($job_Posting_Site_NameChoiceErrorMessage = self::validateJob_Posting_Site_NameForChoiceConstraintsFromSetJob_Posting_Site_Name($job_Posting_Site_Name))) {
            throw new \InvalidArgumentException($job_Posting_Site_NameChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Posting_Site_Name) || (is_array($job_Posting_Site_Name) && empty($job_Posting_Site_Name))) {
            unset($this->Job_Posting_Site_Name);
        } else {
            $this->Job_Posting_Site_Name = $job_Posting_Site_Name;
        }
        return $this;
    }
    /**
     * Get Job_Posting_Site_Reference value
     * @return \StructType\Job_Posting_SiteObjectType|null
     */
    public function getJob_Posting_Site_Reference()
    {
        return isset($this->Job_Posting_Site_Reference) ? $this->Job_Posting_Site_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Posting_Site_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Site_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Posting_Site_ReferenceForChoiceConstraintsFromSetJob_Posting_Site_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Posting_Site_Name',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Posting_Site_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Posting_Site_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Posting_Site_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @return \StructType\Job_Posting_Site_DataType
     */
    public function setJob_Posting_Site_Reference(\StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference = null)
    {
        // validation for constraint: choice(Job_Posting_Site_Name, Job_Posting_Site_Reference)
        if ('' !== ($job_Posting_Site_ReferenceChoiceErrorMessage = self::validateJob_Posting_Site_ReferenceForChoiceConstraintsFromSetJob_Posting_Site_Reference($job_Posting_Site_Reference))) {
            throw new \InvalidArgumentException($job_Posting_Site_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Posting_Site_Reference) || (is_array($job_Posting_Site_Reference) && empty($job_Posting_Site_Reference))) {
            unset($this->Job_Posting_Site_Reference);
        } else {
            $this->Job_Posting_Site_Reference = $job_Posting_Site_Reference;
        }
        return $this;
    }
    /**
     * Get Job_Posting_Start_Date value
     * @return string|null
     */
    public function getJob_Posting_Start_Date()
    {
        return $this->Job_Posting_Start_Date;
    }
    /**
     * Set Job_Posting_Start_Date value
     * @param string $job_Posting_Start_Date
     * @return \StructType\Job_Posting_Site_DataType
     */
    public function setJob_Posting_Start_Date($job_Posting_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Start_Date) && !is_string($job_Posting_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Start_Date, true), gettype($job_Posting_Start_Date)), __LINE__);
        }
        $this->Job_Posting_Start_Date = $job_Posting_Start_Date;
        return $this;
    }
    /**
     * Get Job_Posting_End_Date value
     * @return string|null
     */
    public function getJob_Posting_End_Date()
    {
        return $this->Job_Posting_End_Date;
    }
    /**
     * Set Job_Posting_End_Date value
     * @param string $job_Posting_End_Date
     * @return \StructType\Job_Posting_Site_DataType
     */
    public function setJob_Posting_End_Date($job_Posting_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_End_Date) && !is_string($job_Posting_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_End_Date, true), gettype($job_Posting_End_Date)), __LINE__);
        }
        $this->Job_Posting_End_Date = $job_Posting_End_Date;
        return $this;
    }
    /**
     * Get Primary_Posting value
     * @return bool|null
     */
    public function getPrimary_Posting()
    {
        return $this->Primary_Posting;
    }
    /**
     * Set Primary_Posting value
     * @param bool $primary_Posting
     * @return \StructType\Job_Posting_Site_DataType
     */
    public function setPrimary_Posting($primary_Posting = null)
    {
        // validation for constraint: boolean
        if (!is_null($primary_Posting) && !is_bool($primary_Posting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primary_Posting, true), gettype($primary_Posting)), __LINE__);
        }
        $this->Primary_Posting = $primary_Posting;
        return $this;
    }
    /**
     * Get Forecasted_Payout value
     * @return float|null
     */
    public function getForecasted_Payout()
    {
        return $this->Forecasted_Payout;
    }
    /**
     * Set Forecasted_Payout value
     * @param float $forecasted_Payout
     * @return \StructType\Job_Posting_Site_DataType
     */
    public function setForecasted_Payout($forecasted_Payout = null)
    {
        // validation for constraint: float
        if (!is_null($forecasted_Payout) && !(is_float($forecasted_Payout) || is_numeric($forecasted_Payout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($forecasted_Payout, true), gettype($forecasted_Payout)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($forecasted_Payout) && mb_strlen(mb_substr($forecasted_Payout, false !== mb_strpos($forecasted_Payout, '.') ? mb_strpos($forecasted_Payout, '.') + 1 : mb_strlen($forecasted_Payout))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($forecasted_Payout, true), mb_strlen(mb_substr($forecasted_Payout, mb_strpos($forecasted_Payout, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($forecasted_Payout) && $forecasted_Payout < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($forecasted_Payout, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($forecasted_Payout) && mb_strlen(preg_replace('/(\D)/', '', $forecasted_Payout)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($forecasted_Payout, true), mb_strlen(preg_replace('/(\D)/', '', $forecasted_Payout))), __LINE__);
        }
        $this->Forecasted_Payout = $forecasted_Payout;
        return $this;
    }
    /**
     * Get Agency_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getAgency_Currency_Reference()
    {
        return $this->Agency_Currency_Reference;
    }
    /**
     * Set Agency_Currency_Reference value
     * @param \StructType\CurrencyObjectType $agency_Currency_Reference
     * @return \StructType\Job_Posting_Site_DataType
     */
    public function setAgency_Currency_Reference(\StructType\CurrencyObjectType $agency_Currency_Reference = null)
    {
        $this->Agency_Currency_Reference = $agency_Currency_Reference;
        return $this;
    }
}
