<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains each Job Posting based on the Request References or Request Criteria.
 * @subpackage Structs
 */
class Job_Posting_Response_DataType extends AbstractStructBase
{
    /**
     * The Job_Posting
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_PostingType[]
     */
    public $Job_Posting;
    /**
     * Constructor method for Job_Posting_Response_DataType
     * @uses Job_Posting_Response_DataType::setJob_Posting()
     * @param \StructType\Job_PostingType[] $job_Posting
     */
    public function __construct(array $job_Posting = array())
    {
        $this
            ->setJob_Posting($job_Posting);
    }
    /**
     * Get Job_Posting value
     * @return \StructType\Job_PostingType[]|null
     */
    public function getJob_Posting()
    {
        return $this->Job_Posting;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Posting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_PostingForArrayConstraintsFromSetJob_Posting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Response_DataTypeJob_PostingItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Response_DataTypeJob_PostingItem instanceof \StructType\Job_PostingType) {
                $invalidValues[] = is_object($job_Posting_Response_DataTypeJob_PostingItem) ? get_class($job_Posting_Response_DataTypeJob_PostingItem) : sprintf('%s(%s)', gettype($job_Posting_Response_DataTypeJob_PostingItem), var_export($job_Posting_Response_DataTypeJob_PostingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Posting property can only contain items of type \StructType\Job_PostingType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Posting value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_PostingType[] $job_Posting
     * @return \StructType\Job_Posting_Response_DataType
     */
    public function setJob_Posting(array $job_Posting = array())
    {
        // validation for constraint: array
        if ('' !== ($job_PostingArrayErrorMessage = self::validateJob_PostingForArrayConstraintsFromSetJob_Posting($job_Posting))) {
            throw new \InvalidArgumentException($job_PostingArrayErrorMessage, __LINE__);
        }
        $this->Job_Posting = $job_Posting;
        return $this;
    }
    /**
     * Add item to Job_Posting value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_PostingType $item
     * @return \StructType\Job_Posting_Response_DataType
     */
    public function addToJob_Posting(\StructType\Job_PostingType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_PostingType) {
            throw new \InvalidArgumentException(sprintf('The Job_Posting property can only contain items of type \StructType\Job_PostingType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Posting[] = $item;
        return $this;
    }
}
